/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ucf;

import [Ljava.lang.Object;;
import com.adobe.argv.Arguments;
import com.adobe.argv.UsageError;
import com.adobe.ucf.ISigner;
import com.adobe.ucf.Packager;
import com.adobe.ucf.UCFPackager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;

public class UCF {
    public static final String PATH_MIMETYPE = "mimetype";
    public static final String PATH_SIGNATURES = "META-INF/signatures.xml";
    public static final int ERROR_UNKNOWN = 5;
    public static final int ERROR_DEST = 6;
    public static final int ERROR_CERT_ACCESS = 7;
    public static final int ERROR_INVALID_CERT = 8;
    public static final int ERROR_CODE_SIGN = 9;
    public static final int ERROR_TIMESTAMP_GEN = 10;
    public static final int ERROR_CERTIFICATE_GEN = 11;
    public static final int ERROR_INVALID_INPUT = 12;
    protected static final String ARG_STORETYPE = "-storetype";
    protected static final String ARG_KEYSTORE = "-keystore";
    protected static final String ARG_STOREPASS = "-storepass";
    protected static final String ARG_KEYPASS = "-keypass";
    protected static final String ARG_PROVIDER_NAME = "-providerName";
    protected static final String ARG_ALIAS = "-alias";
    protected static final String ARG_TIMESTAMPURL = "-tsa";
    protected static final String CHANGE_DIR = "-C";
    protected static final String RENAME = "-e";
    protected static final String HELP = "-help";
    protected static final String TSA_NONE = "none";
    protected Arguments args;
    protected File cwd = new File(System.getProperty("user.dir"));
    private Packager m_packager;

    public static String stringFromInputStream(InputStream is) throws IOException {
        int bytesRead;
        StringBuffer result = new StringBuffer();
        InputStreamReader reader = new InputStreamReader(is);
        char[] charBuf = new char[4096];
        while ((bytesRead = reader.read(charBuf)) != -1) {
            result.append(charBuf, 0, bytesRead);
        }
        return result.toString();
    }

    public static void main(String[] args) {
        UCF ucf = new UCF(new UCFPackager());
        ucf.doPackage(args);
        System.exit(0);
    }

    protected UCF(Packager p2) {
        this.m_packager = p2;
    }

    protected void printUsage() {
        System.err.println("usage:");
        System.err.println("  ucf -package ( -storetype <type> ( -keystore <store> )? ( -storepass <pass> )? ( -keypass <pass> )? ( -providerName <name> )? ( -tsa <url> )? )? <ucf-file> <fileOrDir>* (( -C <dir> <fileOrDir>+ ) | ( -e <file> <path> ))*");
        System.err.println("  ucf -help");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doPackage(String[] argv) {
        block10: {
            this.args = new Arguments(argv);
            try {
                this.cwd = new File(System.getProperty("user.dir"));
                if (!this.args.peek()) {
                    this.printUsage();
                    break block10;
                }
                if (this.args.peek(HELP)) {
                    this.parseUsage();
                    break block10;
                }
                if (this.args.peek("-package")) {
                    this.parsePackage();
                    ((UCFPackager)this.m_packager).createPackage();
                    break block10;
                }
                throw new UsageError("unexpected argument " + this.args.accept());
            }
            catch (UsageError e2) {
                System.err.println(e2.getMessage());
                this.printUsage();
                int n2 = e2.getExitCode();
                return n2;
            }
            catch (Exception e3) {
                System.err.println("Packaging failed: " + e3.getMessage());
                e3.printStackTrace();
                int n3 = 5;
                return n3;
            }
            finally {
                this.m_packager.close();
            }
        }
        return 0;
    }

    protected void parseUsage() throws UsageError {
        this.args.accept(HELP);
        this.printUsage();
    }

    private void parsePackage() throws UsageError {
        this.args.accept("-package");
        if (this.args.peek(ARG_STORETYPE)) {
            this.parseSigningOptions(this.getPackager());
        }
        try {
            this.m_packager.setOutput(new File(this.args.accept()));
        }
        catch (IOException ex) {
            throw new UsageError("unable to create temp file in output directory", 6);
        }
        this.parseFileArguments();
    }

    protected void parseSigningOptions(ISigner p2) throws UsageError {
        String storeType = null;
        String keyStoreFile = null;
        String storePass = null;
        String keyPass = null;
        String providerName = null;
        String alias = null;
        String timestampURL = null;
        while (true) {
            if (this.args.peek(ARG_STORETYPE)) {
                if (storeType != null) {
                    throw new UsageError("-storetype already specified");
                }
                this.args.accept(ARG_STORETYPE);
                storeType = this.args.accept();
                continue;
            }
            if (this.args.peek(ARG_KEYSTORE)) {
                if (keyStoreFile != null) {
                    throw new UsageError("-keystore already specified");
                }
                this.args.accept(ARG_KEYSTORE);
                keyStoreFile = this.args.accept();
                continue;
            }
            if (this.args.peek(ARG_STOREPASS)) {
                if (storePass != null) {
                    throw new UsageError("-storepass already specified");
                }
                this.args.accept(ARG_STOREPASS);
                storePass = this.args.accept();
                continue;
            }
            if (this.args.peek(ARG_KEYPASS)) {
                if (keyPass != null) {
                    throw new UsageError("-keypass already specified");
                }
                this.args.accept(ARG_KEYPASS);
                keyPass = this.args.accept();
                continue;
            }
            if (this.args.peek(ARG_PROVIDER_NAME)) {
                if (providerName != null) {
                    throw new UsageError("-providerName already specified");
                }
                this.args.accept(ARG_PROVIDER_NAME);
                providerName = this.args.accept();
                continue;
            }
            if (this.args.peek(ARG_ALIAS)) {
                if (alias != null) {
                    throw new UsageError("-alias already specified");
                }
                this.args.accept(ARG_ALIAS);
                alias = this.args.accept();
                continue;
            }
            if (!this.args.peek(ARG_TIMESTAMPURL)) break;
            if (timestampURL != null) {
                throw new UsageError("-tsa already specified");
            }
            this.args.accept(ARG_TIMESTAMPURL);
            timestampURL = this.args.accept();
        }
        if (storeType == null) {
            throw new UsageError("-storetype is required");
        }
        if (storePass == null) {
            storePass = this.readPassword();
        }
        KeyStore keyStore = null;
        try {
            keyStore = providerName == null ? KeyStore.getInstance(storeType) : KeyStore.getInstance(storeType, providerName);
        }
        catch (KeyStoreException ex) {
            throw new UsageError("requested keystore type is not available", 7);
        }
        catch (NoSuchProviderException ex) {
            throw new UsageError("requested provider is not available", 7);
        }
        try {
            try {
                keyStore.load(keyStoreFile == null ? null : new FileInputStream(keyStoreFile), storePass.toCharArray());
            }
            catch (IOException ex) {
                throw new UsageError("could not load keystore file (password may be incorrect)", 7);
            }
            catch (CertificateException ex) {
                throw new UsageError("unable to load a certificate in this file", 7);
            }
            if (alias == null) {
                if (!keyStore.aliases().hasMoreElements()) {
                    throw new UsageError("The key could not be obtained. You may need to use the -keystore argument with the specified keystore type.", 7);
                }
                alias = keyStore.aliases().nextElement();
            }
            try {
                String pass = keyPass != null ? keyPass : storePass;
                PrivateKey key = (PrivateKey)keyStore.getKey(alias, pass.toCharArray());
                if (p2 != null) {
                    p2.setPrivateKey(key);
                }
            }
            catch (UnrecoverableKeyException ex) {
                throw new UsageError("unable to retrieve key (password may be incorrect)", 7);
            }
            try {
                if (p2 != null) {
                    p2.setSignerCertificate(keyStore.getCertificate(alias));
                }
                if (p2 != null) {
                    p2.setCertificateChain(keyStore.getCertificateChain(alias));
                }
            }
            catch (CertificateExpiredException ex) {
                throw new UsageError("certificate has expired", 8);
            }
            catch (CertificateNotYetValidException ex) {
                throw new UsageError("certificate is not yet valid", 8);
            }
            catch (CertificateException ex) {
                throw new UsageError("not an X509 code-signing certificate", 8);
            }
            if (timestampURL != null) {
                p2.setTimestampURL(TSA_NONE.equals(timestampURL) ? null : timestampURL);
            }
        }
        catch (KeyStoreException ex) {
            throw new RuntimeException("aliases accessed before keystore was loaded");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new UsageError("required crypto algorithm not available", 7);
        }
    }

    protected void parseFileArguments() throws UsageError {
        if (!this.args.peek()) {
            throw new UsageError("at least one file is required");
        }
        this.parseOptionalFileList();
        while (this.args.peek()) {
            this.parseCORE();
        }
    }

    protected void parseFileList() throws UsageError {
        this.addFileOrDir(this.cwd, new File(this.args.accept()));
        this.parseOptionalFileList();
    }

    protected void parseOptionalFileList() throws UsageError {
        while (!this.args.peek(RENAME) && !this.args.peek(CHANGE_DIR) && this.args.peek()) {
            this.addFileOrDir(this.cwd, new File(this.args.accept()));
        }
    }

    protected void parseCORE() throws UsageError {
        if (this.args.peek(CHANGE_DIR)) {
            this.args.accept(CHANGE_DIR);
            this.cwd = new File(this.args.accept());
            this.parseFileList();
        } else if (this.args.peek(RENAME)) {
            this.args.accept(RENAME);
            this.m_packager.addSourceWithPath(new File(this.args.accept()), this.args.accept());
        } else {
            throw new UsageError("unexpected argument " + this.args.accept());
        }
    }

    protected String readPassword() throws UsageError {
        String password = null;
        try {
            Object theConsole = System.class.getMethod("console", new Class[0]).invoke(null, (Object[])null);
            if (theConsole != null) {
                Method readPasswordMethod = theConsole.getClass().getMethod("readPassword", String.class, Object;.class);
                password = String.copyValueOf((char[])readPasswordMethod.invoke(theConsole, "password: ", null));
            }
        }
        catch (IllegalArgumentException e2) {
        }
        catch (SecurityException e3) {
        }
        catch (IllegalAccessException e4) {
        }
        catch (InvocationTargetException e5) {
        }
        catch (NoSuchMethodException e6) {
            // empty catch block
        }
        if (password == null) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("password: ");
                password = reader.readLine();
            }
            catch (IOException ex) {
                throw new UsageError("could not read password from console", 7);
            }
        }
        return password;
    }

    protected void addFileOrDir(File cwd, File file) throws UsageError {
        if (!file.isAbsolute()) {
            file = new File(cwd, file.getPath());
        }
        if (!file.exists()) {
            throw new UsageError("no such file " + file.getPath());
        }
        if ((file = new File(file.toURI().normalize().getPath())).isHidden()) {
            return;
        }
        if (file.isFile()) {
            try {
                this.m_packager.addSourceWithRoot(file, cwd);
            }
            catch (IllegalArgumentException e2) {
                throw new UsageError(e2.getLocalizedMessage() + ": " + file.getPath());
            }
            return;
        }
        File[] dirContents = file.listFiles();
        for (int idx = 0; idx < dirContents.length; ++idx) {
            this.addFileOrDir(cwd, dirContents[idx]);
        }
    }

    protected Packager getPackager() {
        return this.m_packager;
    }
}

