/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pki;

import com.adobe.pki.PKIFailureInfo;
import com.adobe.pki.TimestampException;
import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.UTF8StringContainer;
import java.io.UnsupportedEncodingException;

public class TimestampResponse {
    private EncodedContainer timestampTokenDER = null;
    private byte[] timestampTokenBytes;
    private int status = 3;
    private String statusString = "";
    private String failureString;
    private boolean isValid = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TimestampResponse(byte[] response) throws TimestampException {
        if (response == null) {
            throw new IllegalArgumentException("Response cannot be null");
        }
        EncodedContainer statusInfo = new EncodedContainer(12288);
        EncodedContainer tst = new EncodedContainer(77824);
        ASN1Container[] asn1resp = new ASN1Container[]{new SequenceContainer(0), statusInfo, tst, new EndContainer()};
        try {
            ASN1.berDecode(response, 0, asn1resp);
        }
        catch (ASN_Exception e2) {
            throw new TimestampException("Cannot parse the response");
        }
        if (!statusInfo.dataPresent) throw new TimestampException("Status not present in timestamp");
        try {
            IntegerContainer pkiStatus = new IntegerContainer(0);
            OfContainer pkiFreeText = new OfContainer(65536, 12288, new UTF8StringContainer(0));
            BitStringContainer pkiFailureInfo = new BitStringContainer(65536);
            ASN1Container[] asn1StatusInfo = new ASN1Container[]{new SequenceContainer(0), pkiStatus, pkiFreeText, pkiFailureInfo, new EndContainer()};
            ASN1.berDecode(statusInfo.data, statusInfo.dataOffset, asn1StatusInfo);
            this.status = pkiStatus.getValueAsInt();
            if (pkiFreeText.dataPresent) {
                for (int i2 = 0; i2 < pkiFreeText.getContainerCount(); ++i2) {
                    try {
                        UTF8StringContainer cont = (UTF8StringContainer)pkiFreeText.containerAt(i2);
                        this.statusString = this.statusString + new String(cont.data, cont.dataOffset, cont.dataLen, "UTF-8") + "\n";
                        continue;
                    }
                    catch (UnsupportedEncodingException e3) {
                        // empty catch block
                    }
                }
            }
            if (pkiFailureInfo.dataPresent) {
                this.failureString = PKIFailureInfo.getFailureString(pkiFailureInfo.getValueAsInt());
            }
        }
        catch (ASN_Exception e4) {
            throw new TimestampException("Cannot parse the timestamp status");
        }
        if (this.status == 0 || this.status == 1) {
            if (!tst.dataPresent) {
                throw new TimestampException("TSP response is invalid as No TimestampInfo is present");
            }
            this.timestampTokenDER = tst;
            this.isValid = true;
            return;
        } else {
            if (!tst.dataPresent && this.status >= 0 && this.status <= 5) return;
            throw new TimestampException("TSP response is invalid.");
        }
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusString() {
        return this.statusString;
    }

    public String getFailureInfo() {
        return this.failureString;
    }

    public EncodedContainer getDERTimestampToken() {
        return this.timestampTokenDER;
    }

    public byte[] getTimestampTokenBytes() {
        if (this.timestampTokenBytes == null) {
            this.timestampTokenBytes = new byte[this.timestampTokenDER.dataLen];
            System.arraycopy(this.timestampTokenDER.data, this.timestampTokenDER.dataOffset, this.timestampTokenBytes, 0, this.timestampTokenDER.dataLen);
        }
        return this.timestampTokenBytes;
    }

    public boolean isValid() {
        return this.isValid;
    }
}

