/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.validator;

import com.adobe.air.Listener;
import com.adobe.air.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class ApplicationDescriptorValidator
extends DefaultHandler {
    private static final String NAME_PATTERN = "[^\\*\"/:<>\\?\\\\|\\. ]|[^\\*\"/:<>\\?\\\\| ][^\\*\"/:<>\\?\\\\|]*[^\\*\"/:<>\\?\\\\|\\. ]";
    private static final String APP_ID_PATTERN = "[A-Za-z0-9\\-\\.]{1,212}";
    private static final String PUB_ID_PATTERN = "[A-Fa-f0-9]{40}\\.1";
    private static final String FOLDER_TYPE_PATTERN = "[^\\*\"/:<>\\?\\\\|\\. ]|[^\\*\"/:<>\\?\\\\| ][^\\*\":<>\\?\\\\|]*[^\\*\":<>\\?\\\\|\\./ ]";
    private static final String FILE_TYPE_NAME_PATTERN = "[A-Za-z][A-Za-z0-9\\.]{0,38}";
    private static final String EXTENSION_PATTERN = "[A-Za-z0-9]{1,38}";
    private static final String LANGUAGE_PATTERN = "[A-Za-z]{2,3}([\\-\\_][A-Za-z]{4})?([\\-\\_]([A-Za-z]{2}|[0-9]{3}))?";
    private Listener listener;
    private Locator locator;
    private File descriptor;
    private Map sources;
    private boolean hasRootElement = false;
    private boolean inErrorState = false;
    private int errorElementLevel;
    private ElementInfo currentElementInfo;
    private StringBuffer content = new StringBuffer();
    protected static final String SYSTEM_CHROME_NONE = "none";
    protected static final String SYSTEM_CHROME_STANDARD = "standard";
    private static final int SIGNATURE_IHDR_LENGTH = 33;
    private static final byte[] PNG_SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final int WIDTH_FIELD_OFFSET = 16;
    private static final int HEIGHT_FIELD_OFFSET = 20;

    private String getElementPath() {
        StringBuffer pathBuffer = new StringBuffer();
        ElementInfo elementInfo = this.currentElementInfo;
        while (elementInfo != null) {
            pathBuffer.insert(0, elementInfo.name);
            if ((elementInfo = elementInfo.parent) == null) continue;
            pathBuffer.insert(0, ".");
        }
        return pathBuffer.toString();
    }

    private static int bytesToInt(byte[] bytes, int offset) {
        int value = bytes[offset];
        value = (value << 8) + (bytes[offset + 1] & 0xFF);
        value = (value << 8) + (bytes[offset + 2] & 0xFF);
        value = (value << 8) + (bytes[offset + 3] & 0xFF);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validateIconFile(File file, String dimensionString, String uriValue) {
        block16: {
            block15: {
                block14: {
                    fis = null;
                    try {
                        try {
                            fis = new FileInputStream(file);
                            preamble = new byte[33];
                            if (fis.read(preamble) != 33) {
                                this.dispatchError(202, new String[]{uriValue});
                                var12_7 = null;
                                break block14;
                            }
                            for (i = 0; i < ApplicationDescriptorValidator.PNG_SIGNATURE.length; ++i) {
                                if (preamble[i] == ApplicationDescriptorValidator.PNG_SIGNATURE[i]) continue;
                                this.dispatchError(202, new String[]{uriValue});
                                break block15;
                            }
                            dimensions = dimensionString.split("x");
                            requiredWidth = Integer.parseInt(dimensions[0]);
                            requiredHeight = Integer.parseInt(dimensions[1]);
                            width = ApplicationDescriptorValidator.bytesToInt(preamble, 16);
                            height = ApplicationDescriptorValidator.bytesToInt(preamble, 20);
                            if (width != requiredWidth || height != requiredHeight) {
                                this.dispatchError(201, new String[]{uriValue});
                            }
                            break block16;
                        }
                        catch (Exception e) {
                            this.dispatchError(200, new String[]{uriValue});
                            var12_10 = null;
                            try {
                                if (fis == null) return;
                                fis.close();
                                return;
                            }
                            catch (Exception e) {
                                return;
                            }
                        }
                    }
                    catch (Throwable var11_23) {
                        var12_11 = null;
                        ** try [egrp 2[TRYBLOCK] [8 : 213->226)] { 
lbl38:
                        // 1 sources

                        if (fis == null) throw var11_23;
                        fis.close();
                        throw var11_23;
lbl41:
                        // 1 sources

                        catch (Exception e) {
                            // empty catch block
                        }
                        throw var11_23;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [8 : 213->226)] { 
lbl46:
                // 1 sources

                if (fis == null) return;
                fis.close();
                return;
lbl49:
                // 1 sources

                catch (Exception e) {
                    // empty catch block
                }
                return;
            }
            var12_8 = null;
            ** try [egrp 2[TRYBLOCK] [8 : 213->226)] { 
lbl55:
            // 1 sources

            if (fis == null) return;
            fis.close();
            return;
lbl58:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        var12_9 = null;
        try {}
        catch (Exception e) {}
        if (fis == null) return;
        fis.close();
        return;
    }

    public final void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.inErrorState) {
            this.content.append(ch, start, length);
            String newContent = new String(ch, start, length).trim();
            if (newContent.length() != 0) {
                if (this.currentElementInfo.contentTypeMixed) {
                    Collection allowableElements = this.currentElementInfo.getChildren();
                    Iterator it = allowableElements.iterator();
                    while (it.hasNext()) {
                        NodeInfo nodeInfo = (NodeInfo)it.next();
                        if (nodeInfo.count <= 0) continue;
                        this.dispatchError(105, new String[]{this.getElementPath()});
                    }
                } else if (this.currentElementInfo.hasChildren()) {
                    this.dispatchError(105, new String[]{this.getElementPath()});
                }
            }
        }
    }

    public final void endDocument() throws SAXException {
        if (!this.hasRootElement) {
            this.dispatchError(104, new String[]{this.getRootElementInfo().name});
        }
    }

    public final void endElement(String uri, String localName, String qName) throws SAXException {
        --this.errorElementLevel;
        if (!this.inErrorState) {
            String elementPath = this.getElementPath();
            String elementValue = this.content.toString();
            if (!(this.currentElementInfo.hasChildren() && !this.currentElementInfo.contentTypeMixed || this.validateElement(elementPath, elementValue))) {
                this.dispatchError(105, new String[]{elementPath});
            }
            Collection allowableElements = this.currentElementInfo.getChildren();
            Iterator it = allowableElements.iterator();
            while (it.hasNext()) {
                ElementInfo elementInfo = (ElementInfo)it.next();
                if (elementInfo.count >= elementInfo.minOccurs) continue;
                this.dispatchError(104, new String[]{elementPath + "." + elementInfo.name});
            }
            this.content.setLength(0);
            this.currentElementInfo = this.currentElementInfo.parent;
        }
        if (this.inErrorState && this.errorElementLevel == 0) {
            this.inErrorState = false;
        }
    }

    public final void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public final void setDescriptor(File descriptor) {
        this.descriptor = descriptor;
    }

    public final void setListener(Listener listener) {
        this.listener = listener;
    }

    public final void setSources(Map sources) {
        this.sources = sources;
    }

    public final void startDocument() throws SAXException {
    }

    public final void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String elementPath = null;
        if (!this.inErrorState) {
            elementPath = this.getElementPath();
            if (this.currentElementInfo == null) {
                ElementInfo rootElementInfo = this.getRootElementInfo();
                if (!rootElementInfo.name.equals(localName)) {
                    this.dispatchError(103, new String[]{localName});
                    this.inErrorState = true;
                    this.errorElementLevel = 0;
                } else {
                    this.currentElementInfo = rootElementInfo;
                    this.hasRootElement = true;
                }
            } else {
                ElementInfo elementInfo;
                if (this.content.toString().trim().length() > 0) {
                    this.dispatchError(105, new String[]{elementPath});
                }
                if ((elementInfo = this.currentElementInfo.getChild(localName)) != null) {
                    ++elementInfo.count;
                    if (elementInfo.maxOccurs != -1 && elementInfo.count > elementInfo.maxOccurs) {
                        this.dispatchError(103, new String[]{elementPath + "." + localName});
                        this.inErrorState = true;
                        this.errorElementLevel = 0;
                    } else {
                        this.currentElementInfo = elementInfo;
                    }
                } else {
                    this.dispatchError(103, new String[]{elementPath + "." + localName});
                    this.inErrorState = true;
                    this.errorElementLevel = 0;
                }
            }
        }
        if (!this.inErrorState) {
            Collection allowableAttributes = this.currentElementInfo.getAttributes();
            Iterator attrIt = allowableAttributes.iterator();
            while (attrIt.hasNext()) {
                NodeInfo nodeInfo = (NodeInfo)attrIt.next();
                nodeInfo.count = 0;
            }
            elementPath = this.getElementPath();
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                String attributeName = attributes.getQName(i2);
                String attributePath = elementPath + "@" + attributeName;
                AttributeInfo attributeInfo = this.currentElementInfo.getAttribute(attributeName);
                if (attributeInfo != null) {
                    ++attributeInfo.count;
                    if (this.validateAttribute(attributePath, attributes.getValue(i2))) continue;
                    this.dispatchError(105, new String[]{attributePath});
                    continue;
                }
                this.dispatchError(103, new String[]{attributePath});
            }
            attrIt = allowableAttributes.iterator();
            while (attrIt.hasNext()) {
                AttributeInfo attributeInfo = (AttributeInfo)attrIt.next();
                if (!attributeInfo.required || attributeInfo.count != 0) continue;
                this.dispatchError(104, new String[]{elementPath + "@" + attributeInfo.name});
            }
            Collection allowableElements = this.currentElementInfo.getChildren();
            Iterator it = allowableElements.iterator();
            while (it.hasNext()) {
                NodeInfo nodeInfo = (NodeInfo)it.next();
                nodeInfo.count = 0;
            }
            this.content.setLength(0);
        }
        ++this.errorElementLevel;
    }

    protected void dispatchError(int code, String[] identifiers) {
        if (this.listener != null) {
            Message message = new Message(code, "ERROR", this.descriptor.getPath(), this.locator.getLineNumber(), this.locator.getColumnNumber(), identifiers);
            this.listener.message(message);
        }
    }

    protected URI validateUri(String uriString) {
        URI APP_RESOURCE_URI = URI.create("app:/");
        String uriValue = uriString.trim();
        URI uri = null;
        try {
            uri = APP_RESOURCE_URI.resolve(uriValue);
        }
        catch (IllegalArgumentException e2) {
            // empty catch block
        }
        if (uri == null || !uri.getScheme().equals(APP_RESOURCE_URI.getScheme())) {
            this.dispatchError(105, new String[]{this.getElementPath()});
        }
        return uri;
    }

    protected void validateRootContent(String rootContent) {
        URI uri = this.validateUri(rootContent);
        if (uri == null) {
            return;
        }
        String uriPath = uri.getPath().substring(1);
        if (!this.sources.containsKey(uriPath)) {
            this.dispatchError(302, new String[]{rootContent.trim()});
            return;
        }
        File file = (File)this.sources.get(uriPath);
        try {
            boolean isSWF;
            FileInputStream fs = new FileInputStream(file);
            byte[] firstBytes = new byte[4];
            fs.read(firstBytes);
            fs.close();
            boolean bl2 = isSWF = (firstBytes[0] == 70 || firstBytes[0] == 67) && firstBytes[1] == 87 && firstBytes[2] == 83;
            if (isSWF) {
                byte version = firstBytes[3];
                if (version == 0) {
                    this.dispatchError(304, new String[0]);
                    return;
                }
                if (version > this.getMaximumSWFVersion()) {
                    this.dispatchError(305, new String[]{Integer.toString(version), this.getNamespace()});
                    return;
                }
            } else {
                boolean isPNG;
                boolean isGIF = firstBytes[0] == 71 && firstBytes[1] == 73 && firstBytes[2] == 70;
                boolean isTIFFM = firstBytes[0] == 77 && firstBytes[1] == 77 && firstBytes[2] == 0 && firstBytes[3] == 42;
                boolean isTIFFI = firstBytes[0] == 73 && firstBytes[1] == 73 && firstBytes[2] == 42 && firstBytes[3] == 0;
                boolean isJPEG = firstBytes[0] == -1 && firstBytes[1] == -40;
                boolean bl3 = isPNG = firstBytes[0] == -119 && firstBytes[1] == 80 && firstBytes[2] == 78 && firstBytes[3] == 71;
                if (isGIF || isTIFFM || isTIFFI || isJPEG || isPNG) {
                    this.dispatchError(304, new String[0]);
                }
            }
        }
        catch (IOException ex) {
            this.dispatchError(300, new String[]{rootContent.trim()});
        }
    }

    protected void validateImage(String image) {
        URI uri = this.validateUri(image);
        if (uri == null) {
            return;
        }
        String uriPath = uri.getPath().substring(1);
        if (!this.sources.containsKey(uriPath)) {
            this.dispatchError(303, new String[]{image.trim()});
            return;
        }
        File file = (File)this.sources.get(uriPath);
        String dimensionString = this.currentElementInfo.name.substring(5);
        this.validateIconFile(file, dimensionString, image.trim());
    }

    protected static boolean validateName(String name) {
        return name.matches(NAME_PATTERN);
    }

    protected static boolean validateAppId(String appId) {
        return appId.matches(APP_ID_PATTERN);
    }

    protected static boolean validatePublisherId(String pubId) {
        return pubId.matches(PUB_ID_PATTERN);
    }

    protected static boolean validateSystemChrome(String systemChrome) {
        return systemChrome.equals(SYSTEM_CHROME_NONE) || systemChrome.equals(SYSTEM_CHROME_STANDARD);
    }

    protected static boolean validateFolderType(String folderValue) {
        return folderValue.matches(FOLDER_TYPE_PATTERN);
    }

    protected static boolean validateFileTypeName(String fileTypeName) {
        return fileTypeName.matches(FILE_TYPE_NAME_PATTERN) && fileTypeName.charAt(fileTypeName.length() - 1) != '.' && fileTypeName.indexOf("..") == -1;
    }

    protected static boolean validateExtension(String extensionValue) {
        return extensionValue.matches(EXTENSION_PATTERN) && !extensionValue.equalsIgnoreCase("air");
    }

    protected static boolean validateEmptyContentType(String emptyContentValue) {
        return emptyContentValue.length() == 0;
    }

    protected static boolean validateBooleanType(String booleanValue) {
        return booleanValue.equals("true") || booleanValue.equals("false") || booleanValue.equals("1") || booleanValue.equals("0");
    }

    protected static boolean validateUnsignedIntType(String unsignedIntValue) {
        long MAX_UNSIGNED_INT = 0xFFFFFFFFL;
        long value = -1L;
        try {
            value = Long.parseLong(unsignedIntValue);
        }
        catch (NumberFormatException e2) {
            // empty catch block
        }
        return value >= 0L && value <= 0xFFFFFFFFL;
    }

    protected static boolean validateUnsignedIntPairType(String inputString) {
        String[] list = inputString.split("\\s+");
        if (list.length == 2) {
            return ApplicationDescriptorValidator.validateUnsignedIntType(list[0]) && ApplicationDescriptorValidator.validateUnsignedIntType(list[1]);
        }
        return false;
    }

    protected static boolean validateSignedIntType(String unsignedIntValue) {
        long MAX_SIGNED_INT = Integer.MAX_VALUE;
        long MIN_SIGNED_INT = Integer.MIN_VALUE;
        long value = Long.MAX_VALUE;
        try {
            value = Long.parseLong(unsignedIntValue);
        }
        catch (NumberFormatException e2) {
            // empty catch block
        }
        return value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE;
    }

    protected static boolean validateLanguageType(String langTypeValue) {
        return langTypeValue.matches(LANGUAGE_PATTERN);
    }

    protected abstract ElementInfo getRootElementInfo();

    protected abstract boolean validateAttribute(String var1, String var2);

    protected abstract boolean validateElement(String var1, String var2);

    protected abstract int getMaximumSWFVersion();

    protected abstract String getNamespace();

    static final class AttributeInfo
    extends NodeInfo {
        public boolean required;

        public AttributeInfo(String name, boolean required) {
            super(name);
            this.required = required;
        }
    }

    static final class ElementInfo
    extends NodeInfo {
        public int minOccurs;
        public int maxOccurs;
        public boolean contentTypeMixed = false;
        private ElementInfo parent;
        private Map children = new HashMap();
        private Map attributes = new HashMap();

        public ElementInfo(String name, int minOccurs, int maxOccurs) {
            super(name);
            this.minOccurs = minOccurs;
            this.maxOccurs = maxOccurs;
        }

        public void addAttribute(AttributeInfo attributeInfo) {
            this.attributes.put(attributeInfo.name, attributeInfo);
        }

        public void addChild(ElementInfo elementInfo) {
            elementInfo.parent = this;
            this.children.put(elementInfo.name, elementInfo);
        }

        public AttributeInfo getAttribute(String name) {
            return (AttributeInfo)this.attributes.get(name);
        }

        public Collection getAttributes() {
            return Collections.unmodifiableCollection(this.attributes.values());
        }

        public ElementInfo getChild(String name) {
            return (ElementInfo)this.children.get(name);
        }

        public Collection getChildren() {
            return Collections.unmodifiableCollection(this.children.values());
        }

        public ElementInfo getParent() {
            return this.parent;
        }

        public boolean hasChildren() {
            return !this.children.isEmpty();
        }
    }

    static abstract class NodeInfo {
        public String name;
        public int count;

        protected NodeInfo(String name) {
            this.name = name;
        }

        public boolean equal(Object object) {
            if (!(object instanceof NodeInfo)) {
                return false;
            }
            return ((NodeInfo)object).name.equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

