/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.air.AIROutputStream;
import com.adobe.air.InvalidInputException;
import com.adobe.air.Listener;
import com.adobe.air.Message;
import com.adobe.air.validator.ApplicationDescriptorValidator;
import com.adobe.argv.UsageError;
import com.adobe.ucf.Packager;
import com.adobe.ucf.UCF;
import com.adobe.ucf.UCFOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class AIRPackager
extends Packager {
    private static String Adobe_patent_P763 = "AdobePatentId=\"P817\"";
    private static final Map NAMESPACES;
    private File m_descriptor;
    private File m_intermediate;
    private Listener m_listener;
    private boolean m_debug = false;
    private boolean m_validate = true;
    private boolean m_error = false;

    protected static ZipEntry copyAIRFile(ZipFile inputFile, AIROutputStream out, boolean inputSigned, boolean sign) throws InvalidInputException, IOException {
        out.addMimeTypeFile("application/vnd.adobe.air-application-installer-package+zip", sign);
        ZipEntry signatureEntry = null;
        Enumeration<? extends ZipEntry> entries = inputFile.entries();
        int index = 0;
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            InputStream is = inputFile.getInputStream(entry);
            if (name.equals("mimetype")) {
                if (index != 0) {
                    throw new InvalidInputException("mimetype out of place");
                }
                String inputMimeType = inputSigned ? "application/vnd.adobe.air-application-installer-package+zip" : "application/vnd.adobe.air-application-intermediate-package+zip";
                String currentMimeType = UCF.stringFromInputStream(is);
                if (!currentMimeType.equals(inputMimeType)) {
                    throw new InvalidInputException("wrong mimetype");
                }
            } else if (name.equals("META-INF/AIR/application.xml")) {
                if (index != 1) {
                    throw new InvalidInputException("application descriptor out of place");
                }
                out.addZipEntry(entry, is);
                out.addHashFile("META-INF/AIR/hash");
            } else if (name.equals("META-INF/AIR/hash")) {
                if (index != 2) {
                    throw new InvalidInputException("hash file out of place");
                }
            } else {
                if (index < 3) {
                    throw new InvalidInputException("incorrect file order");
                }
                if (name.equals("META-INF/signatures.xml")) {
                    if (!inputSigned) {
                        throw new InvalidInputException("intermediate file contains a signature");
                    }
                    if (signatureEntry != null) {
                        throw new InvalidInputException("contains more than one signature file");
                    }
                    signatureEntry = entry;
                } else {
                    out.addZipEntry(entry, is);
                }
            }
            is.close();
            ++index;
        }
        if (!inputSigned && index < 3) {
            throw new InvalidInputException("not a complete airi file");
        }
        if (inputSigned && (index < 4 || signatureEntry == null)) {
            throw new InvalidInputException("not a complete air file");
        }
        return signatureEntry;
    }

    public void setPrivateKey(PrivateKey key) {
        super.setPrivateKey(key);
        this.setTimestampURL("https://timestamp.geotrust.com/tsa");
    }

    public void setCertificateChain(Certificate[] certchain) throws CertificateException {
        if (certchain == null || certchain.length == 0) {
            throw new IllegalArgumentException("empty certificate chain");
        }
        super.setCertificateChain(certchain);
        String CODE_SIGNING_OID = "1.3.6.1.5.5.7.3.3";
        List<String> extendedKeyUsage = ((X509Certificate)certchain[0]).getExtendedKeyUsage();
        if (extendedKeyUsage == null || !extendedKeyUsage.contains("1.3.6.1.5.5.7.3.3")) {
            throw new CertificateException("not a code signing certificate");
        }
    }

    public void setDescriptor(File descriptor) {
        if (this.m_intermediate != null) {
            throw new IllegalStateException(".airi input already set");
        }
        this.m_descriptor = descriptor;
    }

    protected void setDebug(boolean debug) {
        this.m_debug = debug;
    }

    protected void setValidate(boolean validate) {
        this.m_validate = validate;
    }

    public void setIntermediate(File intermediate) {
        if (!this.getSources().isEmpty()) {
            throw new IllegalStateException("sources already added");
        }
        this.m_intermediate = intermediate;
    }

    public void setListener(Listener listener) {
        this.m_listener = listener;
    }

    public void addSourceWithRoot(File source, File root) {
        if (this.m_intermediate != null) {
            throw new IllegalStateException(".airi input already set");
        }
        super.addSourceWithRoot(source, root);
    }

    public void addSourceWithPath(File source, String path) {
        if (this.m_intermediate != null) {
            throw new IllegalStateException(".airi input already set");
        }
        super.addSourceWithPath(source, path);
    }

    public void validate() {
        if (this.m_descriptor == null) {
            throw new IllegalStateException("descriptor not set");
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        Document document = null;
        documentBuilderFactory.setNamespaceAware(true);
        try {
            builder = documentBuilderFactory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                    throw exception;
                }

                public void warning(SAXParseException exception) throws SAXException {
                    throw exception;
                }
            });
            document = builder.parse(this.m_descriptor);
        }
        catch (IOException e2) {
            this.dispatchError(301, this.m_descriptor.getPath(), -1, -1, null);
        }
        catch (Exception e3) {
            this.dispatchError(100, this.m_descriptor.getPath(), -1, -1, null);
        }
        if (this.m_error) {
            return;
        }
        String namespaceUri = document.getDocumentElement().getNamespaceURI();
        if (namespaceUri == null) {
            this.dispatchError(101, this.m_descriptor.getPath(), -1, -1, null);
            return;
        }
        String validatorClassName = (String)NAMESPACES.get(namespaceUri);
        if (validatorClassName == null) {
            this.dispatchError(102, this.m_descriptor.getPath(), -1, -1, new String[]{namespaceUri});
            return;
        }
        Class<?> validatorClass = null;
        ApplicationDescriptorValidator validator = null;
        try {
            validatorClass = Class.forName(validatorClassName);
            validator = (ApplicationDescriptorValidator)validatorClass.newInstance();
            validator.setDescriptor(this.m_descriptor);
            validator.setListener(new Listener(){

                public void message(Message message) {
                    AIRPackager.this.dispatchError(message.code, message.file, message.line, message.column, message.identifiers);
                }

                public void progress(int soFar, int total) {
                }
            });
            TreeMap validatorSources = new TreeMap();
            validatorSources.putAll(this.getSources());
            validator.setSources(validatorSources);
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
            SAXParser parser = null;
            parser = saxParserFactory.newSAXParser();
            parser.parse(this.m_descriptor, (DefaultHandler)validator);
        }
        catch (ClassNotFoundException e4) {
            throw new RuntimeException("cannot load appropriate validator:'" + e4.getMessage() + "'");
        }
        catch (IOException e5) {
            throw new RuntimeException(e5.getMessage());
        }
        catch (SAXException e6) {
            throw new RuntimeException(e6.getMessage());
        }
        catch (ParserConfigurationException e7) {
            throw new RuntimeException(e7.getMessage());
        }
        catch (InstantiationException e8) {
            throw new RuntimeException(e8.getMessage());
        }
        catch (IllegalAccessException e9) {
            throw new RuntimeException(e9.getMessage());
        }
    }

    public void createIntermediate() throws IOException, UsageError {
        try {
            this.createPackage("application/vnd.adobe.air-application-intermediate-package+zip", false);
        }
        catch (GeneralSecurityException ex) {
            throw new RuntimeException("certificate exception with signing disabled");
        }
        catch (InvalidInputException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public void createAIR() throws GeneralSecurityException, IOException, UsageError {
        try {
            this.createPackage("application/vnd.adobe.air-application-installer-package+zip", true);
        }
        catch (InvalidInputException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    protected UCFOutputStream newUCFOutputStream() {
        return new AIROutputStream();
    }

    private void createPackage(String mimeType, boolean sign) throws CertificateEncodingException, IOException, GeneralSecurityException, InvalidInputException {
        if (this.getOutput() == null) {
            throw new IllegalStateException("output not set");
        }
        if (this.m_intermediate == null && (this.m_descriptor == null || this.getSources().isEmpty())) {
            throw new IllegalStateException("inputs not set");
        }
        if (this.m_validate && this.m_intermediate == null) {
            this.validate();
        }
        if (this.m_error) {
            return;
        }
        if (!this.getSources().isEmpty()) {
            this.getStream().addMimeTypeFile(mimeType, sign);
            this.getStream().addFile(this.m_descriptor, "META-INF/AIR/application.xml", sign);
            ((AIROutputStream)this.getStream()).addHashFile("META-INF/AIR/hash");
            if (this.m_debug) {
                ((AIROutputStream)this.getStream()).addDebugFile("META-INF/AIR/debug", sign);
            }
            Iterator i2 = this.getSources().entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry e2 = i2.next();
                File file = (File)e2.getValue();
                String path = (String)e2.getKey();
                this.getStream().addFile(file, path, sign);
            }
        } else {
            ZipFile zipFile = new ZipFile(this.m_intermediate);
            AIRPackager.copyAIRFile(zipFile, (AIROutputStream)this.getStream(), false, sign);
            zipFile.close();
        }
        if (sign) {
            this.getStream().finalizeSig();
        }
        this.getStream().close();
        this.renameOutput();
    }

    private void dispatchError(int code, String file, int line, int column, String[] identifiers) {
        this.m_error = true;
        if (this.m_listener != null) {
            Message message = new Message(code, "ERROR", file, line, column, identifiers);
            this.m_listener.message(message);
        }
    }

    static {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put("http://ns.adobe.com/air/application/1.0", "com.adobe.air.validator.ApplicationDescriptorValidator10");
        tempMap.put("http://ns.adobe.com/air/application/1.1", "com.adobe.air.validator.ApplicationDescriptorValidator11");
        tempMap.put("http://ns.adobe.com/air/application/1.5", "com.adobe.air.validator.ApplicationDescriptorValidator15");
        tempMap.put("http://ns.adobe.com/air/application/1.5.1", "com.adobe.air.validator.ApplicationDescriptorValidator151");
        tempMap.put("http://ns.adobe.com/air/application/1.5.2", "com.adobe.air.validator.ApplicationDescriptorValidator152");
        NAMESPACES = Collections.unmodifiableMap(tempMap);
    }
}

