/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.pdfops.options.ocr;

import com.adobe.pdfservices.operation.pdfops.options.ocr.OCRSupportedLocale;
import com.adobe.pdfservices.operation.pdfops.options.ocr.OCRSupportedType;
import java.util.Objects;

public class OCROptions {
    private OCRSupportedLocale ocrLocale;
    private OCRSupportedType ocrType;

    private OCROptions(OCRSupportedLocale ocrLocale, OCRSupportedType ocrType) {
        this.ocrLocale = ocrLocale;
        this.ocrType = ocrType;
    }

    public OCRSupportedLocale getOCRLocale() {
        return this.ocrLocale;
    }

    public OCRSupportedType getOCRType() {
        return this.ocrType;
    }

    public static Builder ocrOptionsBuilder() {
        return new Builder();
    }

    public static class Builder {
        private OCRSupportedLocale ocrLocale;
        private OCRSupportedType ocrType;

        public Builder withOCRLocale(OCRSupportedLocale ocrSupportedLocale) {
            Objects.requireNonNull(ocrSupportedLocale, "OcrLocale must not be null");
            this.ocrLocale = ocrSupportedLocale;
            return this;
        }

        public Builder withOCRType(OCRSupportedType ocrSupportedType) {
            Objects.requireNonNull(ocrSupportedType, "OcrType must not be null.");
            this.ocrType = ocrSupportedType;
            return this;
        }

        public OCROptions build() {
            return new OCROptions(this.ocrLocale, this.ocrType);
        }
    }
}

