/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.pdfops.options;

import com.adobe.pdfservices.operation.internal.options.PageRange;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class PageRanges {
    private static final int RANGES_MAX_LIMIT = 100;
    private List<PageRange> ranges = new ArrayList<PageRange>();

    public void addSinglePage(int page) {
        this.ranges.add(new PageRange(page, page));
    }

    public void addRange(int start, int end) {
        this.ranges.add(new PageRange(start, end));
    }

    public void addAllFrom(int start) {
        this.ranges.add(new PageRange(start, null));
    }

    public void addAll() {
        this.ranges.add(new PageRange(1, null));
    }

    public String toString() {
        return this.ranges.stream().map(PageRange::toString).collect(Collectors.joining(","));
    }

    public void validate() {
        if (this.ranges.size() > 100) {
            throw new IllegalArgumentException("Maximum allowed limit exceeded for page ranges.");
        }
        this.ranges.forEach(PageRange::validate);
    }

    public boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    public List<PageRange> getRanges() {
        return this.ranges;
    }
}

