/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.pdfops;

import com.adobe.pdfservices.operation.ExecutionContext;
import com.adobe.pdfservices.operation.Operation;
import com.adobe.pdfservices.operation.exception.ServiceApiException;
import com.adobe.pdfservices.operation.exception.ServiceUsageException;
import com.adobe.pdfservices.operation.internal.ExtensionMediaTypeMapping;
import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.MediaType;
import com.adobe.pdfservices.operation.internal.api.FileDownloadApi;
import com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.CPFContentAnalyzerResponse;
import com.adobe.pdfservices.operation.internal.exception.OperationException;
import com.adobe.pdfservices.operation.internal.service.DocumentMergeService;
import com.adobe.pdfservices.operation.internal.util.FileUtil;
import com.adobe.pdfservices.operation.internal.util.PathUtil;
import com.adobe.pdfservices.operation.internal.util.StringUtil;
import com.adobe.pdfservices.operation.internal.util.ValidationUtil;
import com.adobe.pdfservices.operation.io.FileRef;
import com.adobe.pdfservices.operation.pdfops.options.documentmerge.DocumentMergeOptions;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentMergeOperation
implements Operation {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentMergeOperation.class);
    private FileRefImpl documentTemplate;
    private DocumentMergeOptions documentMergeOptions;
    private static final Set<String> SUPPORTED_SOURCE_MEDIA_TYPE = new HashSet<String>(Arrays.asList(ExtensionMediaTypeMapping.DOCX.getMediaType()));
    private boolean isInvoked = false;

    private DocumentMergeOperation(DocumentMergeOptions documentMergeOptions) {
        this.documentMergeOptions = documentMergeOptions;
    }

    public void setInput(FileRef documentTemplate) {
        Objects.requireNonNull(documentTemplate, "No input was set for operation");
        this.documentTemplate = (FileRefImpl)documentTemplate;
    }

    public static DocumentMergeOperation createNew(DocumentMergeOptions documentMergeOptions) {
        return new DocumentMergeOperation(documentMergeOptions);
    }

    @Override
    public FileRef execute(ExecutionContext context) throws ServiceApiException, IOException, ServiceUsageException {
        this.validateInvocationCount();
        InternalExecutionContext internalExecutionContext = (InternalExecutionContext)context;
        this.validate(internalExecutionContext);
        try {
            LOGGER.info("All validations successfully done. Beginning DocumentMerge operation execution");
            long startTimeMs = System.currentTimeMillis();
            String location = DocumentMergeService.mergeDocument(internalExecutionContext, this.documentTemplate, this.documentMergeOptions, this.getClass().getSimpleName());
            String targetFileName = FileUtil.getRandomFileName(this.documentMergeOptions.getOutputFormat().getFormat());
            String temporaryDestinationPath = PathUtil.getTemporaryDestinationPath(targetFileName, this.documentMergeOptions.getOutputFormat().getFormat());
            FileDownloadApi.downloadAndSave(internalExecutionContext, location, temporaryDestinationPath, CPFContentAnalyzerResponse.class);
            LOGGER.info("Operation successfully completed. Stored created File at {}", (Object)temporaryDestinationPath);
            LOGGER.debug("Operation Success Info - Request ID: {}, Latency(ms): {}", (Object)StringUtil.getRequestIdFromLocation(location), (Object)(System.currentTimeMillis() - startTimeMs));
            this.isInvoked = true;
            return FileRef.createFromLocalFile(temporaryDestinationPath);
        }
        catch (OperationException oe) {
            throw new ServiceApiException(oe.getErrorMessage(), oe.getRequestTrackingId(), oe.getStatusCode(), oe.getReportErrorCode());
        }
    }

    private void validate(InternalExecutionContext context) {
        if (this.documentTemplate == null) {
            throw new IllegalArgumentException("No input was set for operation");
        }
        if (this.documentTemplate.getSourceURL() != null) {
            throw new IllegalArgumentException("Input for the Document Merge Operation can not be sourced from a URL");
        }
        ValidationUtil.validateExecutionContext(context);
        ValidationUtil.validateMediaType(SUPPORTED_SOURCE_MEDIA_TYPE, this.documentTemplate.getMediaType());
        Objects.requireNonNull(this.documentMergeOptions, "Document Merge Options cannot be null");
        ValidationUtil.validateDocumentMergeOptions(this.documentMergeOptions);
    }

    private void validateInvocationCount() {
        if (this.isInvoked) {
            LOGGER.error("Operation instance must only be invoked once");
            throw new IllegalStateException("Operation instance must not be reused, can only be invoked once");
        }
    }

    public static enum SupportedSourceFormat implements MediaType
    {
        DOCX;


        @Override
        public String getMediaType() {
            return ExtensionMediaTypeMapping.valueOf(this.name()).getMediaType().toLowerCase();
        }
    }
}

