/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.pdfops;

import com.adobe.pdfservices.operation.ExecutionContext;
import com.adobe.pdfservices.operation.Operation;
import com.adobe.pdfservices.operation.exception.ServiceApiException;
import com.adobe.pdfservices.operation.exception.ServiceUsageException;
import com.adobe.pdfservices.operation.internal.ExtensionMediaTypeMapping;
import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.MediaType;
import com.adobe.pdfservices.operation.internal.api.FileDownloadApi;
import com.adobe.pdfservices.operation.internal.cpf.dto.response.platform.CPFContentAnalyzerResponse;
import com.adobe.pdfservices.operation.internal.exception.OperationException;
import com.adobe.pdfservices.operation.internal.options.CombineOperationInput;
import com.adobe.pdfservices.operation.internal.service.CombinePDFService;
import com.adobe.pdfservices.operation.internal.util.FileUtil;
import com.adobe.pdfservices.operation.internal.util.PathUtil;
import com.adobe.pdfservices.operation.internal.util.StringUtil;
import com.adobe.pdfservices.operation.internal.util.ValidationUtil;
import com.adobe.pdfservices.operation.io.FileRef;
import com.adobe.pdfservices.operation.pdfops.options.PageRanges;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombineFilesOperation
implements Operation {
    private static final Logger LOGGER = LoggerFactory.getLogger(CombineFilesOperation.class);
    private static final Set<String> SUPPORTED_SOURCE_MEDIA_TYPE = new HashSet<String>(Arrays.asList(ExtensionMediaTypeMapping.PDF.getMediaType()));
    private static final String TARGET_FILE_EXTENSION = ExtensionMediaTypeMapping.PDF.getExtension();
    private boolean isInvoked = false;
    private List<CombineOperationInput> filesToCombine = new ArrayList<CombineOperationInput>();

    private CombineFilesOperation() {
    }

    public static CombineFilesOperation createNew() {
        return new CombineFilesOperation();
    }

    public void addInput(FileRef sourceFileRef) {
        Objects.requireNonNull(sourceFileRef, "No input was set for operation");
        PageRanges pageRanges = new PageRanges();
        pageRanges.addAll();
        this.filesToCombine.add(CombineOperationInput.createNew((FileRefImpl)sourceFileRef, pageRanges));
    }

    public void addInput(FileRef sourceFileRef, PageRanges pageRanges) {
        Objects.requireNonNull(sourceFileRef, "No input was set for operation");
        Objects.requireNonNull(pageRanges, "No page options was provided for input file");
        this.filesToCombine.add(CombineOperationInput.createNew((FileRefImpl)sourceFileRef, pageRanges));
    }

    @Override
    public FileRef execute(ExecutionContext context) throws ServiceApiException, IOException, ServiceUsageException {
        this.validateInvocationCount();
        InternalExecutionContext internalExecutionContext = (InternalExecutionContext)context;
        this.validate(internalExecutionContext);
        try {
            LOGGER.info("All validations successfully done. Beginning Combine operation execution");
            long startTimeMs = System.currentTimeMillis();
            String location = CombinePDFService.combinePdf(internalExecutionContext, this.filesToCombine, this.getClass().getSimpleName());
            String targetFileName = FileUtil.getRandomFileName(TARGET_FILE_EXTENSION);
            String temporaryDestinationPath = PathUtil.getTemporaryDestinationPath(targetFileName, TARGET_FILE_EXTENSION);
            FileDownloadApi.downloadAndSave(internalExecutionContext, location, temporaryDestinationPath, CPFContentAnalyzerResponse.class);
            LOGGER.info("Operation successfully completed. Stored Combined PDF at {}", (Object)temporaryDestinationPath);
            LOGGER.debug("Operation Success Info - Request ID: {}, Latency(ms): {}", (Object)StringUtil.getRequestIdFromLocation(location), (Object)(System.currentTimeMillis() - startTimeMs));
            this.isInvoked = true;
            return FileRef.createFromLocalFile(temporaryDestinationPath);
        }
        catch (OperationException oe) {
            throw new ServiceApiException(oe.getErrorMessage(), oe.getRequestTrackingId(), oe.getStatusCode(), oe.getReportErrorCode());
        }
    }

    private void validateInvocationCount() {
        if (this.isInvoked) {
            LOGGER.error("Operation instance must only be invoked once");
            throw new IllegalStateException("Operation instance must not be reused, can only be invoked once");
        }
    }

    private void validate(InternalExecutionContext context) {
        ValidationUtil.validateExecutionContext(context);
        if (this.filesToCombine.isEmpty()) {
            throw new IllegalArgumentException("No input was provided for combining files");
        }
        this.filesToCombine.forEach(file -> {
            if (file.getSourceFileRef().getSourceURL() != null) {
                throw new IllegalArgumentException("Input for the Combine Files Operation can not be sourced from a URL");
            }
            ValidationUtil.validateFileWithPageOptions(file, SUPPORTED_SOURCE_MEDIA_TYPE);
        });
        if (this.filesToCombine.stream().map(CombineOperationInput::getSourceFileRef).distinct().count() > 20L) {
            throw new IllegalArgumentException("Only 20 unique input files can be combined in one combine operation instance");
        }
    }

    public static enum SupportedSourceFormat implements MediaType
    {
        PDF;


        @Override
        public String getMediaType() {
            return ExtensionMediaTypeMapping.valueOf(this.name()).getMediaType().toLowerCase();
        }
    }
}

