/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtil.class);

    public static void moveFile(String source, String destination) throws IOException {
        try {
            FileUtils.moveFile((File)new File(source), (File)new File(destination));
        }
        catch (FileExistsException f) {
            LOGGER.error("File at location {} already exists", (Object)destination);
            throw new FileAlreadyExistsException(destination);
        }
    }

    public static void moveFileToStream(String filePath, OutputStream targetStream) throws IOException {
        LOGGER.debug("Moving file at {} to provided OutputStream", (Object)filePath);
        File operationResultFile = new File(filePath);
        try (FileInputStream fileInputStream = new FileInputStream(operationResultFile);){
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)targetStream);
            if (operationResultFile.delete()) {
                LOGGER.debug("Temporary file at {} deleted successfully", (Object)filePath);
            }
        }
    }

    public static String getRandomFileName(String extension) {
        if (extension != null) {
            if (extension.startsWith(".")) {
                return UUID.randomUUID().toString().replace("-", "") + extension;
            }
            return UUID.randomUUID().toString().replace("-", "") + "." + extension;
        }
        return "";
    }

    public static ZipOutputStream addZipEntry(ZipOutputStream zipOutputStream, String fileName, InputStream inputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOutputStream.putNextEntry(zipEntry);
        IOUtils.copy((InputStream)inputStream, (OutputStream)zipOutputStream);
        zipOutputStream.closeEntry();
        return zipOutputStream;
    }

    public static ZipOutputStream addZipEntry(ZipOutputStream zipOutputStream, String fileName, byte[] byteData) throws IOException {
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.write(byteData, 0, byteData.length);
        zipOutputStream.closeEntry();
        return zipOutputStream;
    }
}

