/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.service;

import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.options.CombineOperationInput;
import com.adobe.pdfservices.operation.internal.service.CombinePDFService;
import com.adobe.pdfservices.operation.pdfops.options.PageRanges;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InsertPagesService
extends CombinePDFService {
    private static final int INPUT_SOURCE_LIMIT = 20;

    private static InsertFilesInput getFilesToInsert(FileRefImpl baseFileRef, Map<Integer, List<CombineOperationInput>> filesToInsert) throws IOException {
        ArrayList<FileRefImpl> fileRefList = new ArrayList<FileRefImpl>();
        ArrayList<PageRanges> pageRangeList = new ArrayList<PageRanges>();
        int baseFileStartIndex = 1;
        for (Map.Entry<Integer, List<CombineOperationInput>> entry : filesToInsert.entrySet()) {
            if (entry.getKey() != 1) {
                fileRefList.add(baseFileRef.getCopy());
                PageRanges pageRanges = new PageRanges();
                pageRanges.addRange(baseFileStartIndex, entry.getKey() - 1);
                pageRangeList.add(pageRanges);
                baseFileStartIndex = entry.getKey();
            }
            for (CombineOperationInput combineOperationInput : entry.getValue()) {
                fileRefList.add(combineOperationInput.getSourceFileRef());
                pageRangeList.add(combineOperationInput.getPageRanges());
            }
        }
        fileRefList.add(baseFileRef);
        PageRanges basePageRanges = new PageRanges();
        basePageRanges.addAllFrom(baseFileStartIndex);
        pageRangeList.add(basePageRanges);
        return new InsertFilesInput(fileRefList, pageRangeList);
    }

    public static String insertPages(InternalExecutionContext context, FileRefImpl baseFileRef, Map<Integer, List<CombineOperationInput>> filesToInsert, String operation) throws IOException {
        InsertFilesInput insertFilesInput = InsertPagesService.getFilesToInsert(baseFileRef, filesToInsert);
        List sourceFileRefList = insertFilesInput.fileRefList;
        if (sourceFileRefList.size() > 20) {
            throw new IllegalArgumentException("Too many insertions specified for the operation");
        }
        return InsertPagesService.execute(context, operation, insertFilesInput.pageRangesList, sourceFileRefList, sourceFileRefList.size());
    }

    private static class InsertFilesInput {
        private List<FileRefImpl> fileRefList;
        private List<PageRanges> pageRangesList;

        InsertFilesInput(List<FileRefImpl> fileRefList, List<PageRanges> pageRangesList) {
            this.fileRefList = fileRefList;
            this.pageRangesList = pageRangesList;
        }
    }
}

