/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.service;

import com.adobe.pdfservices.operation.internal.ExtensionMediaTypeMapping;
import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.api.CPFApi;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.CPFContentAnalyzerRequests;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.ExportPDFParams;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.Inputs;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.Outputs;
import com.adobe.pdfservices.operation.internal.http.HttpResponse;
import com.adobe.pdfservices.operation.pdfops.options.exportpdf.ExportPDFTargetFormat;
import com.adobe.pdfservices.operation.pdfops.options.exportpdftoimages.ExportPDFToImagesTargetFormat;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public class ExportPDFService {
    public static String exportPDF(InternalExecutionContext context, FileRefImpl sourceFileRef, ExportPDFTargetFormat exportPDFTargetFormat, String operation) throws FileNotFoundException {
        ExportPDFParams exportPDFParams = ExportPDFParams.createFrom(exportPDFTargetFormat);
        Inputs inputs = Inputs.builder(sourceFileRef.getMediaType()).setParams(exportPDFParams).build();
        CPFContentAnalyzerRequests cpfContentAnalyzerRequests = new CPFContentAnalyzerRequests("urn:aaid:cpf:Service-26c7fda2890b44ad9a82714682e35888", inputs, ExportPDFService.getOutputFormat(exportPDFTargetFormat));
        ArrayList<FileRefImpl> sourceFileRefList = new ArrayList<FileRefImpl>();
        sourceFileRefList.add(sourceFileRef);
        HttpResponse<String> response = CPFApi.cpfCreateOpsApi(context, cpfContentAnalyzerRequests, sourceFileRefList, String.class, operation);
        return response.getHeaders().get("location");
    }

    public static String exportPDFToImages(InternalExecutionContext context, FileRefImpl sourceFileRef, ExportPDFToImagesTargetFormat exportPDFToImagesTargetFormat, String operation) throws FileNotFoundException {
        ExportPDFParams exportPDFParams = ExportPDFParams.createImagesFrom(exportPDFToImagesTargetFormat);
        Inputs inputs = Inputs.builder(sourceFileRef.getMediaType()).setParams(exportPDFParams).build();
        Outputs outputs = new Outputs(exportPDFToImagesTargetFormat.getFileExt(), true);
        CPFContentAnalyzerRequests cpfContentAnalyzerRequests = new CPFContentAnalyzerRequests("urn:aaid:cpf:Service-26c7fda2890b44ad9a82714682e35888", inputs, outputs);
        ArrayList<FileRefImpl> sourceFileRefList = new ArrayList<FileRefImpl>();
        sourceFileRefList.add(sourceFileRef);
        HttpResponse<String> response = CPFApi.cpfCreateOpsApi(context, cpfContentAnalyzerRequests, sourceFileRefList, String.class, operation);
        return response.getHeaders().get("location");
    }

    private static String getOutputFormat(ExportPDFTargetFormat exportPDFTargetFormat) {
        switch (exportPDFTargetFormat) {
            case PNG: 
            case JPEG: {
                return ExtensionMediaTypeMapping.ZIP.getMediaType();
            }
        }
        return ExtensionMediaTypeMapping.getFromExtension(exportPDFTargetFormat.getFileExt()).getMediaType();
    }
}

