/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.service;

import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.api.CPFApi;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.CPFContentAnalyzerRequests;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.CompressPDFParams;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.Inputs;
import com.adobe.pdfservices.operation.internal.http.HttpResponse;
import com.adobe.pdfservices.operation.pdfops.options.compresspdf.CompressPDFOptions;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public class CompressPDFService {
    private static final String IO_FORMAT_SPECIFIER = "application/pdf";

    public static String compressPDF(InternalExecutionContext context, FileRefImpl sourceFileRef, CompressPDFOptions compressPDFOptions, String operation) throws FileNotFoundException {
        CompressPDFParams compressPDFParams = CompressPDFParams.createFrom(compressPDFOptions);
        Inputs inputs = Inputs.builder(IO_FORMAT_SPECIFIER).setParams(compressPDFParams).build();
        CPFContentAnalyzerRequests cpfContentAnalyzerRequests = new CPFContentAnalyzerRequests("urn:aaid:cpf:Service-f37d36f4e6724eed92149a8ff35ea061", inputs, IO_FORMAT_SPECIFIER);
        ArrayList<FileRefImpl> sourceFileRefList = new ArrayList<FileRefImpl>();
        sourceFileRefList.add(sourceFileRef);
        HttpResponse<String> response = CPFApi.cpfCreateOpsApi(context, cpfContentAnalyzerRequests, sourceFileRefList, String.class, operation);
        return response.getHeaders().get("location");
    }
}

