/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.service;

import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.api.CPFApi;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.CPFContentAnalyzerRequests;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.CombinePageRange;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.Inputs;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.MultiPartFormField;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.multipleInputsField.CPFMultipleInputsField;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.multipleInputsField.CombineCPFMultipleInputsField;
import com.adobe.pdfservices.operation.internal.http.HttpResponse;
import com.adobe.pdfservices.operation.internal.options.CombineOperationInput;
import com.adobe.pdfservices.operation.internal.util.InputStreamUtil;
import com.adobe.pdfservices.operation.pdfops.options.PageRanges;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;

public class CombinePDFService {
    private static final String IO_FORMAT_SPECIFIER = "application/pdf";

    private static List<PageRanges> generatePageRangesList(List<CombineOperationInput> filesToCombine) {
        ArrayList<PageRanges> pageRangesList = new ArrayList<PageRanges>();
        for (CombineOperationInput fileToCombine : filesToCombine) {
            PageRanges pageRanges = fileToCombine.getPageRanges();
            if (pageRanges == null) continue;
            if (pageRanges.isEmpty()) {
                pageRanges.addAll();
            }
            pageRangesList.add(pageRanges);
        }
        return pageRangesList;
    }

    private static List<CPFMultipleInputsField> getCPFMultipleInputsFieldList(List<PageRanges> pageRangesList, int numOfInputs) {
        ArrayList<CPFMultipleInputsField> cpfMultipleInputsFieldList = new ArrayList<CPFMultipleInputsField>();
        for (int partNumber = 1; partNumber <= numOfInputs; ++partNumber) {
            cpfMultipleInputsFieldList.add(new CombineCPFMultipleInputsField(new MultiPartFormField(IO_FORMAT_SPECIFIER, InputStreamUtil.generateFileFormFieldName(partNumber)), new CombinePageRange(pageRangesList.get(partNumber - 1).getRanges())));
        }
        return cpfMultipleInputsFieldList;
    }

    public static String combinePdf(InternalExecutionContext context, List<CombineOperationInput> filesToCombine, String operation) throws FileNotFoundException {
        ArrayList<FileRefImpl> sourceFileRefList = new ArrayList<FileRefImpl>();
        for (CombineOperationInput fileToCombine : filesToCombine) {
            sourceFileRefList.add(fileToCombine.getSourceFileRef());
        }
        List<PageRanges> pageRangesList = CombinePDFService.generatePageRangesList(filesToCombine);
        return CombinePDFService.execute(context, operation, pageRangesList, sourceFileRefList, filesToCombine.size());
    }

    protected static String execute(InternalExecutionContext context, String operation, List<PageRanges> pageRangesList, List<FileRefImpl> sourceFileRefList, int numOfInputs) throws FileNotFoundException {
        List<CPFMultipleInputsField> cpfMultipleInputsFieldList = CombinePDFService.getCPFMultipleInputsFieldList(pageRangesList, numOfInputs);
        Inputs inputs = new Inputs(cpfMultipleInputsFieldList);
        CPFContentAnalyzerRequests cpfContentAnalyzerRequests = new CPFContentAnalyzerRequests("urn:aaid:cpf:Service-916ee91c156b42349a7847a7d564fb13", inputs, IO_FORMAT_SPECIFIER);
        HttpResponse<String> response = CPFApi.cpfCreateOpsApi(context, cpfContentAnalyzerRequests, sourceFileRefList, String.class, operation);
        return response.getHeaders().get("location");
    }
}

