/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.http;

import com.adobe.pdfservices.operation.internal.auth.AuthenticationMethod;
import com.adobe.pdfservices.operation.internal.auth.Authenticator;
import com.adobe.pdfservices.operation.internal.auth.SessionToken;
import com.adobe.pdfservices.operation.internal.cpf.constants.RequestKey;
import com.adobe.pdfservices.operation.internal.http.ByteArrayPart;
import com.adobe.pdfservices.operation.internal.http.HttpMethod;
import com.adobe.pdfservices.operation.internal.http.HttpRequest;
import com.adobe.pdfservices.operation.internal.http.HttpRequestConfig;
import com.adobe.pdfservices.operation.internal.http.InputStreamPart;
import com.adobe.pdfservices.operation.internal.http.MultiPartRequest;
import com.adobe.pdfservices.operation.internal.http.RequestType;
import com.adobe.pdfservices.operation.internal.http.StringBodyPart;
import com.github.hal4j.uritemplate.URITemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.NameValuePair;
import org.apache.http.entity.StringEntity;

public class BaseMultipartRequest
implements MultiPartRequest {
    private URITemplate uriTemplate;
    private HttpMethod httpMethod;
    private Map<String, String> headers = new HashMap<String, String>();
    private AuthenticationMethod authenticationMethod;
    private RequestType requestType;
    private List<ByteArrayPart> byteArrayParts;
    private StringBodyPart stringBodyPart;
    private List<InputStreamPart> inputStreamParts;
    private Authenticator authenticator;
    private HttpRequestConfig requestConfig;
    private RequestKey requestKey;

    public BaseMultipartRequest(String uriTemplate) {
        this.uriTemplate = new URITemplate(uriTemplate);
        this.authenticationMethod = AuthenticationMethod.AUTH_HEADER_PRIMARY;
        this.requestType = RequestType.MULTIPART;
        this.httpMethod = HttpMethod.POST;
    }

    @Override
    public MultiPartRequest withContentType(String contentType) {
        return this.withHeader("Content-Type", contentType);
    }

    @Override
    public MultiPartRequest withHeader(String headerName, String headerValue) {
        this.headers.put(headerName, headerValue);
        return this;
    }

    @Override
    public MultiPartRequest withHeaders(Map<String, String> headers) {
        Map<String, String> headersCopy = this.getHeadersCopy(headers);
        this.headers.putAll(headersCopy);
        return this;
    }

    @Override
    public HttpRequest withUriParam(String name, String value) {
        return null;
    }

    @Override
    public MultiPartRequest withUrlEncodedFormParams(List<NameValuePair> formParams) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public MultiPartRequest withBody(String body) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public MultiPartRequest withAuthenticationMethod(AuthenticationMethod authMethod) {
        this.authenticationMethod = authMethod;
        return this;
    }

    @Override
    public MultiPartRequest withTemplate(String uriTemplate) {
        this.uriTemplate = new URITemplate(uriTemplate);
        return this;
    }

    @Override
    public MultiPartRequest withAcceptType(String acceptHeader) {
        return this.withHeader("Accept", acceptHeader);
    }

    @Override
    public MultiPartRequest withAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
        this.headers.put("x-api-key", this.authenticator.getClientId());
        return this;
    }

    @Override
    public MultiPartRequest withConfig(HttpRequestConfig requestConfig) {
        this.requestConfig = requestConfig;
        return this;
    }

    @Override
    public HttpRequest withRequestKey(RequestKey requestKey) {
        this.requestKey = requestKey;
        return this;
    }

    @Override
    public MultiPartRequest withStringBodyPart(StringBodyPart stringBodyPart) {
        this.stringBodyPart = stringBodyPart;
        return this;
    }

    @Override
    public MultiPartRequest withInputStreamPart(InputStreamPart inputStreamPart) {
        if (this.inputStreamParts == null) {
            this.inputStreamParts = new ArrayList<InputStreamPart>();
        }
        this.inputStreamParts.add(inputStreamPart);
        return this;
    }

    @Override
    public MultiPartRequest withByteArrayPart(ByteArrayPart byteArrayPart) {
        if (this.byteArrayParts == null) {
            this.byteArrayParts = new ArrayList<ByteArrayPart>();
        }
        this.byteArrayParts.add(byteArrayPart);
        return this;
    }

    @Override
    public void authenticate() {
        if (this.authenticationMethod.isAuthRequired()) {
            if (this.authenticator == null) {
                throw new IllegalStateException("No authenticator provided for request. Cannot add authorization headers");
            }
            SessionToken sessionToken = this.authenticator.getSessionToken(this.requestConfig);
            this.withHeader("Authorization", String.format("Bearer %s", sessionToken.getAccessToken()));
        }
    }

    @Override
    public void forceAuthenticate() {
        if (this.authenticationMethod.isAuthRequired()) {
            if (this.authenticator == null) {
                throw new IllegalStateException("No authenticator provided for request. Cannot add authorization headers");
            }
            SessionToken sessionToken = this.authenticator.refreshSessionToken(this.requestConfig);
            this.withHeader("Authorization", String.format("Bearer %s", sessionToken.getAccessToken()));
        }
    }

    @Override
    public HttpRequestConfig getConfig() {
        return this.requestConfig;
    }

    @Override
    public StringEntity getEntity() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public AuthenticationMethod getAuthMethod() {
        return this.authenticationMethod;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String getFinalUri() {
        return this.uriTemplate.expand(new Object[0]).toString();
    }

    private Map<String, String> getHeadersCopy(Map<String, String> headersToCopy) {
        return headersToCopy.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public RequestType getRequestType() {
        return this.requestType;
    }

    @Override
    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    @Override
    public String getTemplateString() {
        return this.uriTemplate.toString();
    }

    @Override
    public List<ByteArrayPart> getByteArrayParts() {
        return this.byteArrayParts;
    }

    @Override
    public List<InputStreamPart> getInputStreams() {
        return this.inputStreamParts;
    }

    @Override
    public StringBodyPart getStringBodyPart() {
        return this.stringBodyPart;
    }

    @Override
    public RequestKey getRequestKey() {
        return this.requestKey;
    }
}

