/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.documentmerge;

import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.PlatformParams;
import com.adobe.pdfservices.operation.internal.serializer.JSONObjectSerializer;
import com.adobe.pdfservices.operation.pdfops.options.documentmerge.Fragments;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DocumentMergeParams
implements PlatformParams {
    @JsonProperty(value="outputFormat")
    private String outputFormat;
    @JsonProperty(value="jsonDataForMerge")
    @JsonSerialize(using=JSONObjectSerializer.class)
    private JSONObject jsonDataForMerge;
    @JsonProperty(value="fragments")
    private List<?> fragments;

    public DocumentMergeParams(String outputFormat, JSONObject jsonDataForMerge) {
        this.outputFormat = outputFormat;
        this.jsonDataForMerge = jsonDataForMerge;
    }

    public DocumentMergeParams(String outputFormat, JSONObject jsonDataForMerge, Fragments fragments) throws JsonProcessingException {
        JSONArray fragmentArray;
        this.outputFormat = outputFormat;
        this.jsonDataForMerge = jsonDataForMerge;
        if (fragments != null && (fragmentArray = new JSONArray(fragments.getFragmentsList())) != null) {
            ObjectMapper objectMapper = new ObjectMapper();
            this.fragments = (List)objectMapper.readValue(fragmentArray.toString(), new TypeReference<List<?>>(){});
        }
    }
}

