/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfservices.operation.internal.api;

import com.adobe.pdfservices.operation.exception.SdkException;
import com.adobe.pdfservices.operation.internal.ExtensionMediaTypeMapping;
import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.cpf.constants.RequestKey;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.CPFContentAnalyzerRequests;
import com.adobe.pdfservices.operation.internal.exception.OperationException;
import com.adobe.pdfservices.operation.internal.http.BaseHttpRequest;
import com.adobe.pdfservices.operation.internal.http.HttpClient;
import com.adobe.pdfservices.operation.internal.http.HttpClientFactory;
import com.adobe.pdfservices.operation.internal.http.HttpResponse;
import com.adobe.pdfservices.operation.internal.http.InputStreamPart;
import com.adobe.pdfservices.operation.internal.http.MultiPartRequest;
import com.adobe.pdfservices.operation.internal.http.StringBodyPart;
import com.adobe.pdfservices.operation.internal.util.InputStreamUtil;
import com.adobe.pdfservices.operation.internal.util.StringUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CPFApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(CPFApi.class);
    private static final String CONTENT_ANALYZER_REQUESTS_STRING = "contentAnalyzerRequests";
    private static final long TIME_LIMIT_MS = 600000L;
    private static final int ACCEPTED_SUCCESS_STATUS_CODE = 202;
    private static final int POLLING_TIMEOUT_STATUS_CODE = 0;
    private static final long POLLING_INTERVAL = 1000L;
    private static final long DELAY_POLLING_INTERVAL = 1000L;

    public static <T> HttpResponse<T> cpfCreateOpsApi(InternalExecutionContext context, CPFContentAnalyzerRequests CPFContentAnalyzerRequests2, List<FileRefImpl> sourceFileRefList, Class<T> responseType, String operation) throws FileNotFoundException {
        try {
            HttpClient httpClient = HttpClientFactory.getDefaultHttpClient();
            MultiPartRequest multipartRequest = (MultiPartRequest)context.getBaseRequestFromRequestContext(RequestKey.CREATE);
            CPFApi.prepareMultiPartRequest(multipartRequest, CPFContentAnalyzerRequests2, sourceFileRefList, operation);
            return httpClient.send(multipartRequest, responseType);
        }
        catch (FileNotFoundException fe) {
            throw fe;
        }
        catch (IOException io) {
            throw new SdkException("Unexpected error while uploading file", io);
        }
    }

    public static <T> HttpResponse<T> cpfStatusApi(InternalExecutionContext context, String location, Class<T> responseType) {
        BaseHttpRequest baseHttpRequest = (BaseHttpRequest)context.getBaseRequestFromRequestContext(RequestKey.STATUS);
        baseHttpRequest.withTemplate(location);
        HttpClient httpClient = HttpClientFactory.getDefaultHttpClient();
        HttpResponse<T> response = httpClient.send(baseHttpRequest, responseType);
        long startTimeMs = System.currentTimeMillis();
        int count = 1;
        while (response.getStatusCode() == 202) {
            long retryIntervalMs;
            LOGGER.debug("Polling for status ");
            long l = retryIntervalMs = count > 5 ? 1000L : 1000L;
            if (System.currentTimeMillis() - startTimeMs > 600000L) {
                LOGGER.debug("Polling Timeout reached. Something's wrong, file operation took too long");
                throw new OperationException("Operation execution has timed out!", StringUtil.getRequestIdFromLocation(location), 0);
            }
            try {
                TimeUnit.MILLISECONDS.sleep(retryIntervalMs);
            }
            catch (InterruptedException ex) {
                throw new SdkException("Thread interrupted while waiting for operation execution status!!", ex);
            }
            response = httpClient.send(baseHttpRequest, responseType);
            ++count;
        }
        return response;
    }

    private static <T> void prepareMultiPartRequest(MultiPartRequest multipartRequest, T contentAnalyzerRequests, List<FileRefImpl> sourceFileRefList, String operation) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        String contentAnalyzerRequestsString = objectMapper.writeValueAsString(contentAnalyzerRequests);
        StringBodyPart stringBodyPart = new StringBodyPart(CONTENT_ANALYZER_REQUESTS_STRING, contentAnalyzerRequestsString, ExtensionMediaTypeMapping.TXT.getMediaType());
        multipartRequest = multipartRequest.withStringBodyPart(stringBodyPart);
        int partNumber = 1;
        for (FileRefImpl fileRef : sourceFileRefList) {
            if (fileRef.getAsStream() == null) continue;
            InputStreamPart inputStreamPart = InputStreamUtil.createInputStreamPart(fileRef, partNumber);
            multipartRequest.withInputStreamPart(inputStreamPart);
            ++partNumber;
        }
        multipartRequest.withHeader("x-dcsdk-ops-info", operation);
    }
}

