/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.pdfops.options.protectpdf;

import com.adobe.pdfservices.operation.pdfops.ProtectPDFOperation;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

/**
 * Document Permissions for {@link ProtectPDFOperation}
 */
public class Permissions {

    private Set<Permission> permissionsSet;

    private Permissions() {
        permissionsSet = new HashSet<>();
    }

    /**
     * Creates a new {@code Permissions} instance.
     *
     * @return a {@code Permissions} instance
     */
    public static Permissions createNew() {
        return new Permissions();
    }

    /**
     * Returns the intended set of document permissions values.
     *
     * @return the set of document permissions
     */
    public Set<Permission> getValues() {
        return permissionsSet;
    }

    /**
     * Adds a document {@link Permission} in the permissions set.
     *
     * @param permission a document permission; can not be null
     */
    public void addPermission(Permission permission) {
        Objects.requireNonNull(permission, "Permission can not be null");
        permissionsSet.add(permission);
    }
}
