/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.pdfops.options.protectpdf;

import com.adobe.pdfservices.operation.pdfops.ProtectPDFOperation;

/**
 * Supported types of content to encrypt for {@link ProtectPDFOperation}
 */
public enum ContentEncryption {

    /**
     * Encrypts all the content of the PDF file
     */
    ALL_CONTENT("ALL_CONTENT"),

    /**
     * Encrypts all the content except the metadata of the PDF file
     */
    ALL_CONTENT_EXCEPT_METADATA("ALL_CONTENT_EXCEPT_METADATA");

    private final String value;

    /**
     * Constructor.
     *
     * @param value type of content to encrypt
     */
    ContentEncryption(String value) {
        this.value = value;
    }

    /**
     * Returns the value of the type of content to encrypt
     *
     * @return string value of the type of content to encrypt
     */
    public String getValue() {
        return value;
    }
}
