/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.pdfops.options.documentmerge;

import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * Class for providing support for Fragments. To know more about fragments
 * use-case in document generation and document templates, please see the
 * <a href=
 * "http://www.adobe.com/go/dcdocgen_fragments_support">documentation</a>
 */
public class Fragments {

    private List<JSONObject> fragmentsList;

    /**
     * Creates a new {@link Fragments} instance
     */
    public Fragments() {
        fragmentsList = new ArrayList<>();
    }

    /**
     * To add JsonObject into the fragmentsList.
     * @param fragment JSON Object to be added to fragmentsList
     */
    public void addFragment(JSONObject fragment) {
        fragmentsList.add(fragment);
    }

    /**
     * To add List of JsonObject into the fragmentsList.
     * @param fragments List of JSON object to be added to fragmentsList
     */
    public void addFragments(List<JSONObject> fragments) {
        fragmentsList.addAll(fragments);
    }

    /**
     * Gets the fragementsList.
     * @return the list of fragments
     */
    public List<JSONObject> getFragmentsList() {
        return fragmentsList;
    }
}
