/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.util;

import java.io.IOException;

import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.http.ByteArrayPart;

public class ByteArrayUtil {

    private static final String FILE_FORM_FIELD_NAME = "file";

    public static ByteArrayPart createByteArrayPart(FileRefImpl fileRefImpl, int partNumber) throws IOException {
        byte[] fileUploadBody = fileRefImpl.getByteArray();
        String fileName = fileRefImpl.getName();
        if (StringUtil.isBlank(fileName)) {
            fileName = FileUtil.getRandomFileName(fileRefImpl.getExtension());
        }
        return new ByteArrayPart(FILE_FORM_FIELD_NAME + partNumber, fileUploadBody, fileName);
    }
}
