/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.service;

import com.adobe.pdfservices.operation.internal.FileRefImpl;
import com.adobe.pdfservices.operation.internal.InternalExecutionContext;
import com.adobe.pdfservices.operation.internal.api.CPFApi;
import com.adobe.pdfservices.operation.internal.cpf.constants.CPFConstants;
import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.*;
import com.adobe.pdfservices.operation.internal.http.DefaultRequestHeaders;
import com.adobe.pdfservices.operation.internal.http.HttpResponse;
import com.adobe.pdfservices.operation.pdfops.options.pdfproperties.PDFPropertiesOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;

public class PDFPropertiesService {

    private static final String INPUT_FORMAT_SPECIFIER = "application/pdf";
    private static final String OUTPUT_PDFPROPERTIES_INFO_FORMAT_SPECIFIER = "application/json";

    public static String getPdfProperties(InternalExecutionContext context,
                                        FileRefImpl sourceFileRef, PDFPropertiesOptions pdfPropertiesOptions, String operation)
            throws FileNotFoundException {

        try{
            PDFPropertiesParams pdfPropertiesParams = PDFPropertiesParams.createFrom(pdfPropertiesOptions);
            Inputs inputs = Inputs.builder(INPUT_FORMAT_SPECIFIER)
                    .setParams(pdfPropertiesParams)
                    .build();
            Outputs outputs = new Outputs();
            outputs.setMetadataFrom(OUTPUT_PDFPROPERTIES_INFO_FORMAT_SPECIFIER);

            CPFContentAnalyzerRequests cpfContentAnalyzerRequests
                    = new CPFContentAnalyzerRequests(CPFConstants.PDFProperties.PAPI_ENGINE_REPO_ASSET_ID, inputs, outputs);

            // Prepare the sourceFileRefList
            List<FileRefImpl> sourceFileRefList = new ArrayList<>();
            sourceFileRefList.add(sourceFileRef);

            HttpResponse<String> response = CPFApi.cpfCreateOpsApi(context, cpfContentAnalyzerRequests,
                    sourceFileRefList, String.class, operation);
            return response.getHeaders().get(DefaultRequestHeaders.LOCATION_HEADER_NAME);
        } catch (FileNotFoundException fe) {
            throw fe;
        }
    }

}
