/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.internal.cpf.dto.request.platform;

import com.adobe.pdfservices.operation.internal.cpf.dto.request.platform.multipleInputsField.CPFMultipleInputsField;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.net.URL;
import java.util.List;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class Inputs {

    @JsonProperty("documentIn")
    private MultiPartFormField multiPartFormField;

    @JsonProperty("documentsIn")
    private List<CPFMultipleInputsField> cpfMultipleInputsFields;

    @JsonProperty("params")
    private CPFParams cpfParams;

    @JsonProperty("inputUrl")
    private String sourceUrl;

    private Inputs(MultiPartFormField multiPartFormField, CPFParams cpfParams) {
        this.multiPartFormField = multiPartFormField;
        this.cpfParams = cpfParams;
    }

    public Inputs(List<CPFMultipleInputsField> cpfMultipleInputsFields) {
        this.cpfMultipleInputsFields = cpfMultipleInputsFields;
    }

    public Inputs(URL sourceUrl,CPFParams cpfParams) {
        this.sourceUrl = sourceUrl.toString();
        this.cpfParams = cpfParams;
    }

    public static Builder builder(String inputFormat) {
        return new Builder(inputFormat);
    }

    public static class Builder {

        private static final String FILE_FORM_FIELD_NAME = "file1";

        private String inputFormat;

        private URL sourceUrl;

        private PlatformParams params;

        private CPFParams cpfParams;

        public Builder(String inputFormat) {
            this.inputFormat = inputFormat;
        }

        public Builder setParams(PlatformParams params) {
            this.params = params;
            return this;
        }

        public Builder setSourceUrl(URL sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        public Inputs build() {

            if(this.params != null) {
                this.cpfParams = new CPFParams(params);
            }
            
            if(this.sourceUrl != null) {
                return new Inputs(sourceUrl,cpfParams);
            }
            return new Inputs(new MultiPartFormField(inputFormat, FILE_FORM_FIELD_NAME), cpfParams);
        }
    }
}
