/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */

package com.adobe.pdfservices.operation.exception;

/**
 * SdkException is typically thrown for client-side or network errors.
 *
 * @see ServiceApiException
 * @see ServiceUsageException
 */
public class SdkException extends RuntimeException {

    /**
     * Creates an SdkException with the specified detail message and cause.
     *
     * @param message the detail message
     * @param cause   the cause (which is saved for later retrieval by the Throwable.getCause() method). (A null value is
     *                permitted, and indicates that the cause is nonexistent or unknown.)
     */
    public SdkException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs an SdkException with the specified detail message.
     *
     * @param message the detail message
     */
    public SdkException(String message) {
        super(message);
    }

}


