/*
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it. If you have received this file from a source other than Adobe,
 * then your use, modification, or distribution of it requires the prior
 * written permission of Adobe.
 */


package com.adobe.pdfservices.operation.auth;

/**
 * Marker base class for different types of credentials. Currently it supports only {@link ServiceAccountCredentials}.
 * The factory methods within this class can be used to create instances of credentials classes.
 */
public abstract class Credentials {

    protected Credentials() {
    }

    /**
     * Creates a new {@code ServiceAccountCredentials} builder.
     *
     * @return a {@code ServiceAccountCredentials.Builder} instance
     */
    public static ServiceAccountCredentials.Builder serviceAccountCredentialsBuilder() {
        return new ServiceAccountCredentials.Builder();
    }
}
