/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
package org.apache.sling.scripting.sightly.apps.core.wcm.components.title.v2.title;

import java.io.PrintWriter;
import java.util.Collection;
import javax.script.Bindings;

import org.apache.sling.scripting.sightly.java.compiler.RenderUnit;
import org.apache.sling.scripting.sightly.render.RenderContext;

public final class title_html extends RenderUnit {

    @Override
    protected final void render(PrintWriter out,
                                Bindings bindings,
                                Bindings arguments,
                                RenderContext renderContext) {
// Main Template Body -----------------------------------------------------------------------------

Object _global_title = null;
Object _global_template = null;
Object _global_text = null;
out.write("\n");
_global_title = renderContext.call("use", com.adobe.cq.wcm.core.components.models.Title.class.getName(), obj());
_global_template = renderContext.call("use", "core/wcm/components/commons/v1/templates.html", obj());
_global_text = renderContext.getObjectModel().resolveProperty(_global_title, "text");
if (renderContext.getObjectModel().toBoolean(_global_text)) {
    out.write("<div class=\"cmp-title\">\n    ");
    {
        Object var_tagvar0 = renderContext.call("xss", renderContext.getObjectModel().resolveProperty(_global_title, "type"), "elementName");
        if (renderContext.getObjectModel().toBoolean(var_tagvar0)) {
            out.write("<");
            out.write(renderContext.getObjectModel().toString(var_tagvar0));
        }
        if (!renderContext.getObjectModel().toBoolean(var_tagvar0)) {
            out.write("<h1");
        }
        out.write(" class=\"cmp-title__text\">");
        {
            Object var_unwrapcondition1 = (((!renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_title, "linkURL"))) ? (!renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_title, "linkURL"))) : renderContext.getObjectModel().resolveProperty(_global_title, "linkDisabled")));
            if (!renderContext.getObjectModel().toBoolean(var_unwrapcondition1)) {
                out.write("<a class=\"cmp-title__link\"");
                {
                    Object var_attrvalue2 = renderContext.getObjectModel().resolveProperty(_global_title, "linkURL");
                    {
                        Object var_attrcontent3 = renderContext.call("xss", var_attrvalue2, "uri");
                        {
                            Object var_shoulddisplayattr5 = ((renderContext.getObjectModel().toBoolean(var_attrcontent3) ? var_attrcontent3 : ("false".equals(var_attrvalue2))));
                            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr5)) {
                                out.write(" href");
                                {
                                    boolean var_istrueattr4 = (var_attrvalue2.equals(true));
                                    if (!var_istrueattr4) {
                                        out.write("=\"");
                                        out.write(renderContext.getObjectModel().toString(var_attrcontent3));
                                        out.write("\"");
                                    }
                                }
                            }
                        }
                    }
                }
                out.write(">");
            }
            {
                Object var_6 = renderContext.call("xss", _global_text, "text");
                out.write(renderContext.getObjectModel().toString(var_6));
            }
            if (!renderContext.getObjectModel().toBoolean(var_unwrapcondition1)) {
                out.write("</a>");
            }
        }
        if (renderContext.getObjectModel().toBoolean(var_tagvar0)) {
            out.write("</");
            out.write(renderContext.getObjectModel().toString(var_tagvar0));
            out.write(">");
        }
        if (!renderContext.getObjectModel().toBoolean(var_tagvar0)) {
            out.write("</h1>");
        }
    }
    out.write("\n</div>");
}
out.write("\n");
{
    Object var_templatevar7 = renderContext.getObjectModel().resolveProperty(_global_template, "placeholder");
    {
        boolean var_templateoptions8_field$_isempty = (!renderContext.getObjectModel().toBoolean(_global_text));
        {
            String var_templateoptions8_field$_classappend = "cmp-title";
            {
                java.util.Map var_templateoptions8 = obj().with("isEmpty", var_templateoptions8_field$_isempty).with("classAppend", var_templateoptions8_field$_classappend);
                callUnit(out, renderContext, var_templatevar7, var_templateoptions8);
            }
        }
    }
}
out.write("\n");


// End Of Main Template Body ----------------------------------------------------------------------
    }



    {
//Sub-Templates Initialization --------------------------------------------------------------------



//End of Sub-Templates Initialization -------------------------------------------------------------
    }

}

