/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
package org.apache.sling.scripting.sightly.apps.core.wcm.components.text.v2.text;

import java.io.PrintWriter;
import java.util.Collection;
import javax.script.Bindings;

import org.apache.sling.scripting.sightly.java.compiler.RenderUnit;
import org.apache.sling.scripting.sightly.render.RenderContext;

public final class text_html extends RenderUnit {

    @Override
    protected final void render(PrintWriter out,
                                Bindings bindings,
                                Bindings arguments,
                                RenderContext renderContext) {
// Main Template Body -----------------------------------------------------------------------------

Object _global_textmodel = null;
Object _global_templates = null;
Object _global_text = null;
out.write("\n");
_global_textmodel = renderContext.call("use", com.adobe.cq.wcm.core.components.models.Text.class.getName(), obj());
_global_templates = renderContext.call("use", "core/wcm/components/commons/v1/templates.html", obj());
_global_text = renderContext.getObjectModel().resolveProperty(_global_textmodel, "text");
if (renderContext.getObjectModel().toBoolean(_global_text)) {
    out.write("<div class=\"cmp-text\">\n    ");
    {
        Object var_unwrapcondition0 = renderContext.getObjectModel().resolveProperty(_global_textmodel, "isRichText");
        if (!renderContext.getObjectModel().toBoolean(var_unwrapcondition0)) {
            out.write("<p class=\"cmp-text__paragraph\">");
        }
        {
            Object var_1 = renderContext.call("xss", _global_text, (renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_textmodel, "isRichText")) ? "html" : "text"));
            out.write(renderContext.getObjectModel().toString(var_1));
        }
        if (!renderContext.getObjectModel().toBoolean(var_unwrapcondition0)) {
            out.write("</p>");
        }
    }
    out.write("\n</div>");
}
out.write("\n");
{
    Object var_templatevar2 = renderContext.getObjectModel().resolveProperty(_global_templates, "placeholder");
    {
        boolean var_templateoptions3_field$_isempty = (!renderContext.getObjectModel().toBoolean(_global_text));
        {
            String var_templateoptions3_field$_classappend = "cmp-text";
            {
                java.util.Map var_templateoptions3 = obj().with("isEmpty", var_templateoptions3_field$_isempty).with("classAppend", var_templateoptions3_field$_classappend);
                callUnit(out, renderContext, var_templatevar2, var_templateoptions3);
            }
        }
    }
}
out.write("\n");


// End Of Main Template Body ----------------------------------------------------------------------
    }



    {
//Sub-Templates Initialization --------------------------------------------------------------------



//End of Sub-Templates Initialization -------------------------------------------------------------
    }

}

