/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
package org.apache.sling.scripting.sightly.apps.core.wcm.components.teaser.v1.teaser;

import java.io.PrintWriter;
import java.util.Collection;
import javax.script.Bindings;

import org.apache.sling.scripting.sightly.java.compiler.RenderUnit;
import org.apache.sling.scripting.sightly.render.RenderContext;

public final class teaser_html extends RenderUnit {

    @Override
    protected final void render(PrintWriter out,
                                Bindings bindings,
                                Bindings arguments,
                                RenderContext renderContext) {
// Main Template Body -----------------------------------------------------------------------------

Object _global_teaser = null;
Object _global_templates = null;
Object _global_imagetemplate = null;
Object _global_titletemplate = null;
Object _global_descriptiontemplate = null;
Object _global_actionstemplate = null;
Object _global_hascontent = null;
Object _dynamic_wcmmode = bindings.get("wcmmode");
out.write("\n");
_global_teaser = renderContext.call("use", com.adobe.cq.wcm.core.components.models.Teaser.class.getName(), obj());
_global_templates = renderContext.call("use", "core/wcm/components/commons/v1/templates.html", obj());
_global_imagetemplate = renderContext.call("use", "image.html", obj());
_global_titletemplate = renderContext.call("use", "title.html", obj());
_global_descriptiontemplate = renderContext.call("use", "description.html", obj());
_global_actionstemplate = renderContext.call("use", "actions.html", obj());
_global_hascontent = ((renderContext.getObjectModel().toBoolean(((renderContext.getObjectModel().toBoolean(((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_teaser, "imageResource")) ? renderContext.getObjectModel().resolveProperty(_global_teaser, "imageResource") : renderContext.getObjectModel().resolveProperty(_global_teaser, "title")))) ? ((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_teaser, "imageResource")) ? renderContext.getObjectModel().resolveProperty(_global_teaser, "imageResource") : renderContext.getObjectModel().resolveProperty(_global_teaser, "title"))) : renderContext.getObjectModel().resolveProperty(_global_teaser, "description")))) ? ((renderContext.getObjectModel().toBoolean(((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_teaser, "imageResource")) ? renderContext.getObjectModel().resolveProperty(_global_teaser, "imageResource") : renderContext.getObjectModel().resolveProperty(_global_teaser, "title")))) ? ((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_teaser, "imageResource")) ? renderContext.getObjectModel().resolveProperty(_global_teaser, "imageResource") : renderContext.getObjectModel().resolveProperty(_global_teaser, "title"))) : renderContext.getObjectModel().resolveProperty(_global_teaser, "description"))) : (!(org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator.leq(renderContext.getObjectModel().resolveProperty(renderContext.getObjectModel().resolveProperty(_global_teaser, "actions"), "size"), 0)))));
if (renderContext.getObjectModel().toBoolean(_global_hascontent)) {
    out.write("<div");
    {
        String var_attrcontent0 = ("cmp-teaser" + renderContext.getObjectModel().toString(renderContext.call("xss", (renderContext.getObjectModel().toBoolean((((!renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "disabled"))) ? renderContext.getObjectModel().resolveProperty(_global_teaser, "imageResource") : (!renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "disabled")))))) ? " cq-dd-image" : ""), "attribute")));
        {
            Object var_shoulddisplayattr1 = ((renderContext.getObjectModel().toBoolean(var_attrcontent0) ? var_attrcontent0 : ("false".equals(var_attrcontent0))));
            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr1)) {
                out.write(" class=\"");
                out.write(renderContext.getObjectModel().toString(var_attrcontent0));
                out.write("\"");
            }
        }
    }
    out.write(">\n    ");
    {
        Object var_templatevar2 = renderContext.getObjectModel().resolveProperty(_global_imagetemplate, "image");
        {
            Object var_templateoptions3_field$_teaser = _global_teaser;
            {
                java.util.Map var_templateoptions3 = obj().with("teaser", var_templateoptions3_field$_teaser);
                callUnit(out, renderContext, var_templatevar2, var_templateoptions3);
            }
        }
    }
    out.write("\n    <div class=\"cmp-teaser__content\">\n        ");
    {
        Object var_templatevar4 = renderContext.getObjectModel().resolveProperty(_global_titletemplate, "title");
        {
            Object var_templateoptions5_field$_teaser = _global_teaser;
            {
                java.util.Map var_templateoptions5 = obj().with("teaser", var_templateoptions5_field$_teaser);
                callUnit(out, renderContext, var_templatevar4, var_templateoptions5);
            }
        }
    }
    out.write("\n        ");
    {
        Object var_templatevar6 = renderContext.getObjectModel().resolveProperty(_global_descriptiontemplate, "description");
        {
            Object var_templateoptions7_field$_teaser = _global_teaser;
            {
                java.util.Map var_templateoptions7 = obj().with("teaser", var_templateoptions7_field$_teaser);
                callUnit(out, renderContext, var_templatevar6, var_templateoptions7);
            }
        }
    }
    out.write("\n        ");
    {
        Object var_templatevar8 = renderContext.getObjectModel().resolveProperty(_global_actionstemplate, "actions");
        {
            Object var_templateoptions9_field$_teaser = _global_teaser;
            {
                java.util.Map var_templateoptions9 = obj().with("teaser", var_templateoptions9_field$_teaser);
                callUnit(out, renderContext, var_templatevar8, var_templateoptions9);
            }
        }
    }
    out.write("\n    </div>\n</div>");
}
out.write("\n");
{
    Object var_templatevar10 = renderContext.getObjectModel().resolveProperty(_global_templates, "placeholder");
    {
        boolean var_templateoptions11_field$_isempty = (!renderContext.getObjectModel().toBoolean(_global_hascontent));
        {
            String var_templateoptions11_field$_classappend = "cmp-teaser";
            {
                java.util.Map var_templateoptions11 = obj().with("isEmpty", var_templateoptions11_field$_isempty).with("classAppend", var_templateoptions11_field$_classappend);
                callUnit(out, renderContext, var_templatevar10, var_templateoptions11);
            }
        }
    }
}
out.write("\n");


// End Of Main Template Body ----------------------------------------------------------------------
    }



    {
//Sub-Templates Initialization --------------------------------------------------------------------



//End of Sub-Templates Initialization -------------------------------------------------------------
    }

}

