/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
package org.apache.sling.scripting.sightly.apps.core.wcm.components.tabs.v1.tabs;

import java.io.PrintWriter;
import java.util.Collection;
import javax.script.Bindings;

import org.apache.sling.scripting.sightly.java.compiler.RenderUnit;
import org.apache.sling.scripting.sightly.render.RenderContext;

public final class tabs_html extends RenderUnit {

    @Override
    protected final void render(PrintWriter out,
                                Bindings bindings,
                                Bindings arguments,
                                RenderContext renderContext) {
// Main Template Body -----------------------------------------------------------------------------

Object _global_tabs = null;
Object _global_templates = null;
Collection var_collectionvar0_list_coerced$ = null;
Object _global_isactive = null;
Collection var_collectionvar22_list_coerced$ = null;
Object _dynamic_wcmmode = bindings.get("wcmmode");
Object _dynamic_resource = bindings.get("resource");
out.write("\n");
_global_tabs = renderContext.call("use", com.adobe.cq.wcm.core.components.models.Tabs.class.getName(), obj());
_global_templates = renderContext.call("use", "core/wcm/components/commons/v1/templates.html", obj());
out.write("<div class=\"cmp-tabs\" data-cmp-is=\"tabs\">\n    ");
{
    Object var_testvariable7 = ((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_tabs, "items")) ? (!(org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator.leq(renderContext.getObjectModel().resolveProperty(renderContext.getObjectModel().resolveProperty(_global_tabs, "items"), "size"), 0))) : renderContext.getObjectModel().resolveProperty(_global_tabs, "items")));
    if (renderContext.getObjectModel().toBoolean(var_testvariable7)) {
        {
            Object var_collectionvar0 = renderContext.getObjectModel().resolveProperty(_global_tabs, "items");
            {
                long var_size1 = ((var_collectionvar0_list_coerced$ == null ? (var_collectionvar0_list_coerced$ = renderContext.getObjectModel().toCollection(var_collectionvar0)) : var_collectionvar0_list_coerced$).size());
                {
                    boolean var_notempty2 = (var_size1 > 0);
                    if (var_notempty2) {
                        {
                            long var_end5 = var_size1;
                            {
                                boolean var_validstartstepend6 = (((0 < var_size1) && true) && (var_end5 > 0));
                                if (var_validstartstepend6) {
                                    out.write("<ol role=\"tablist\" class=\"cmp-tabs__tablist\"");
                                    {
                                        Object var_attrvalue8 = renderContext.getObjectModel().resolveProperty(_global_tabs, "accessibilityLabel");
                                        {
                                            Object var_attrcontent9 = renderContext.call("xss", var_attrvalue8, "attribute");
                                            {
                                                Object var_shoulddisplayattr11 = ((renderContext.getObjectModel().toBoolean(var_attrcontent9) ? var_attrcontent9 : ("false".equals(var_attrvalue8))));
                                                if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr11)) {
                                                    out.write(" aria-label");
                                                    {
                                                        boolean var_istrueattr10 = (var_attrvalue8.equals(true));
                                                        if (!var_istrueattr10) {
                                                            out.write("=\"");
                                                            out.write(renderContext.getObjectModel().toString(var_attrcontent9));
                                                            out.write("\"");
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    out.write(" aria-multiselectable=\"false\">");
                                    if (var_collectionvar0_list_coerced$ == null) {
                                        var_collectionvar0_list_coerced$ = renderContext.getObjectModel().toCollection(var_collectionvar0);
                                    }
                                    long var_index12 = 0;
                                    for (Object tab : var_collectionvar0_list_coerced$) {
                                        {
                                            long var_stepcondition13 = ((var_index12 - 0) % 1);
                                            {
                                                boolean var_traversal14 = (((var_index12 >= 0) && (var_index12 <= var_end5)) && (var_stepcondition13 == 0));
                                                if (var_traversal14) {
                                                    out.write("\n        ");
_global_isactive = (org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator.strictEq(renderContext.getObjectModel().resolveProperty(tab, "name"), renderContext.getObjectModel().resolveProperty(_global_tabs, "activeItem")));
                                                    if (renderContext.getObjectModel().toBoolean(_global_isactive)) {
                                                    }
                                                    out.write("\n        <li role=\"tab\"");
                                                    {
                                                        String var_attrcontent15 = ("cmp-tabs__tab" + renderContext.getObjectModel().toString(renderContext.call("xss", (renderContext.getObjectModel().toBoolean(_global_isactive) ? " cmp-tabs__tab--active" : ""), "attribute")));
                                                        {
                                                            Object var_shoulddisplayattr16 = ((renderContext.getObjectModel().toBoolean(var_attrcontent15) ? var_attrcontent15 : ("false".equals(var_attrcontent15))));
                                                            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr16)) {
                                                                out.write(" class=\"");
                                                                out.write(renderContext.getObjectModel().toString(var_attrcontent15));
                                                                out.write("\"");
                                                            }
                                                        }
                                                    }
                                                    {
                                                        String var_attrvalue17 = (renderContext.getObjectModel().toBoolean(_global_isactive) ? "0" : "-1");
                                                        {
                                                            Object var_attrcontent18 = renderContext.call("xss", var_attrvalue17, "attribute");
                                                            {
                                                                Object var_shoulddisplayattr20 = ((renderContext.getObjectModel().toBoolean(var_attrcontent18) ? var_attrcontent18 : ("false".equals(var_attrvalue17))));
                                                                if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr20)) {
                                                                    out.write(" tabindex");
                                                                    {
                                                                        boolean var_istrueattr19 = (var_attrvalue17.equals(true));
                                                                        if (!var_istrueattr19) {
                                                                            out.write("=\"");
                                                                            out.write(renderContext.getObjectModel().toString(var_attrcontent18));
                                                                            out.write("\"");
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    out.write(" data-cmp-hook-tabs=\"tab\">");
                                                    {
                                                        Object var_21 = renderContext.call("xss", renderContext.getObjectModel().resolveProperty(tab, "title"), "text");
                                                        out.write(renderContext.getObjectModel().toString(var_21));
                                                    }
                                                    out.write("</li>\n    ");
                                                }
                                            }
                                        }
                                        var_index12++;
                                    }
                                    out.write("</ol>");
                                }
                            }
                        }
                    }
                }
            }
            var_collectionvar0_list_coerced$ = null;
        }
    }
}
out.write("\n    ");
{
    Object var_collectionvar22 = renderContext.getObjectModel().resolveProperty(_global_tabs, "items");
    {
        long var_size23 = ((var_collectionvar22_list_coerced$ == null ? (var_collectionvar22_list_coerced$ = renderContext.getObjectModel().toCollection(var_collectionvar22)) : var_collectionvar22_list_coerced$).size());
        {
            boolean var_notempty24 = (var_size23 > 0);
            if (var_notempty24) {
                {
                    long var_end27 = var_size23;
                    {
                        boolean var_validstartstepend28 = (((0 < var_size23) && true) && (var_end27 > 0));
                        if (var_validstartstepend28) {
                            if (var_collectionvar22_list_coerced$ == null) {
                                var_collectionvar22_list_coerced$ = renderContext.getObjectModel().toCollection(var_collectionvar22);
                            }
                            long var_index29 = 0;
                            for (Object item : var_collectionvar22_list_coerced$) {
                                {
                                    long var_stepcondition30 = ((var_index29 - 0) % 1);
                                    {
                                        boolean var_traversal31 = (((var_index29 >= 0) && (var_index29 <= var_end27)) && (var_stepcondition30 == 0));
                                        if (var_traversal31) {
                                            out.write("<div role=\"tabpanel\" tabindex=\"0\"");
                                            {
                                                String var_attrcontent32 = ("cmp-tabs__tabpanel" + renderContext.getObjectModel().toString(renderContext.call("xss", ((org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator.strictEq(renderContext.getObjectModel().resolveProperty(item, "name"), renderContext.getObjectModel().resolveProperty(_global_tabs, "activeItem"))) ? " cmp-tabs__tabpanel--active" : ""), "attribute")));
                                                {
                                                    Object var_shoulddisplayattr33 = ((renderContext.getObjectModel().toBoolean(var_attrcontent32) ? var_attrcontent32 : ("false".equals(var_attrcontent32))));
                                                    if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr33)) {
                                                        out.write(" class=\"");
                                                        out.write(renderContext.getObjectModel().toString(var_attrcontent32));
                                                        out.write("\"");
                                                    }
                                                }
                                            }
                                            out.write(" data-cmp-hook-tabs=\"tabpanel\">");
                                            {
                                                Object var_resourcecontent34 = renderContext.call("includeResource", renderContext.getObjectModel().resolveProperty(item, "name"), obj().with("decorationTagName", "div"));
                                                out.write(renderContext.getObjectModel().toString(var_resourcecontent34));
                                            }
                                            out.write("</div>\n");
                                        }
                                    }
                                }
                                var_index29++;
                            }
                        }
                    }
                }
            }
        }
    }
    var_collectionvar22_list_coerced$ = null;
}
out.write("\n    ");
{
    Object var_testvariable35 = ((renderContext.getObjectModel().toBoolean(((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "edit")) ? renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "edit") : renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "preview")))) ? (org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator.lt(renderContext.getObjectModel().resolveProperty(renderContext.getObjectModel().resolveProperty(_global_tabs, "items"), "size"), 1)) : ((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "edit")) ? renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "edit") : renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "preview")))));
    if (renderContext.getObjectModel().toBoolean(var_testvariable35)) {
        {
            Object var_resourcecontent36 = renderContext.call("includeResource", renderContext.getObjectModel().resolveProperty(_dynamic_resource, "path"), obj().with("cssClassName", "new section aem-Grid-newComponent").with("decorationTagName", "div").with("appendPath", "/*").with("resourceType", "wcm/foundation/components/parsys/newpar"));
            out.write(renderContext.getObjectModel().toString(var_resourcecontent36));
        }
    }
}
out.write("\n</div>\n");


// End Of Main Template Body ----------------------------------------------------------------------
    }



    {
//Sub-Templates Initialization --------------------------------------------------------------------



//End of Sub-Templates Initialization -------------------------------------------------------------
    }

}

