/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
package org.apache.sling.scripting.sightly.apps.core.wcm.components.sharing.v1.sharing;

import java.io.PrintWriter;
import java.util.Collection;
import javax.script.Bindings;

import org.apache.sling.scripting.sightly.java.compiler.RenderUnit;
import org.apache.sling.scripting.sightly.render.RenderContext;

public final class sharing_html extends RenderUnit {

    @Override
    protected final void render(PrintWriter out,
                                Bindings bindings,
                                Bindings arguments,
                                RenderContext renderContext) {
// Main Template Body -----------------------------------------------------------------------------

Object _global_template = null;
Object _global_socialmedia = null;
out.write("\n");
_global_template = renderContext.call("use", "core/wcm/components/commons/v1/templates.html", obj());
_global_socialmedia = renderContext.call("use", com.adobe.cq.wcm.core.components.models.SocialMediaHelper.class.getName(), obj());
{
    Object var_templatevar0 = renderContext.getObjectModel().resolveProperty(_global_template, "placeholder");
    {
        boolean var_templateoptions1_field$_isempty = (!renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_socialmedia, "socialMediaEnabled")));
        {
            java.util.Map var_templateoptions1 = obj().with("isEmpty", var_templateoptions1_field$_isempty);
            callUnit(out, renderContext, var_templatevar0, var_templateoptions1);
        }
    }
}
out.write("\n");
{
    Object var_testvariable2 = renderContext.getObjectModel().resolveProperty(_global_socialmedia, "facebookEnabled");
    if (renderContext.getObjectModel().toBoolean(var_testvariable2)) {
        out.write("<div class=\"fb-share-button\"");
        {
            Object var_attrvalue3 = renderContext.getObjectModel().resolveProperty(renderContext.getObjectModel().resolveProperty(_global_socialmedia, "metadata"), "og:url");
            {
                Object var_attrcontent4 = renderContext.call("xss", var_attrvalue3, "attribute");
                {
                    Object var_shoulddisplayattr6 = ((renderContext.getObjectModel().toBoolean(var_attrcontent4) ? var_attrcontent4 : ("false".equals(var_attrvalue3))));
                    if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr6)) {
                        out.write(" data-href");
                        {
                            boolean var_istrueattr5 = (var_attrvalue3.equals(true));
                            if (!var_istrueattr5) {
                                out.write("=\"");
                                out.write(renderContext.getObjectModel().toString(var_attrcontent4));
                                out.write("\"");
                            }
                        }
                    }
                }
            }
        }
        out.write(" data-layout=\"button_count\" data-size=\"small\" data-mobile-iframe=\"false\">\n</div>");
    }
}
out.write("\n");
{
    Object var_testvariable7 = renderContext.getObjectModel().resolveProperty(_global_socialmedia, "pinterestEnabled");
    if (renderContext.getObjectModel().toBoolean(var_testvariable7)) {
        out.write("<a data-pin-do=\"buttonPin\" data-pin-count=\"beside\" data-pin-save=\"true\"");
        {
            Object var_attrvalue8 = renderContext.getObjectModel().resolveProperty(renderContext.getObjectModel().resolveProperty(_global_socialmedia, "metadata"), "og:image");
            {
                Object var_attrcontent9 = renderContext.call("xss", var_attrvalue8, "attribute");
                {
                    Object var_shoulddisplayattr11 = ((renderContext.getObjectModel().toBoolean(var_attrcontent9) ? var_attrcontent9 : ("false".equals(var_attrvalue8))));
                    if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr11)) {
                        out.write(" data-pin-media");
                        {
                            boolean var_istrueattr10 = (var_attrvalue8.equals(true));
                            if (!var_istrueattr10) {
                                out.write("=\"");
                                out.write(renderContext.getObjectModel().toString(var_attrcontent9));
                                out.write("\"");
                            }
                        }
                    }
                }
            }
        }
        out.write(" href=\"https://www.pinterest.com/pin/create/button/\"></a>");
    }
}


// End Of Main Template Body ----------------------------------------------------------------------
    }



    {
//Sub-Templates Initialization --------------------------------------------------------------------



//End of Sub-Templates Initialization -------------------------------------------------------------
    }

}

