/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
package org.apache.sling.scripting.sightly.apps.core.wcm.components.search.v1.search;

import java.io.PrintWriter;
import java.util.Collection;
import javax.script.Bindings;

import org.apache.sling.scripting.sightly.java.compiler.RenderUnit;
import org.apache.sling.scripting.sightly.render.RenderContext;

public final class search_html extends RenderUnit {

    @Override
    protected final void render(PrintWriter out,
                                Bindings bindings,
                                Bindings arguments,
                                RenderContext renderContext) {
// Main Template Body -----------------------------------------------------------------------------

Object _global_search = null;
Object _dynamic_currentpage = bindings.get("currentpage");
out.write("\n");
_global_search = renderContext.call("use", com.adobe.cq.wcm.core.components.models.Search.class.getName(), obj());
out.write("<section class=\"cmp-search\" role=\"search\" data-cmp-is=\"search\"");
{
    Object var_attrvalue0 = renderContext.getObjectModel().resolveProperty(_global_search, "searchTermMinimumLength");
    {
        Object var_attrcontent1 = renderContext.call("xss", var_attrvalue0, "attribute");
        {
            Object var_shoulddisplayattr3 = ((renderContext.getObjectModel().toBoolean(var_attrcontent1) ? var_attrcontent1 : ("false".equals(var_attrvalue0))));
            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr3)) {
                out.write(" data-cmp-min-length");
                {
                    boolean var_istrueattr2 = (var_attrvalue0.equals(true));
                    if (!var_istrueattr2) {
                        out.write("=\"");
                        out.write(renderContext.getObjectModel().toString(var_attrcontent1));
                        out.write("\"");
                    }
                }
            }
        }
    }
}
{
    Object var_attrvalue4 = renderContext.getObjectModel().resolveProperty(_global_search, "resultsSize");
    {
        Object var_attrcontent5 = renderContext.call("xss", var_attrvalue4, "attribute");
        {
            Object var_shoulddisplayattr7 = ((renderContext.getObjectModel().toBoolean(var_attrcontent5) ? var_attrcontent5 : ("false".equals(var_attrvalue4))));
            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr7)) {
                out.write(" data-cmp-results-size");
                {
                    boolean var_istrueattr6 = (var_attrvalue4.equals(true));
                    if (!var_istrueattr6) {
                        out.write("=\"");
                        out.write(renderContext.getObjectModel().toString(var_attrcontent5));
                        out.write("\"");
                    }
                }
            }
        }
    }
}
out.write(">\n    <form class=\"cmp-search__form\" data-cmp-hook-search=\"form\" method=\"get\"");
{
    Object var_attrvalue8 = renderContext.call("uriManipulation", renderContext.getObjectModel().resolveProperty(_dynamic_currentpage, "path"), obj().with("extension", "json").with("addSelectors", (new Object[] {"searchresults"})).with("suffix", renderContext.getObjectModel().resolveProperty(_global_search, "relativePath")));
    {
        Object var_attrcontent9 = renderContext.call("xss", var_attrvalue8, "uri");
        {
            Object var_shoulddisplayattr11 = ((renderContext.getObjectModel().toBoolean(var_attrcontent9) ? var_attrcontent9 : ("false".equals(var_attrvalue8))));
            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr11)) {
                out.write(" action");
                {
                    boolean var_istrueattr10 = (var_attrvalue8.equals(true));
                    if (!var_istrueattr10) {
                        out.write("=\"");
                        out.write(renderContext.getObjectModel().toString(var_attrcontent9));
                        out.write("\"");
                    }
                }
            }
        }
    }
}
out.write(" autocomplete=\"off\">\n        <div class=\"cmp-search__field\">\n            <i class=\"cmp-search__icon\" data-cmp-hook-search=\"icon\"></i>\n            <span class=\"cmp-search__loading-indicator\" data-cmp-hook-search=\"loadingIndicator\"></span>\n            <input class=\"cmp-search__input\" data-cmp-hook-search=\"input\" type=\"text\" name=\"fulltext\"");
{
    Object var_attrvalue12 = renderContext.call("i18n", "Search", obj());
    {
        Object var_attrcontent13 = renderContext.call("xss", var_attrvalue12, "attribute");
        {
            Object var_shoulddisplayattr15 = ((renderContext.getObjectModel().toBoolean(var_attrcontent13) ? var_attrcontent13 : ("false".equals(var_attrvalue12))));
            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr15)) {
                out.write(" placeholder");
                {
                    boolean var_istrueattr14 = (var_attrvalue12.equals(true));
                    if (!var_istrueattr14) {
                        out.write("=\"");
                        out.write(renderContext.getObjectModel().toString(var_attrcontent13));
                        out.write("\"");
                    }
                }
            }
        }
    }
}
out.write(" role=\"combobox\" aria-autocomplete=\"list\" aria-haspopup=\"true\" aria-invalid=\"false\"/>\n            <button class=\"cmp-search__clear\" data-cmp-hook-search=\"clear\">\n                <i class=\"cmp-search__clear-icon\"></i>\n            </button>\n        </div>\n    </form>\n    <div class=\"cmp-search__results\" data-cmp-hook-search=\"results\" role=\"listbox\" aria-multiselectable=\"false\"></div>\n    ");
{
    Object var_includedresult16 = renderContext.call("include", "itemTemplate.html", obj());
    out.write(renderContext.getObjectModel().toString(var_includedresult16));
}
out.write("\n</section>");


// End Of Main Template Body ----------------------------------------------------------------------
    }



    {
//Sub-Templates Initialization --------------------------------------------------------------------



//End of Sub-Templates Initialization -------------------------------------------------------------
    }

}

