/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
package org.apache.sling.scripting.sightly.apps.core.wcm.components.image.v2.image;

import java.io.PrintWriter;
import java.util.Collection;
import javax.script.Bindings;

import org.apache.sling.scripting.sightly.java.compiler.RenderUnit;
import org.apache.sling.scripting.sightly.render.RenderContext;

public final class image_html extends RenderUnit {

    @Override
    protected final void render(PrintWriter out,
                                Bindings bindings,
                                Bindings arguments,
                                RenderContext renderContext) {
// Main Template Body -----------------------------------------------------------------------------

Object _global_image = null;
Object _global_templates = null;
Object _dynamic_wcmmode = bindings.get("wcmmode");
Object _dynamic_resource = bindings.get("resource");
Object _global_usemap = null;
Collection var_collectionvar49_list_coerced$ = null;
out.write("\n");
_global_image = renderContext.call("use", com.adobe.cq.wcm.core.components.models.Image.class.getName(), obj());
_global_templates = renderContext.call("use", "core/wcm/components/commons/v1/templates.html", obj());
{
    Object var_testvariable0 = renderContext.getObjectModel().resolveProperty(_global_image, "src");
    if (renderContext.getObjectModel().toBoolean(var_testvariable0)) {
        out.write("<div data-cmp-is=\"image\"");
        {
            Object var_attrvalue1 = renderContext.getObjectModel().resolveProperty(_global_image, "lazyEnabled");
            {
                Object var_attrcontent2 = renderContext.call("xss", var_attrvalue1, "attribute");
                {
                    Object var_shoulddisplayattr4 = ((renderContext.getObjectModel().toBoolean(var_attrcontent2) ? var_attrcontent2 : ("false".equals(var_attrvalue1))));
                    if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr4)) {
                        out.write(" data-cmp-lazy");
                        {
                            boolean var_istrueattr3 = (var_attrvalue1.equals(true));
                            if (!var_istrueattr3) {
                                out.write("=\"");
                                out.write(renderContext.getObjectModel().toString(var_attrcontent2));
                                out.write("\"");
                            }
                        }
                    }
                }
            }
        }
        {
            Object var_attrvalue5 = (renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_image, "srcUriTemplate")) ? renderContext.getObjectModel().resolveProperty(_global_image, "srcUriTemplate") : renderContext.getObjectModel().resolveProperty(_global_image, "src"));
            {
                Object var_attrcontent6 = renderContext.call("xss", var_attrvalue5, "attribute");
                {
                    Object var_shoulddisplayattr8 = ((renderContext.getObjectModel().toBoolean(var_attrcontent6) ? var_attrcontent6 : ("false".equals(var_attrvalue5))));
                    if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr8)) {
                        out.write(" data-cmp-src");
                        {
                            boolean var_istrueattr7 = (var_attrvalue5.equals(true));
                            if (!var_istrueattr7) {
                                out.write("=\"");
                                out.write(renderContext.getObjectModel().toString(var_attrcontent6));
                                out.write("\"");
                            }
                        }
                    }
                }
            }
        }
        {
            Object var_attrvalue9 = renderContext.getObjectModel().resolveProperty(_global_image, "widths");
            {
                Object var_attrcontent10 = renderContext.call("xss", var_attrvalue9, "attribute");
                {
                    Object var_shoulddisplayattr12 = ((renderContext.getObjectModel().toBoolean(var_attrcontent10) ? var_attrcontent10 : ("false".equals(var_attrvalue9))));
                    if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr12)) {
                        out.write(" data-cmp-widths");
                        {
                            boolean var_istrueattr11 = (var_attrvalue9.equals(true));
                            if (!var_istrueattr11) {
                                out.write("=\"");
                                out.write(renderContext.getObjectModel().toString(var_attrcontent10));
                                out.write("\"");
                            }
                        }
                    }
                }
            }
        }
        {
            Object var_attrvalue13 = renderContext.getObjectModel().resolveProperty(_global_image, "fileReference");
            {
                Object var_attrcontent14 = renderContext.call("xss", var_attrvalue13, "attribute");
                {
                    Object var_shoulddisplayattr16 = ((renderContext.getObjectModel().toBoolean(var_attrcontent14) ? var_attrcontent14 : ("false".equals(var_attrvalue13))));
                    if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr16)) {
                        out.write(" data-asset");
                        {
                            boolean var_istrueattr15 = (var_attrvalue13.equals(true));
                            if (!var_istrueattr15) {
                                out.write("=\"");
                                out.write(renderContext.getObjectModel().toString(var_attrcontent14));
                                out.write("\"");
                            }
                        }
                    }
                }
            }
        }
        {
            Object var_attrvalue17 = renderContext.getObjectModel().resolveProperty(_global_image, "uuid");
            {
                Object var_attrcontent18 = renderContext.call("xss", var_attrvalue17, "attribute");
                {
                    Object var_shoulddisplayattr20 = ((renderContext.getObjectModel().toBoolean(var_attrcontent18) ? var_attrcontent18 : ("false".equals(var_attrvalue17))));
                    if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr20)) {
                        out.write(" data-asset-id");
                        {
                            boolean var_istrueattr19 = (var_attrvalue17.equals(true));
                            if (!var_istrueattr19) {
                                out.write("=\"");
                                out.write(renderContext.getObjectModel().toString(var_attrcontent18));
                                out.write("\"");
                            }
                        }
                    }
                }
            }
        }
        {
            Object var_attrvalue21 = ((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_image, "title")) ? renderContext.getObjectModel().resolveProperty(_global_image, "title") : renderContext.getObjectModel().resolveProperty(_global_image, "alt")));
            {
                Object var_attrcontent22 = renderContext.call("xss", var_attrvalue21, "attribute");
                {
                    Object var_shoulddisplayattr24 = ((renderContext.getObjectModel().toBoolean(var_attrcontent22) ? var_attrcontent22 : ("false".equals(var_attrvalue21))));
                    if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr24)) {
                        out.write(" data-title");
                        {
                            boolean var_istrueattr23 = (var_attrvalue21.equals(true));
                            if (!var_istrueattr23) {
                                out.write("=\"");
                                out.write(renderContext.getObjectModel().toString(var_attrcontent22));
                                out.write("\"");
                            }
                        }
                    }
                }
            }
        }
        {
            String var_attrcontent25 = ("cmp-image" + renderContext.getObjectModel().toString(renderContext.call("xss", ((!renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "disabled"))) ? " cq-dd-image" : ""), "attribute")));
            {
                Object var_shoulddisplayattr26 = ((renderContext.getObjectModel().toBoolean(var_attrcontent25) ? var_attrcontent25 : ("false".equals(var_attrcontent25))));
                if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr26)) {
                    out.write(" class=\"");
                    out.write(renderContext.getObjectModel().toString(var_attrcontent25));
                    out.write("\"");
                }
            }
        }
        out.write(" itemscope itemtype=\"http://schema.org/ImageObject\">\n    ");
        {
            boolean var_unwrapcondition27 = (!renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_image, "link")));
            if (!var_unwrapcondition27) {
                out.write("<a class=\"cmp-image__link\"");
                {
                    Object var_attrvalue28 = renderContext.getObjectModel().resolveProperty(_global_image, "link");
                    {
                        Object var_attrcontent29 = renderContext.call("xss", var_attrvalue28, "uri");
                        {
                            Object var_shoulddisplayattr31 = ((renderContext.getObjectModel().toBoolean(var_attrcontent29) ? var_attrcontent29 : ("false".equals(var_attrvalue28))));
                            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr31)) {
                                out.write(" href");
                                {
                                    boolean var_istrueattr30 = (var_attrvalue28.equals(true));
                                    if (!var_istrueattr30) {
                                        out.write("=\"");
                                        out.write(renderContext.getObjectModel().toString(var_attrcontent29));
                                        out.write("\"");
                                    }
                                }
                            }
                        }
                    }
                }
                out.write(" data-cmp-hook-image=\"link\">");
            }
            out.write("\n        ");
            {
                boolean var_unwrapcondition32 = (((!renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_image, "lazyEnabled"))) && (org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator.leq(renderContext.getObjectModel().resolveProperty(renderContext.getObjectModel().resolveProperty(_global_image, "widths"), "length"), 1))) && (!renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_image, "areas"))));
                if (!var_unwrapcondition32) {
                    out.write("<noscript data-cmp-hook-image=\"noscript\">");
                }
                out.write("\n            ");
_global_usemap = renderContext.call("format", "{0}{1}", obj().with("format", (new Object[] {"#", renderContext.getObjectModel().resolveProperty(_dynamic_resource, "path")})));
                if (renderContext.getObjectModel().toBoolean(_global_usemap)) {
                }
                out.write("\n            <img");
                {
                    Object var_attrvalue37 = renderContext.getObjectModel().resolveProperty(_global_image, "src");
                    {
                        Object var_attrcontent38 = renderContext.call("xss", var_attrvalue37, "uri");
                        {
                            Object var_shoulddisplayattr40 = ((renderContext.getObjectModel().toBoolean(var_attrcontent38) ? var_attrcontent38 : ("false".equals(var_attrvalue37))));
                            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr40)) {
                                out.write(" src");
                                {
                                    boolean var_istrueattr39 = (var_attrvalue37.equals(true));
                                    if (!var_istrueattr39) {
                                        out.write("=\"");
                                        out.write(renderContext.getObjectModel().toString(var_attrcontent38));
                                        out.write("\"");
                                    }
                                }
                            }
                        }
                    }
                }
                out.write(" class=\"cmp-image__image\" itemprop=\"contentUrl\" data-cmp-hook-image=\"image\"");
                {
                    Object var_attrvalue41 = ((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_image, "alt")) ? renderContext.getObjectModel().resolveProperty(_global_image, "alt") : true));
                    {
                        Object var_attrcontent42 = renderContext.call("xss", var_attrvalue41, "attribute");
                        {
                            Object var_shoulddisplayattr44 = ((renderContext.getObjectModel().toBoolean(var_attrcontent42) ? var_attrcontent42 : ("false".equals(var_attrvalue41))));
                            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr44)) {
                                out.write(" alt");
                                {
                                    boolean var_istrueattr43 = (var_attrvalue41.equals(true));
                                    if (!var_istrueattr43) {
                                        out.write("=\"");
                                        out.write(renderContext.getObjectModel().toString(var_attrcontent42));
                                        out.write("\"");
                                    }
                                }
                            }
                        }
                    }
                }
                {
                    Object var_attrvalue45 = ((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_image, "displayPopupTitle")) ? renderContext.getObjectModel().resolveProperty(_global_image, "title") : renderContext.getObjectModel().resolveProperty(_global_image, "displayPopupTitle")));
                    {
                        Object var_attrcontent46 = renderContext.call("xss", var_attrvalue45, "attribute");
                        {
                            Object var_shoulddisplayattr48 = ((renderContext.getObjectModel().toBoolean(var_attrcontent46) ? var_attrcontent46 : ("false".equals(var_attrvalue45))));
                            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr48)) {
                                out.write(" title");
                                {
                                    boolean var_istrueattr47 = (var_attrvalue45.equals(true));
                                    if (!var_istrueattr47) {
                                        out.write("=\"");
                                        out.write(renderContext.getObjectModel().toString(var_attrcontent46));
                                        out.write("\"");
                                    }
                                }
                            }
                        }
                    }
                }
                {
                    Object var_attrvalue_usemap33 = (renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_image, "areas")) ? _global_usemap : "");
                    {
                        Object var_attrvalueescaped_usemap34 = renderContext.call("xss", var_attrvalue_usemap33, "attribute", "usemap");
                        {
                            Object var_shoulddisplayattr_usemap36 = ((renderContext.getObjectModel().toBoolean(var_attrvalueescaped_usemap34) ? var_attrvalueescaped_usemap34 : ("false".equals(var_attrvalue_usemap33))));
                            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr_usemap36)) {
                                out.write(" usemap");
                                {
                                    boolean var_istruevalue_usemap35 = (var_attrvalue_usemap33.equals(true));
                                    if (!var_istruevalue_usemap35) {
                                        out.write("=\"");
                                        out.write(renderContext.getObjectModel().toString(var_attrvalueescaped_usemap34));
                                        out.write("\"");
                                    }
                                }
                            }
                        }
                    }
                }
                out.write("/>\n            ");
                {
                    Object var_testvariable56 = renderContext.getObjectModel().resolveProperty(_global_image, "areas");
                    if (renderContext.getObjectModel().toBoolean(var_testvariable56)) {
                        {
                            Object var_collectionvar49 = renderContext.getObjectModel().resolveProperty(_global_image, "areas");
                            {
                                long var_size50 = ((var_collectionvar49_list_coerced$ == null ? (var_collectionvar49_list_coerced$ = renderContext.getObjectModel().toCollection(var_collectionvar49)) : var_collectionvar49_list_coerced$).size());
                                {
                                    boolean var_notempty51 = (var_size50 > 0);
                                    if (var_notempty51) {
                                        {
                                            long var_end54 = var_size50;
                                            {
                                                boolean var_validstartstepend55 = (((0 < var_size50) && true) && (var_end54 > 0));
                                                if (var_validstartstepend55) {
                                                    out.write("<map");
                                                    {
                                                        Object var_attrvalue57 = renderContext.getObjectModel().resolveProperty(_dynamic_resource, "path");
                                                        {
                                                            Object var_attrcontent58 = renderContext.call("xss", var_attrvalue57, "attribute");
                                                            {
                                                                Object var_shoulddisplayattr60 = ((renderContext.getObjectModel().toBoolean(var_attrcontent58) ? var_attrcontent58 : ("false".equals(var_attrvalue57))));
                                                                if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr60)) {
                                                                    out.write(" name");
                                                                    {
                                                                        boolean var_istrueattr59 = (var_attrvalue57.equals(true));
                                                                        if (!var_istrueattr59) {
                                                                            out.write("=\"");
                                                                            out.write(renderContext.getObjectModel().toString(var_attrcontent58));
                                                                            out.write("\"");
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    out.write(" data-cmp-hook-image=\"map\">");
                                                    if (var_collectionvar49_list_coerced$ == null) {
                                                        var_collectionvar49_list_coerced$ = renderContext.getObjectModel().toCollection(var_collectionvar49);
                                                    }
                                                    long var_index61 = 0;
                                                    for (Object area : var_collectionvar49_list_coerced$) {
                                                        {
                                                            long var_stepcondition62 = ((var_index61 - 0) % 1);
                                                            {
                                                                boolean var_traversal63 = (((var_index61 >= 0) && (var_index61 <= var_end54)) && (var_stepcondition62 == 0));
                                                                if (var_traversal63) {
                                                                    out.write("\n                <area");
                                                                    {
                                                                        Object var_attrvalue64 = renderContext.getObjectModel().resolveProperty(area, "shape");
                                                                        {
                                                                            Object var_attrcontent65 = renderContext.call("xss", var_attrvalue64, "attribute");
                                                                            {
                                                                                Object var_shoulddisplayattr67 = ((renderContext.getObjectModel().toBoolean(var_attrcontent65) ? var_attrcontent65 : ("false".equals(var_attrvalue64))));
                                                                                if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr67)) {
                                                                                    out.write(" shape");
                                                                                    {
                                                                                        boolean var_istrueattr66 = (var_attrvalue64.equals(true));
                                                                                        if (!var_istrueattr66) {
                                                                                            out.write("=\"");
                                                                                            out.write(renderContext.getObjectModel().toString(var_attrcontent65));
                                                                                            out.write("\"");
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                    {
                                                                        Object var_attrvalue68 = renderContext.getObjectModel().resolveProperty(area, "coordinates");
                                                                        {
                                                                            Object var_attrcontent69 = renderContext.call("xss", var_attrvalue68, "attribute");
                                                                            {
                                                                                Object var_shoulddisplayattr71 = ((renderContext.getObjectModel().toBoolean(var_attrcontent69) ? var_attrcontent69 : ("false".equals(var_attrvalue68))));
                                                                                if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr71)) {
                                                                                    out.write(" coords");
                                                                                    {
                                                                                        boolean var_istrueattr70 = (var_attrvalue68.equals(true));
                                                                                        if (!var_istrueattr70) {
                                                                                            out.write("=\"");
                                                                                            out.write(renderContext.getObjectModel().toString(var_attrcontent69));
                                                                                            out.write("\"");
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                    {
                                                                        Object var_attrvalue72 = renderContext.getObjectModel().resolveProperty(area, "href");
                                                                        {
                                                                            Object var_attrcontent73 = renderContext.call("xss", var_attrvalue72, "uri");
                                                                            {
                                                                                Object var_shoulddisplayattr75 = ((renderContext.getObjectModel().toBoolean(var_attrcontent73) ? var_attrcontent73 : ("false".equals(var_attrvalue72))));
                                                                                if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr75)) {
                                                                                    out.write(" href");
                                                                                    {
                                                                                        boolean var_istrueattr74 = (var_attrvalue72.equals(true));
                                                                                        if (!var_istrueattr74) {
                                                                                            out.write("=\"");
                                                                                            out.write(renderContext.getObjectModel().toString(var_attrcontent73));
                                                                                            out.write("\"");
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                    {
                                                                        Object var_attrvalue76 = renderContext.getObjectModel().resolveProperty(area, "target");
                                                                        {
                                                                            Object var_attrcontent77 = renderContext.call("xss", var_attrvalue76, "attribute");
                                                                            {
                                                                                Object var_shoulddisplayattr79 = ((renderContext.getObjectModel().toBoolean(var_attrcontent77) ? var_attrcontent77 : ("false".equals(var_attrvalue76))));
                                                                                if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr79)) {
                                                                                    out.write(" target");
                                                                                    {
                                                                                        boolean var_istrueattr78 = (var_attrvalue76.equals(true));
                                                                                        if (!var_istrueattr78) {
                                                                                            out.write("=\"");
                                                                                            out.write(renderContext.getObjectModel().toString(var_attrcontent77));
                                                                                            out.write("\"");
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                    {
                                                                        Object var_attrvalue80 = renderContext.getObjectModel().resolveProperty(area, "alt");
                                                                        {
                                                                            Object var_attrcontent81 = renderContext.call("xss", var_attrvalue80, "attribute");
                                                                            {
                                                                                Object var_shoulddisplayattr83 = ((renderContext.getObjectModel().toBoolean(var_attrcontent81) ? var_attrcontent81 : ("false".equals(var_attrvalue80))));
                                                                                if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr83)) {
                                                                                    out.write(" alt");
                                                                                    {
                                                                                        boolean var_istrueattr82 = (var_attrvalue80.equals(true));
                                                                                        if (!var_istrueattr82) {
                                                                                            out.write("=\"");
                                                                                            out.write(renderContext.getObjectModel().toString(var_attrcontent81));
                                                                                            out.write("\"");
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                    out.write(" data-cmp-hook-image=\"area\"");
                                                                    {
                                                                        Object var_attrvalue84 = renderContext.getObjectModel().resolveProperty(area, "relativeCoordinates");
                                                                        {
                                                                            Object var_attrcontent85 = renderContext.call("xss", var_attrvalue84, "attribute");
                                                                            {
                                                                                Object var_shoulddisplayattr87 = ((renderContext.getObjectModel().toBoolean(var_attrcontent85) ? var_attrcontent85 : ("false".equals(var_attrvalue84))));
                                                                                if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr87)) {
                                                                                    out.write(" data-cmp-relcoords");
                                                                                    {
                                                                                        boolean var_istrueattr86 = (var_attrvalue84.equals(true));
                                                                                        if (!var_istrueattr86) {
                                                                                            out.write("=\"");
                                                                                            out.write(renderContext.getObjectModel().toString(var_attrcontent85));
                                                                                            out.write("\"");
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                    out.write("/>\n            ");
                                                                }
                                                            }
                                                        }
                                                        var_index61++;
                                                    }
                                                    out.write("</map>");
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            var_collectionvar49_list_coerced$ = null;
                        }
                    }
                }
                out.write("\n        ");
                if (!var_unwrapcondition32) {
                    out.write("</noscript>");
                }
            }
            out.write("\n    ");
            if (!var_unwrapcondition27) {
                out.write("</a>");
            }
        }
        out.write("\n    ");
        {
            Object var_testvariable88 = (((!renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_image, "displayPopupTitle"))) ? renderContext.getObjectModel().resolveProperty(_global_image, "title") : (!renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_image, "displayPopupTitle")))));
            if (renderContext.getObjectModel().toBoolean(var_testvariable88)) {
                out.write("<span class=\"cmp-image__title\" itemprop=\"caption\">");
                {
                    Object var_89 = renderContext.call("xss", renderContext.getObjectModel().resolveProperty(_global_image, "title"), "text");
                    out.write(renderContext.getObjectModel().toString(var_89));
                }
                out.write("</span>");
            }
        }
        out.write("\n    ");
        {
            Object var_testvariable90 = ((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_image, "displayPopupTitle")) ? renderContext.getObjectModel().resolveProperty(_global_image, "title") : renderContext.getObjectModel().resolveProperty(_global_image, "displayPopupTitle")));
            if (renderContext.getObjectModel().toBoolean(var_testvariable90)) {
                out.write("<meta itemprop=\"caption\"");
                {
                    Object var_attrvalue91 = renderContext.getObjectModel().resolveProperty(_global_image, "title");
                    {
                        Object var_attrcontent92 = renderContext.call("xss", var_attrvalue91, "attribute");
                        {
                            Object var_shoulddisplayattr94 = ((renderContext.getObjectModel().toBoolean(var_attrcontent92) ? var_attrcontent92 : ("false".equals(var_attrvalue91))));
                            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr94)) {
                                out.write(" content");
                                {
                                    boolean var_istrueattr93 = (var_attrvalue91.equals(true));
                                    if (!var_istrueattr93) {
                                        out.write("=\"");
                                        out.write(renderContext.getObjectModel().toString(var_attrcontent92));
                                        out.write("\"");
                                    }
                                }
                            }
                        }
                    }
                }
                out.write("/>");
            }
        }
        out.write("\n</div>");
    }
}
out.write("\n");
{
    Object var_templatevar95 = renderContext.getObjectModel().resolveProperty(_global_templates, "placeholder");
    {
        boolean var_templateoptions96_field$_isempty = (!renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_image, "src")));
        {
            String var_templateoptions96_field$_classappend = "cmp-image cq-dd-image";
            {
                java.util.Map var_templateoptions96 = obj().with("isEmpty", var_templateoptions96_field$_isempty).with("classAppend", var_templateoptions96_field$_classappend);
                callUnit(out, renderContext, var_templatevar95, var_templateoptions96);
            }
        }
    }
}


// End Of Main Template Body ----------------------------------------------------------------------
    }



    {
//Sub-Templates Initialization --------------------------------------------------------------------



//End of Sub-Templates Initialization -------------------------------------------------------------
    }

}

