/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
package org.apache.sling.scripting.sightly.apps.core.wcm.components.image.v1.image;

import java.io.PrintWriter;
import java.util.Collection;
import javax.script.Bindings;

import org.apache.sling.scripting.sightly.java.compiler.RenderUnit;
import org.apache.sling.scripting.sightly.render.RenderContext;

public final class image_html extends RenderUnit {

    @Override
    protected final void render(PrintWriter out,
                                Bindings bindings,
                                Bindings arguments,
                                RenderContext renderContext) {
// Main Template Body -----------------------------------------------------------------------------

Object _global_image = null;
Object _global_templates = null;
Object _dynamic_wcmmode = bindings.get("wcmmode");
out.write("\n");
_global_image = renderContext.call("use", com.adobe.cq.wcm.core.components.models.Image.class.getName(), obj());
_global_templates = renderContext.call("use", "core/wcm/components/commons/v1/templates.html", obj());
{
    Object var_testvariable0 = renderContext.getObjectModel().resolveProperty(_global_image, "src");
    if (renderContext.getObjectModel().toBoolean(var_testvariable0)) {
        {
            Object var_unwrapcondition1 = renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "disabled");
            if (!renderContext.getObjectModel().toBoolean(var_unwrapcondition1)) {
                out.write("<div class=\"cq-dd-image\">");
            }
            out.write("\n    ");
            {
                boolean var_unwrapcondition2 = (!renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_image, "link")));
                if (!var_unwrapcondition2) {
                    out.write("<a class=\"cmp-image--link\"");
                    {
                        Object var_attrvalue3 = renderContext.getObjectModel().resolveProperty(_global_image, "link");
                        {
                            Object var_attrcontent4 = renderContext.call("xss", var_attrvalue3, "uri");
                            {
                                Object var_shoulddisplayattr6 = ((renderContext.getObjectModel().toBoolean(var_attrcontent4) ? var_attrcontent4 : ("false".equals(var_attrvalue3))));
                                if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr6)) {
                                    out.write(" href");
                                    {
                                        boolean var_istrueattr5 = (var_attrvalue3.equals(true));
                                        if (!var_istrueattr5) {
                                            out.write("=\"");
                                            out.write(renderContext.getObjectModel().toString(var_attrcontent4));
                                            out.write("\"");
                                        }
                                    }
                                }
                            }
                        }
                    }
                    {
                        Object var_attrvalue7 = ((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_image, "title")) ? renderContext.getObjectModel().resolveProperty(_global_image, "title") : renderContext.getObjectModel().resolveProperty(_global_image, "alt")));
                        {
                            Object var_attrcontent8 = renderContext.call("xss", var_attrvalue7, "attribute");
                            {
                                Object var_shoulddisplayattr10 = ((renderContext.getObjectModel().toBoolean(var_attrcontent8) ? var_attrcontent8 : ("false".equals(var_attrvalue7))));
                                if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr10)) {
                                    out.write(" data-title");
                                    {
                                        boolean var_istrueattr9 = (var_attrvalue7.equals(true));
                                        if (!var_istrueattr9) {
                                            out.write("=\"");
                                            out.write(renderContext.getObjectModel().toString(var_attrcontent8));
                                            out.write("\"");
                                        }
                                    }
                                }
                            }
                        }
                    }
                    {
                        Object var_attrvalue11 = renderContext.getObjectModel().resolveProperty(_global_image, "fileReference");
                        {
                            Object var_attrcontent12 = renderContext.call("xss", var_attrvalue11, "attribute");
                            {
                                Object var_shoulddisplayattr14 = ((renderContext.getObjectModel().toBoolean(var_attrcontent12) ? var_attrcontent12 : ("false".equals(var_attrvalue11))));
                                if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr14)) {
                                    out.write(" data-asset");
                                    {
                                        boolean var_istrueattr13 = (var_attrvalue11.equals(true));
                                        if (!var_istrueattr13) {
                                            out.write("=\"");
                                            out.write(renderContext.getObjectModel().toString(var_attrcontent12));
                                            out.write("\"");
                                        }
                                    }
                                }
                            }
                        }
                    }
                    out.write(">");
                }
                out.write("\n        ");
                {
                    boolean var_unwrapcondition15 = (!renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_image, "json")));
                    if (!var_unwrapcondition15) {
                        out.write("<noscript");
                        {
                            Object var_attrvalue16 = renderContext.getObjectModel().resolveProperty(_global_image, "json");
                            {
                                Object var_attrcontent17 = renderContext.call("xss", var_attrvalue16, "attribute");
                                {
                                    Object var_shoulddisplayattr19 = ((renderContext.getObjectModel().toBoolean(var_attrcontent17) ? var_attrcontent17 : ("false".equals(var_attrvalue16))));
                                    if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr19)) {
                                        out.write(" data-cmp-image");
                                        {
                                            boolean var_istrueattr18 = (var_attrvalue16.equals(true));
                                            if (!var_istrueattr18) {
                                                out.write("=\"");
                                                out.write(renderContext.getObjectModel().toString(var_attrcontent17));
                                                out.write("\"");
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        out.write(">");
                    }
                    out.write("\n            <img");
                    {
                        Object var_attrvalue20 = renderContext.getObjectModel().resolveProperty(_global_image, "src");
                        {
                            Object var_attrcontent21 = renderContext.call("xss", var_attrvalue20, "uri");
                            {
                                Object var_shoulddisplayattr23 = ((renderContext.getObjectModel().toBoolean(var_attrcontent21) ? var_attrcontent21 : ("false".equals(var_attrvalue20))));
                                if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr23)) {
                                    out.write(" src");
                                    {
                                        boolean var_istrueattr22 = (var_attrvalue20.equals(true));
                                        if (!var_istrueattr22) {
                                            out.write("=\"");
                                            out.write(renderContext.getObjectModel().toString(var_attrcontent21));
                                            out.write("\"");
                                        }
                                    }
                                }
                            }
                        }
                    }
                    {
                        Object var_attrvalue24 = ((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_image, "alt")) ? renderContext.getObjectModel().resolveProperty(_global_image, "alt") : true));
                        {
                            Object var_attrcontent25 = renderContext.call("xss", var_attrvalue24, "attribute");
                            {
                                Object var_shoulddisplayattr27 = ((renderContext.getObjectModel().toBoolean(var_attrcontent25) ? var_attrcontent25 : ("false".equals(var_attrvalue24))));
                                if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr27)) {
                                    out.write(" alt");
                                    {
                                        boolean var_istrueattr26 = (var_attrvalue24.equals(true));
                                        if (!var_istrueattr26) {
                                            out.write("=\"");
                                            out.write(renderContext.getObjectModel().toString(var_attrcontent25));
                                            out.write("\"");
                                        }
                                    }
                                }
                            }
                        }
                    }
                    {
                        Object var_attrvalue28 = ((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_image, "displayPopupTitle")) ? renderContext.getObjectModel().resolveProperty(_global_image, "title") : renderContext.getObjectModel().resolveProperty(_global_image, "displayPopupTitle")));
                        {
                            Object var_attrcontent29 = renderContext.call("xss", var_attrvalue28, "attribute");
                            {
                                Object var_shoulddisplayattr31 = ((renderContext.getObjectModel().toBoolean(var_attrcontent29) ? var_attrcontent29 : ("false".equals(var_attrvalue28))));
                                if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr31)) {
                                    out.write(" title");
                                    {
                                        boolean var_istrueattr30 = (var_attrvalue28.equals(true));
                                        if (!var_istrueattr30) {
                                            out.write("=\"");
                                            out.write(renderContext.getObjectModel().toString(var_attrcontent29));
                                            out.write("\"");
                                        }
                                    }
                                }
                            }
                        }
                    }
                    out.write("/>\n        ");
                    if (!var_unwrapcondition15) {
                        out.write("</noscript>");
                    }
                }
                out.write("\n    ");
                if (!var_unwrapcondition2) {
                    out.write("</a>");
                }
            }
            out.write("\n    ");
            {
                Object var_testvariable32 = (((!renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_image, "displayPopupTitle"))) ? renderContext.getObjectModel().resolveProperty(_global_image, "title") : (!renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_image, "displayPopupTitle")))));
                if (renderContext.getObjectModel().toBoolean(var_testvariable32)) {
                    out.write("<span class=\"cmp-image--title\">");
                    {
                        Object var_33 = renderContext.call("xss", renderContext.getObjectModel().resolveProperty(_global_image, "title"), "text");
                        out.write(renderContext.getObjectModel().toString(var_33));
                    }
                    out.write("</span>");
                }
            }
            out.write("\n");
            if (!renderContext.getObjectModel().toBoolean(var_unwrapcondition1)) {
                out.write("</div>");
            }
        }
    }
}
out.write("\n");
{
    Object var_templatevar34 = renderContext.getObjectModel().resolveProperty(_global_templates, "placeholder");
    {
        boolean var_templateoptions35_field$_isempty = (!renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_image, "src")));
        {
            String var_templateoptions35_field$_classappend = "cq-dd-image";
            {
                java.util.Map var_templateoptions35 = obj().with("isEmpty", var_templateoptions35_field$_isempty).with("classAppend", var_templateoptions35_field$_classappend);
                callUnit(out, renderContext, var_templatevar34, var_templateoptions35);
            }
        }
    }
}
out.write("\n");


// End Of Main Template Body ----------------------------------------------------------------------
    }



    {
//Sub-Templates Initialization --------------------------------------------------------------------



//End of Sub-Templates Initialization -------------------------------------------------------------
    }

}

