/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
package org.apache.sling.scripting.sightly.apps.core.wcm.components.form.container.v1.container;

import java.io.PrintWriter;
import java.util.Collection;
import javax.script.Bindings;

import org.apache.sling.scripting.sightly.java.compiler.RenderUnit;
import org.apache.sling.scripting.sightly.render.RenderContext;

public final class container_html extends RenderUnit {

    @Override
    protected final void render(PrintWriter out,
                                Bindings bindings,
                                Bindings arguments,
                                RenderContext renderContext) {
// Main Template Body -----------------------------------------------------------------------------

Object _global_container = null;
Object _global_grid = null;
Object _dynamic_resource = bindings.get("resource");
Collection var_collectionvar33_list_coerced$ = null;
Object _dynamic_wcmmode = bindings.get("wcmmode");
out.write("\n");
_global_container = renderContext.call("use", com.adobe.cq.wcm.core.components.models.form.Container.class.getName(), obj());
_global_grid = renderContext.call("use", com.day.cq.wcm.foundation.model.responsivegrid.ResponsiveGrid.class.getName(), obj());
out.write("<form");
{
    Object var_attrvalue0 = renderContext.getObjectModel().resolveProperty(_global_container, "method");
    {
        Object var_attrcontent1 = renderContext.call("xss", var_attrvalue0, "attribute");
        {
            Object var_shoulddisplayattr3 = ((renderContext.getObjectModel().toBoolean(var_attrcontent1) ? var_attrcontent1 : ("false".equals(var_attrvalue0))));
            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr3)) {
                out.write(" method");
                {
                    boolean var_istrueattr2 = (var_attrvalue0.equals(true));
                    if (!var_istrueattr2) {
                        out.write("=\"");
                        out.write(renderContext.getObjectModel().toString(var_attrcontent1));
                        out.write("\"");
                    }
                }
            }
        }
    }
}
{
    Object var_attrvalue4 = renderContext.getObjectModel().resolveProperty(_global_container, "action");
    {
        Object var_attrcontent5 = renderContext.call("xss", var_attrvalue4, "uri");
        {
            Object var_shoulddisplayattr7 = ((renderContext.getObjectModel().toBoolean(var_attrcontent5) ? var_attrcontent5 : ("false".equals(var_attrvalue4))));
            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr7)) {
                out.write(" action");
                {
                    boolean var_istrueattr6 = (var_attrvalue4.equals(true));
                    if (!var_istrueattr6) {
                        out.write("=\"");
                        out.write(renderContext.getObjectModel().toString(var_attrcontent5));
                        out.write("\"");
                    }
                }
            }
        }
    }
}
{
    Object var_attrvalue8 = renderContext.getObjectModel().resolveProperty(_global_container, "id");
    {
        Object var_attrcontent9 = renderContext.call("xss", var_attrvalue8, "attribute");
        {
            Object var_shoulddisplayattr11 = ((renderContext.getObjectModel().toBoolean(var_attrcontent9) ? var_attrcontent9 : ("false".equals(var_attrvalue8))));
            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr11)) {
                out.write(" id");
                {
                    boolean var_istrueattr10 = (var_attrvalue8.equals(true));
                    if (!var_istrueattr10) {
                        out.write("=\"");
                        out.write(renderContext.getObjectModel().toString(var_attrcontent9));
                        out.write("\"");
                    }
                }
            }
        }
    }
}
{
    Object var_attrvalue12 = renderContext.getObjectModel().resolveProperty(_global_container, "name");
    {
        Object var_attrcontent13 = renderContext.call("xss", var_attrvalue12, "attribute");
        {
            Object var_shoulddisplayattr15 = ((renderContext.getObjectModel().toBoolean(var_attrcontent13) ? var_attrcontent13 : ("false".equals(var_attrvalue12))));
            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr15)) {
                out.write(" name");
                {
                    boolean var_istrueattr14 = (var_attrvalue12.equals(true));
                    if (!var_istrueattr14) {
                        out.write("=\"");
                        out.write(renderContext.getObjectModel().toString(var_attrcontent13));
                        out.write("\"");
                    }
                }
            }
        }
    }
}
{
    Object var_attrvalue16 = renderContext.getObjectModel().resolveProperty(_global_container, "enctype");
    {
        Object var_attrcontent17 = renderContext.call("xss", var_attrvalue16, "attribute");
        {
            Object var_shoulddisplayattr19 = ((renderContext.getObjectModel().toBoolean(var_attrcontent17) ? var_attrcontent17 : ("false".equals(var_attrvalue16))));
            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr19)) {
                out.write(" enctype");
                {
                    boolean var_istrueattr18 = (var_attrvalue16.equals(true));
                    if (!var_istrueattr18) {
                        out.write("=\"");
                        out.write(renderContext.getObjectModel().toString(var_attrcontent17));
                        out.write("\"");
                    }
                }
            }
        }
    }
}
{
    Object var_attrvalue20 = renderContext.getObjectModel().resolveProperty(_global_grid, "cssClass");
    {
        Object var_attrcontent21 = renderContext.call("xss", var_attrvalue20, "attribute");
        {
            Object var_shoulddisplayattr23 = ((renderContext.getObjectModel().toBoolean(var_attrcontent21) ? var_attrcontent21 : ("false".equals(var_attrvalue20))));
            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr23)) {
                out.write(" class");
                {
                    boolean var_istrueattr22 = (var_attrvalue20.equals(true));
                    if (!var_istrueattr22) {
                        out.write("=\"");
                        out.write(renderContext.getObjectModel().toString(var_attrcontent21));
                        out.write("\"");
                    }
                }
            }
        }
    }
}
out.write(">\n    <input type=\"hidden\" name=\":formstart\"");
{
    Object var_attrvalue24 = renderContext.getObjectModel().resolveProperty(_dynamic_resource, "path");
    {
        Object var_attrcontent25 = renderContext.call("xss", var_attrvalue24, "attribute");
        {
            Object var_shoulddisplayattr27 = ((renderContext.getObjectModel().toBoolean(var_attrcontent25) ? var_attrcontent25 : ("false".equals(var_attrvalue24))));
            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr27)) {
                out.write(" value");
                {
                    boolean var_istrueattr26 = (var_attrvalue24.equals(true));
                    if (!var_istrueattr26) {
                        out.write("=\"");
                        out.write(renderContext.getObjectModel().toString(var_attrcontent25));
                        out.write("\"");
                    }
                }
            }
        }
    }
}
out.write("/>\n    <input type=\"hidden\" name=\"_charset_\" value=\"utf-8\"/>\n    ");
{
    Object var_testvariable28 = renderContext.getObjectModel().resolveProperty(_global_container, "redirect");
    if (renderContext.getObjectModel().toBoolean(var_testvariable28)) {
        out.write("<input type=\"hidden\" name=\":redirect\"");
        {
            Object var_attrvalue29 = renderContext.call("uriManipulation", renderContext.getObjectModel().resolveProperty(_global_container, "redirect"), obj().with("extension", "html"));
            {
                Object var_attrcontent30 = renderContext.call("xss", var_attrvalue29, "attribute");
                {
                    Object var_shoulddisplayattr32 = ((renderContext.getObjectModel().toBoolean(var_attrcontent30) ? var_attrcontent30 : ("false".equals(var_attrvalue29))));
                    if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr32)) {
                        out.write(" value");
                        {
                            boolean var_istrueattr31 = (var_attrvalue29.equals(true));
                            if (!var_istrueattr31) {
                                out.write("=\"");
                                out.write(renderContext.getObjectModel().toString(var_attrcontent30));
                                out.write("\"");
                            }
                        }
                    }
                }
            }
        }
        out.write("/>");
    }
}
out.write("\n    ");
{
    Object var_collectionvar33 = renderContext.getObjectModel().resolveProperty(_global_grid, "paragraphs");
    {
        long var_size34 = ((var_collectionvar33_list_coerced$ == null ? (var_collectionvar33_list_coerced$ = renderContext.getObjectModel().toCollection(var_collectionvar33)) : var_collectionvar33_list_coerced$).size());
        {
            boolean var_notempty35 = (var_size34 > 0);
            if (var_notempty35) {
                {
                    long var_end38 = var_size34;
                    {
                        boolean var_validstartstepend39 = (((0 < var_size34) && true) && (var_end38 > 0));
                        if (var_validstartstepend39) {
                            if (var_collectionvar33_list_coerced$ == null) {
                                var_collectionvar33_list_coerced$ = renderContext.getObjectModel().toCollection(var_collectionvar33);
                            }
                            long var_index40 = 0;
                            for (Object paragraph : var_collectionvar33_list_coerced$) {
                                {
                                    long var_stepcondition41 = ((var_index40 - 0) % 1);
                                    {
                                        boolean var_traversal42 = (((var_index40 >= 0) && (var_index40 <= var_end38)) && (var_stepcondition41 == 0));
                                        if (var_traversal42) {
                                            {
                                                Object var_resourcecontent43 = renderContext.call("includeResource", renderContext.getObjectModel().resolveProperty(paragraph, "path"), obj().with("cssClassName", renderContext.getObjectModel().resolveProperty(paragraph, "cssClass")).with("decorationTagName", "div").with("resourceType", renderContext.getObjectModel().resolveProperty(paragraph, "resourceType")));
                                                out.write(renderContext.getObjectModel().toString(var_resourcecontent43));
                                            }
                                        }
                                    }
                                }
                                var_index40++;
                            }
                        }
                    }
                }
            }
        }
    }
    var_collectionvar33_list_coerced$ = null;
}
out.write("\n    ");
{
    Object var_testvariable44 = ((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "edit")) ? renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "edit") : renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "preview")));
    if (renderContext.getObjectModel().toBoolean(var_testvariable44)) {
        {
            Object var_resourcecontent45 = renderContext.call("includeResource", renderContext.getObjectModel().resolveProperty(_dynamic_resource, "path"), obj().with("cssClassName", "new section aem-Grid-newComponent").with("decorationTagName", "div").with("appendPath", "/*").with("resourceType", renderContext.getObjectModel().resolveProperty(_global_container, "resourceTypeForDropArea")));
            out.write(renderContext.getObjectModel().toString(var_resourcecontent45));
        }
    }
}
out.write("\n</form>");


// End Of Main Template Body ----------------------------------------------------------------------
    }



    {
//Sub-Templates Initialization --------------------------------------------------------------------



//End of Sub-Templates Initialization -------------------------------------------------------------
    }

}

