/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
package org.apache.sling.scripting.sightly.apps.core.wcm.components.download.v1.download;

import java.io.PrintWriter;
import java.util.Collection;
import javax.script.Bindings;

import org.apache.sling.scripting.sightly.java.compiler.RenderUnit;
import org.apache.sling.scripting.sightly.render.RenderContext;

public final class download_html extends RenderUnit {

    @Override
    protected final void render(PrintWriter out,
                                Bindings bindings,
                                Bindings arguments,
                                RenderContext renderContext) {
// Main Template Body -----------------------------------------------------------------------------

Object _global_download = null;
Object _global_templates = null;
Object _global_hascontent = null;
Object _dynamic_wcmmode = bindings.get("wcmmode");
Object _global_title = null;
Object _global_description = null;
out.write("\n");
_global_download = renderContext.call("use", com.adobe.cq.wcm.core.components.models.Download.class.getName(), obj());
_global_templates = renderContext.call("use", "core/wcm/components/commons/v1/templates.html", obj());
_global_hascontent = renderContext.getObjectModel().resolveProperty(_global_download, "filename");
if (renderContext.getObjectModel().toBoolean(_global_hascontent)) {
    out.write("<div");
    {
        String var_attrcontent0 = ("cmp-download" + renderContext.getObjectModel().toString(renderContext.call("xss", ((!renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "disabled"))) ? " cq-dd-file" : ""), "attribute")));
        {
            Object var_shoulddisplayattr1 = ((renderContext.getObjectModel().toBoolean(var_attrcontent0) ? var_attrcontent0 : ("false".equals(var_attrcontent0))));
            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr1)) {
                out.write(" class=\"");
                out.write(renderContext.getObjectModel().toString(var_attrcontent0));
                out.write("\"");
            }
        }
    }
    out.write(">\n    ");
_global_title = renderContext.getObjectModel().resolveProperty(_global_download, "title");
    if (renderContext.getObjectModel().toBoolean(_global_title)) {
        {
            Object var_tagvar2 = renderContext.call("xss", renderContext.getObjectModel().resolveProperty(_global_download, "titleType"), "elementName");
            if (renderContext.getObjectModel().toBoolean(var_tagvar2)) {
                out.write("<");
                out.write(renderContext.getObjectModel().toString(var_tagvar2));
            }
            if (!renderContext.getObjectModel().toBoolean(var_tagvar2)) {
                out.write("<h3");
            }
            out.write(" class=\"cmp-download__title\">\n        ");
            {
                boolean var_unwrapcondition3 = (!renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_download, "url")));
                if (!var_unwrapcondition3) {
                    out.write("<a class=\"cmp-download__title-link\"");
                    {
                        Object var_attrvalue4 = renderContext.getObjectModel().resolveProperty(_global_download, "url");
                        {
                            Object var_attrcontent5 = renderContext.call("xss", var_attrvalue4, "uri");
                            {
                                Object var_shoulddisplayattr7 = ((renderContext.getObjectModel().toBoolean(var_attrcontent5) ? var_attrcontent5 : ("false".equals(var_attrvalue4))));
                                if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr7)) {
                                    out.write(" href");
                                    {
                                        boolean var_istrueattr6 = (var_attrvalue4.equals(true));
                                        if (!var_istrueattr6) {
                                            out.write("=\"");
                                            out.write(renderContext.getObjectModel().toString(var_attrcontent5));
                                            out.write("\"");
                                        }
                                    }
                                }
                            }
                        }
                    }
                    out.write(">");
                }
                {
                    Object var_8 = renderContext.call("xss", _global_title, "text");
                    out.write(renderContext.getObjectModel().toString(var_8));
                }
                if (!var_unwrapcondition3) {
                    out.write("</a>");
                }
            }
            out.write("\n    ");
            if (renderContext.getObjectModel().toBoolean(var_tagvar2)) {
                out.write("</");
                out.write(renderContext.getObjectModel().toString(var_tagvar2));
                out.write(">");
            }
            if (!renderContext.getObjectModel().toBoolean(var_tagvar2)) {
                out.write("</h3>");
            }
        }
    }
    out.write("\n    ");
_global_description = renderContext.getObjectModel().resolveProperty(_global_download, "description");
    if (renderContext.getObjectModel().toBoolean(_global_description)) {
        out.write("<div class=\"cmp-download__description\">");
        {
            Object var_9 = renderContext.call("xss", _global_description, "html");
            out.write(renderContext.getObjectModel().toString(var_9));
        }
        out.write("</div>");
    }
    out.write("\n    ");
    {
        Object var_testvariable10 = ((renderContext.getObjectModel().toBoolean(((renderContext.getObjectModel().toBoolean(((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_download, "displayFilename")) ? renderContext.getObjectModel().resolveProperty(_global_download, "filename") : renderContext.getObjectModel().resolveProperty(_global_download, "displayFilename")))) ? ((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_download, "displayFilename")) ? renderContext.getObjectModel().resolveProperty(_global_download, "filename") : renderContext.getObjectModel().resolveProperty(_global_download, "displayFilename"))) : ((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_download, "displaySize")) ? renderContext.getObjectModel().resolveProperty(_global_download, "size") : renderContext.getObjectModel().resolveProperty(_global_download, "displaySize")))))) ? ((renderContext.getObjectModel().toBoolean(((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_download, "displayFilename")) ? renderContext.getObjectModel().resolveProperty(_global_download, "filename") : renderContext.getObjectModel().resolveProperty(_global_download, "displayFilename")))) ? ((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_download, "displayFilename")) ? renderContext.getObjectModel().resolveProperty(_global_download, "filename") : renderContext.getObjectModel().resolveProperty(_global_download, "displayFilename"))) : ((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_download, "displaySize")) ? renderContext.getObjectModel().resolveProperty(_global_download, "size") : renderContext.getObjectModel().resolveProperty(_global_download, "displaySize"))))) : ((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_download, "displayFormat")) ? renderContext.getObjectModel().resolveProperty(_global_download, "format") : renderContext.getObjectModel().resolveProperty(_global_download, "displayFormat")))));
        if (renderContext.getObjectModel().toBoolean(var_testvariable10)) {
            out.write("<dl class=\"cmp-download__properties\">\n        ");
            {
                Object var_testvariable11 = ((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_download, "displayFilename")) ? renderContext.getObjectModel().resolveProperty(_global_download, "filename") : renderContext.getObjectModel().resolveProperty(_global_download, "displayFilename")));
                if (renderContext.getObjectModel().toBoolean(var_testvariable11)) {
                    out.write("<div class=\"cmp-download__property cmp-download__property--filename\">\n            <dt class=\"cmp-download__property-label\">");
                    {
                        Object var_12 = renderContext.call("xss", renderContext.call("i18n", "Filename", obj()), "text");
                        out.write(renderContext.getObjectModel().toString(var_12));
                    }
                    out.write("</dt>\n            <dd class=\"cmp-download__property-content\">");
                    {
                        Object var_13 = renderContext.call("xss", renderContext.getObjectModel().resolveProperty(_global_download, "filename"), "text");
                        out.write(renderContext.getObjectModel().toString(var_13));
                    }
                    out.write("</dd>\n        </div>");
                }
            }
            out.write("\n        ");
            {
                Object var_testvariable14 = ((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_download, "displaySize")) ? renderContext.getObjectModel().resolveProperty(_global_download, "size") : renderContext.getObjectModel().resolveProperty(_global_download, "displaySize")));
                if (renderContext.getObjectModel().toBoolean(var_testvariable14)) {
                    out.write("<div class=\"cmp-download__property cmp-download__property--size\">\n            <dt class=\"cmp-download__property-label\">");
                    {
                        Object var_15 = renderContext.call("xss", renderContext.call("i18n", "Size", obj()), "text");
                        out.write(renderContext.getObjectModel().toString(var_15));
                    }
                    out.write("</dt>\n            <dd class=\"cmp-download__property-content\">");
                    {
                        Object var_16 = renderContext.call("xss", renderContext.getObjectModel().resolveProperty(_global_download, "size"), "text");
                        out.write(renderContext.getObjectModel().toString(var_16));
                    }
                    out.write("</dd>\n        </div>");
                }
            }
            out.write("\n        ");
            {
                Object var_testvariable17 = ((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_download, "displayFormat")) ? renderContext.getObjectModel().resolveProperty(_global_download, "format") : renderContext.getObjectModel().resolveProperty(_global_download, "displayFormat")));
                if (renderContext.getObjectModel().toBoolean(var_testvariable17)) {
                    out.write("<div class=\"cmp-download__property cmp-download__property--format\">\n            <dt class=\"cmp-download__property-label\">");
                    {
                        Object var_18 = renderContext.call("xss", renderContext.call("i18n", "Format", obj()), "text");
                        out.write(renderContext.getObjectModel().toString(var_18));
                    }
                    out.write("</dt>\n            <dd class=\"cmp-download__property-content\">");
                    {
                        Object var_19 = renderContext.call("xss", renderContext.getObjectModel().resolveProperty(_global_download, "format"), "text");
                        out.write(renderContext.getObjectModel().toString(var_19));
                    }
                    out.write("</dd>\n        </div>");
                }
            }
            out.write("\n    </dl>");
        }
    }
    out.write("\n    ");
    {
        Object var_testvariable20 = ((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_download, "url")) ? renderContext.getObjectModel().resolveProperty(_global_download, "actionText") : renderContext.getObjectModel().resolveProperty(_global_download, "url")));
        if (renderContext.getObjectModel().toBoolean(var_testvariable20)) {
            out.write("<a class=\"cmp-download__action\"");
            {
                Object var_attrvalue21 = renderContext.getObjectModel().resolveProperty(_global_download, "url");
                {
                    Object var_attrcontent22 = renderContext.call("xss", var_attrvalue21, "uri");
                    {
                        Object var_shoulddisplayattr24 = ((renderContext.getObjectModel().toBoolean(var_attrcontent22) ? var_attrcontent22 : ("false".equals(var_attrvalue21))));
                        if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr24)) {
                            out.write(" href");
                            {
                                boolean var_istrueattr23 = (var_attrvalue21.equals(true));
                                if (!var_istrueattr23) {
                                    out.write("=\"");
                                    out.write(renderContext.getObjectModel().toString(var_attrcontent22));
                                    out.write("\"");
                                }
                            }
                        }
                    }
                }
            }
            out.write(">\n        <span class=\"cmp-download__action-text\">");
            {
                Object var_25 = renderContext.call("xss", renderContext.getObjectModel().resolveProperty(_global_download, "actionText"), "text");
                out.write(renderContext.getObjectModel().toString(var_25));
            }
            out.write("</span>\n    </a>");
        }
    }
    out.write("\n</div>");
}
out.write("\n");
{
    Object var_templatevar26 = renderContext.getObjectModel().resolveProperty(_global_templates, "placeholder");
    {
        boolean var_templateoptions27_field$_isempty = (!renderContext.getObjectModel().toBoolean(_global_hascontent));
        {
            String var_templateoptions27_field$_classappend = "cmp-download cq-dd-file";
            {
                java.util.Map var_templateoptions27 = obj().with("isEmpty", var_templateoptions27_field$_isempty).with("classAppend", var_templateoptions27_field$_classappend);
                callUnit(out, renderContext, var_templatevar26, var_templateoptions27);
            }
        }
    }
}


// End Of Main Template Body ----------------------------------------------------------------------
    }



    {
//Sub-Templates Initialization --------------------------------------------------------------------



//End of Sub-Templates Initialization -------------------------------------------------------------
    }

}

