/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
package org.apache.sling.scripting.sightly.apps.core.wcm.components.contentfragment.v1.contentfragment;

import java.io.PrintWriter;
import java.util.Collection;
import javax.script.Bindings;

import org.apache.sling.scripting.sightly.java.compiler.RenderUnit;
import org.apache.sling.scripting.sightly.render.RenderContext;

public final class templates_html extends RenderUnit {

    @Override
    protected final void render(PrintWriter out,
                                Bindings bindings,
                                Bindings arguments,
                                RenderContext renderContext) {
// Main Template Body -----------------------------------------------------------------------------

Object _dynamic_contentfragment = getProperty("contentfragment");
Object _dynamic_paragraphs = getProperty("paragraphs");
Object _dynamic_elements = getProperty("elements");
out.write("\n\n");
out.write("\n\n<!-- This template should not be used/called by the content fragment list component -->\n");
out.write("\n\n");
out.write("\n");


// End Of Main Template Body ----------------------------------------------------------------------
    }



    {
//Sub-Templates Initialization --------------------------------------------------------------------

/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
addSubTemplate("contentFragment", new RenderUnit() {

    @Override
    protected final void render(PrintWriter out,
                                Bindings bindings,
                                Bindings arguments,
                                RenderContext renderContext) {
// Main Sub-Template Body -------------------------------------------------------------------------

Object _dynamic_fragment = arguments.get("fragment");
Object _dynamic_wcmmode = arguments.get("wcmmode");
Object _dynamic_fragmentpath = arguments.get("fragmentpath");
Object _dynamic_properties = bindings.get("properties");
Object _global_isparagraphmode = null;
Object _dynamic_paragraphs = bindings.get("paragraphs");
Object _dynamic_elements = bindings.get("elements");
out.write("\n    <article");
{
    String var_attrcontent4 = ("cmp-contentfragment cmp-contentfragment--" + renderContext.getObjectModel().toString(renderContext.call("xss", renderContext.getObjectModel().resolveProperty(_dynamic_fragment, "name"), "attribute")));
    {
        Object var_shoulddisplayattr5 = ((renderContext.getObjectModel().toBoolean(var_attrcontent4) ? var_attrcontent4 : ("false".equals(var_attrcontent4))));
        if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr5)) {
            out.write(" class=\"");
            out.write(renderContext.getObjectModel().toString(var_attrcontent4));
            out.write("\"");
        }
    }
}
{
    Object var_attrvalue6 = renderContext.getObjectModel().resolveProperty(_dynamic_fragment, "type");
    {
        Object var_attrcontent7 = renderContext.call("xss", var_attrvalue6, "attribute");
        {
            Object var_shoulddisplayattr9 = ((renderContext.getObjectModel().toBoolean(var_attrcontent7) ? var_attrcontent7 : ("false".equals(var_attrvalue6))));
            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr9)) {
                out.write(" data-cmp-contentfragment-model");
                {
                    boolean var_istrueattr8 = (var_attrvalue6.equals(true));
                    if (!var_istrueattr8) {
                        out.write("=\"");
                        out.write(renderContext.getObjectModel().toString(var_attrcontent7));
                        out.write("\"");
                    }
                }
            }
        }
    }
}
{
    Object var_attrvalue10 = (((!renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "disabled"))) ? renderContext.getObjectModel().resolveProperty(_dynamic_fragment, "editorJSON") : (!renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "disabled")))));
    {
        Object var_attrcontent11 = renderContext.call("xss", var_attrvalue10, "attribute");
        {
            Object var_shoulddisplayattr13 = ((renderContext.getObjectModel().toBoolean(var_attrcontent11) ? var_attrcontent11 : ("false".equals(var_attrvalue10))));
            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr13)) {
                out.write(" data-json");
                {
                    boolean var_istrueattr12 = (var_attrvalue10.equals(true));
                    if (!var_istrueattr12) {
                        out.write("=\"");
                        out.write(renderContext.getObjectModel().toString(var_attrcontent11));
                        out.write("\"");
                    }
                }
            }
        }
    }
}
{
    Object var_attrvalue_data_cmp_contentfragment_path0 = _dynamic_fragmentpath;
    {
        Object var_attrvalueescaped_data_cmp_contentfragment_path1 = renderContext.call("xss", var_attrvalue_data_cmp_contentfragment_path0, "attribute", "data-cmp-contentfragment-path");
        {
            Object var_shoulddisplayattr_data_cmp_contentfragment_path3 = ((renderContext.getObjectModel().toBoolean(var_attrvalueescaped_data_cmp_contentfragment_path1) ? var_attrvalueescaped_data_cmp_contentfragment_path1 : ("false".equals(var_attrvalue_data_cmp_contentfragment_path0))));
            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr_data_cmp_contentfragment_path3)) {
                out.write(" data-cmp-contentfragment-path");
                {
                    boolean var_istruevalue_data_cmp_contentfragment_path2 = (var_attrvalue_data_cmp_contentfragment_path0.equals(true));
                    if (!var_istruevalue_data_cmp_contentfragment_path2) {
                        out.write("=\"");
                        out.write(renderContext.getObjectModel().toString(var_attrvalueescaped_data_cmp_contentfragment_path1));
                        out.write("\"");
                    }
                }
            }
        }
    }
}
out.write(">\n        <h3 class=\"cmp-contentfragment__title\">");
{
    Object var_14 = renderContext.call("xss", renderContext.getObjectModel().resolveProperty(_dynamic_fragment, "title"), "text");
    out.write(renderContext.getObjectModel().toString(var_14));
}
out.write("</h3>\n        ");
{
    Object var_testvariable15 = renderContext.getObjectModel().resolveProperty(_dynamic_fragment, "description");
    if (renderContext.getObjectModel().toBoolean(var_testvariable15)) {
        out.write("\n            <p class=\"cmp-contentfragment__description\">");
        {
            Object var_16 = renderContext.call("xss", renderContext.getObjectModel().resolveProperty(_dynamic_fragment, "description"), "text");
            out.write(renderContext.getObjectModel().toString(var_16));
        }
        out.write("</p>\n        ");
    }
}
out.write("\n\n        ");
_global_isparagraphmode = ((renderContext.getObjectModel().toBoolean((((org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator.strictEq(renderContext.getObjectModel().resolveProperty(renderContext.getObjectModel().resolveProperty(_dynamic_fragment, "elements"), "size"), 1)) ? renderContext.getObjectModel().resolveProperty(renderContext.getObjectModel().resolveProperty(renderContext.getObjectModel().resolveProperty(_dynamic_fragment, "elements"), 0), "isMultiLine") : (org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator.strictEq(renderContext.getObjectModel().resolveProperty(renderContext.getObjectModel().resolveProperty(_dynamic_fragment, "elements"), "size"), 1))))) ? (org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator.strictEq(renderContext.getObjectModel().resolveProperty(_dynamic_properties, "displayMode"), "singleText")) : (((org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator.strictEq(renderContext.getObjectModel().resolveProperty(renderContext.getObjectModel().resolveProperty(_dynamic_fragment, "elements"), "size"), 1)) ? renderContext.getObjectModel().resolveProperty(renderContext.getObjectModel().resolveProperty(renderContext.getObjectModel().resolveProperty(_dynamic_fragment, "elements"), 0), "isMultiLine") : (org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator.strictEq(renderContext.getObjectModel().resolveProperty(renderContext.getObjectModel().resolveProperty(_dynamic_fragment, "elements"), "size"), 1))))));
if (renderContext.getObjectModel().toBoolean(_global_isparagraphmode)) {
    out.write("\n            ");
    {
        Object var_templatevar17 = _dynamic_paragraphs;
        {
            Object var_templateoptions18_field$_fragment = _dynamic_fragment;
            {
                java.util.Map var_templateoptions18 = obj().with("fragment", var_templateoptions18_field$_fragment);
                callUnit(out, renderContext, var_templatevar17, var_templateoptions18);
            }
        }
    }
    out.write("\n        ");
}
out.write("\n        ");
{
    boolean var_testvariable19 = (!renderContext.getObjectModel().toBoolean(_global_isparagraphmode));
    if (var_testvariable19) {
        out.write("\n            ");
        {
            Object var_templatevar20 = _dynamic_elements;
            {
                Object var_templateoptions21_field$_wcmmode = _dynamic_wcmmode;
                {
                    Object var_templateoptions21_field$_fragment = _dynamic_fragment;
                    {
                        java.util.Map var_templateoptions21 = obj().with("wcmmode", var_templateoptions21_field$_wcmmode).with("fragment", var_templateoptions21_field$_fragment);
                        callUnit(out, renderContext, var_templatevar20, var_templateoptions21);
                    }
                }
            }
        }
        out.write("\n        ");
    }
}
out.write("\n    </article>\n");


// End Of Main Sub-Template Body ------------------------------------------------------------------
    }



    {
//Sub-Sub-Templates Initialization ----------------------------------------------------------------



//End of Sub-Sub-Templates Initialization ---------------------------------------------------------
    }
    
});
/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
addSubTemplate("elements", new RenderUnit() {

    @Override
    protected final void render(PrintWriter out,
                                Bindings bindings,
                                Bindings arguments,
                                RenderContext renderContext) {
// Main Sub-Template Body -------------------------------------------------------------------------

Object _global_elementtemplate = null;
Object _dynamic_fragment = arguments.get("fragment");
Collection var_collectionvar35_list_coerced$ = null;
Object _dynamic_wcmmode = arguments.get("wcmmode");
out.write("\n    ");
_global_elementtemplate = renderContext.call("use", "core/wcm/components/contentfragment/v1/contentfragment/element.html", obj());
{
    Object var_collectionvar35 = renderContext.getObjectModel().resolveProperty(_dynamic_fragment, "elements");
    {
        long var_size36 = ((var_collectionvar35_list_coerced$ == null ? (var_collectionvar35_list_coerced$ = renderContext.getObjectModel().toCollection(var_collectionvar35)) : var_collectionvar35_list_coerced$).size());
        {
            boolean var_notempty37 = (var_size36 > 0);
            if (var_notempty37) {
                {
                    long var_end40 = var_size36;
                    {
                        boolean var_validstartstepend41 = (((0 < var_size36) && true) && (var_end40 > 0));
                        if (var_validstartstepend41) {
                            out.write("<dl");
                            {
                                String var_attrcontent42 = ("cmp-contentfragment__elements" + renderContext.getObjectModel().toString(renderContext.call("xss", ((!renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "disabled"))) ? " cq-dd-contentfragment" : ""), "attribute")));
                                {
                                    Object var_shoulddisplayattr43 = ((renderContext.getObjectModel().toBoolean(var_attrcontent42) ? var_attrcontent42 : ("false".equals(var_attrcontent42))));
                                    if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr43)) {
                                        out.write(" class=\"");
                                        out.write(renderContext.getObjectModel().toString(var_attrcontent42));
                                        out.write("\"");
                                    }
                                }
                            }
                            out.write(">");
                            if (var_collectionvar35_list_coerced$ == null) {
                                var_collectionvar35_list_coerced$ = renderContext.getObjectModel().toCollection(var_collectionvar35);
                            }
                            long var_index44 = 0;
                            for (Object element : var_collectionvar35_list_coerced$) {
                                {
                                    long var_stepcondition45 = ((var_index44 - 0) % 1);
                                    {
                                        boolean var_traversal46 = (((var_index44 >= 0) && (var_index44 <= var_end40)) && (var_stepcondition45 == 0));
                                        if (var_traversal46) {
                                            out.write("\n        ");
                                            {
                                                Object var_templatevar47 = renderContext.getObjectModel().resolveProperty(_global_elementtemplate, "element");
                                                {
                                                    Object var_templateoptions48_field$_element = element;
                                                    {
                                                        java.util.Map var_templateoptions48 = obj().with("element", var_templateoptions48_field$_element);
                                                        callUnit(out, renderContext, var_templatevar47, var_templateoptions48);
                                                    }
                                                }
                                            }
                                            out.write("\n    ");
                                        }
                                    }
                                }
                                var_index44++;
                            }
                            out.write("</dl>");
                        }
                    }
                }
            }
        }
    }
    var_collectionvar35_list_coerced$ = null;
}
out.write("\n");


// End Of Main Sub-Template Body ------------------------------------------------------------------
    }



    {
//Sub-Sub-Templates Initialization ----------------------------------------------------------------



//End of Sub-Sub-Templates Initialization ---------------------------------------------------------
    }
    
});
/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
addSubTemplate("paragraphs", new RenderUnit() {

    @Override
    protected final void render(PrintWriter out,
                                Bindings bindings,
                                Bindings arguments,
                                RenderContext renderContext) {
// Main Sub-Template Body -------------------------------------------------------------------------

Object _dynamic_fragment = arguments.get("fragment");
Collection var_collectionvar23_list_coerced$ = null;
out.write("\n    <div class=\"cmp-contentfragment__elements\">\n        <div>");
{
    Object var_resourcecontent22 = renderContext.call("includeResource", "par0", obj().with("resourceType", renderContext.getObjectModel().resolveProperty(_dynamic_fragment, "gridResourceType")));
    out.write(renderContext.getObjectModel().toString(var_resourcecontent22));
}
out.write("</div>\n        ");
{
    Object var_collectionvar23 = renderContext.getObjectModel().resolveProperty(_dynamic_fragment, "paragraphs");
    {
        long var_size24 = ((var_collectionvar23_list_coerced$ == null ? (var_collectionvar23_list_coerced$ = renderContext.getObjectModel().toCollection(var_collectionvar23)) : var_collectionvar23_list_coerced$).size());
        {
            boolean var_notempty25 = (var_size24 > 0);
            if (var_notempty25) {
                {
                    long var_end28 = var_size24;
                    {
                        boolean var_validstartstepend29 = (((0 < var_size24) && true) && (var_end28 > 0));
                        if (var_validstartstepend29) {
                            out.write("<div>");
                            if (var_collectionvar23_list_coerced$ == null) {
                                var_collectionvar23_list_coerced$ = renderContext.getObjectModel().toCollection(var_collectionvar23);
                            }
                            long var_index30 = 0;
                            for (Object item : var_collectionvar23_list_coerced$) {
                                {
                                    long itemlist_field$_count = (var_index30 + 1);
                                    {
                                        long var_stepcondition31 = ((var_index30 - 0) % 1);
                                        {
                                            boolean var_traversal32 = (((var_index30 >= 0) && (var_index30 <= var_end28)) && (var_stepcondition31 == 0));
                                            if (var_traversal32) {
                                                {
                                                    String var_33 = (("\n            " + renderContext.getObjectModel().toString(renderContext.call("xss", item, "html"))) + "\n            ");
                                                    out.write(renderContext.getObjectModel().toString(var_33));
                                                }
                                                out.write("<div>");
                                                {
                                                    Object var_resourcecontent34 = renderContext.call("includeResource", renderContext.call("format", "par{0}", obj().with("format", itemlist_field$_count)), obj().with("resourceType", renderContext.getObjectModel().resolveProperty(_dynamic_fragment, "gridResourceType")));
                                                    out.write(renderContext.getObjectModel().toString(var_resourcecontent34));
                                                }
                                                out.write("</div>\n        ");
                                            }
                                        }
                                    }
                                }
                                var_index30++;
                            }
                            out.write("</div>");
                        }
                    }
                }
            }
        }
    }
    var_collectionvar23_list_coerced$ = null;
}
out.write("\n    </div>\n");


// End Of Main Sub-Template Body ------------------------------------------------------------------
    }



    {
//Sub-Sub-Templates Initialization ----------------------------------------------------------------



//End of Sub-Sub-Templates Initialization ---------------------------------------------------------
    }
    
});


//End of Sub-Templates Initialization -------------------------------------------------------------
    }

}

