/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
package org.apache.sling.scripting.sightly.apps.core.wcm.components.carousel.v1.carousel;

import java.io.PrintWriter;
import java.util.Collection;
import javax.script.Bindings;

import org.apache.sling.scripting.sightly.java.compiler.RenderUnit;
import org.apache.sling.scripting.sightly.render.RenderContext;

public final class carousel_html extends RenderUnit {

    @Override
    protected final void render(PrintWriter out,
                                Bindings bindings,
                                Bindings arguments,
                                RenderContext renderContext) {
// Main Template Body -----------------------------------------------------------------------------

Object _global_carousel = null;
Object _global_templates = null;
Object _dynamic_wcmmode = bindings.get("wcmmode");
Collection var_collectionvar17_list_coerced$ = null;
Collection var_collectionvar60_list_coerced$ = null;
Object _dynamic_resource = bindings.get("resource");
out.write("\n");
_global_carousel = renderContext.call("use", com.adobe.cq.wcm.core.components.models.Carousel.class.getName(), obj());
_global_templates = renderContext.call("use", "core/wcm/components/commons/v1/templates.html", obj());
out.write("<div class=\"cmp-carousel\" role=\"group\"");
{
    Object var_attrvalue0 = renderContext.getObjectModel().resolveProperty(_global_carousel, "accessibilityLabel");
    {
        Object var_attrcontent1 = renderContext.call("xss", var_attrvalue0, "attribute");
        {
            Object var_shoulddisplayattr3 = ((renderContext.getObjectModel().toBoolean(var_attrcontent1) ? var_attrcontent1 : ("false".equals(var_attrvalue0))));
            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr3)) {
                out.write(" aria-label");
                {
                    boolean var_istrueattr2 = (var_attrvalue0.equals(true));
                    if (!var_istrueattr2) {
                        out.write("=\"");
                        out.write(renderContext.getObjectModel().toString(var_attrcontent1));
                        out.write("\"");
                    }
                }
            }
        }
    }
}
out.write(" aria-roledescription=\"carousel\" data-cmp-is=\"carousel\"");
{
    Object var_attrvalue4 = (renderContext.getObjectModel().toBoolean(((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "edit")) ? renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "edit") : renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "preview")))) ? "" : renderContext.getObjectModel().resolveProperty(_global_carousel, "autoplay"));
    {
        Object var_attrcontent5 = renderContext.call("xss", var_attrvalue4, "attribute");
        {
            Object var_shoulddisplayattr7 = ((renderContext.getObjectModel().toBoolean(var_attrcontent5) ? var_attrcontent5 : ("false".equals(var_attrvalue4))));
            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr7)) {
                out.write(" data-cmp-autoplay");
                {
                    boolean var_istrueattr6 = (var_attrvalue4.equals(true));
                    if (!var_istrueattr6) {
                        out.write("=\"");
                        out.write(renderContext.getObjectModel().toString(var_attrcontent5));
                        out.write("\"");
                    }
                }
            }
        }
    }
}
{
    Object var_attrvalue8 = renderContext.getObjectModel().resolveProperty(_global_carousel, "delay");
    {
        Object var_attrcontent9 = renderContext.call("xss", var_attrvalue8, "attribute");
        {
            Object var_shoulddisplayattr11 = ((renderContext.getObjectModel().toBoolean(var_attrcontent9) ? var_attrcontent9 : ("false".equals(var_attrvalue8))));
            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr11)) {
                out.write(" data-cmp-delay");
                {
                    boolean var_istrueattr10 = (var_attrvalue8.equals(true));
                    if (!var_istrueattr10) {
                        out.write("=\"");
                        out.write(renderContext.getObjectModel().toString(var_attrcontent9));
                        out.write("\"");
                    }
                }
            }
        }
    }
}
{
    Object var_attrvalue12 = renderContext.getObjectModel().resolveProperty(_global_carousel, "autopauseDisabled");
    {
        Object var_attrcontent13 = renderContext.call("xss", var_attrvalue12, "attribute");
        {
            Object var_shoulddisplayattr15 = ((renderContext.getObjectModel().toBoolean(var_attrcontent13) ? var_attrcontent13 : ("false".equals(var_attrvalue12))));
            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr15)) {
                out.write(" data-cmp-autopause-disabled");
                {
                    boolean var_istrueattr14 = (var_attrvalue12.equals(true));
                    if (!var_istrueattr14) {
                        out.write("=\"");
                        out.write(renderContext.getObjectModel().toString(var_attrcontent13));
                        out.write("\"");
                    }
                }
            }
        }
    }
}
out.write(">\n    ");
{
    Object var_testvariable16 = ((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_carousel, "items")) ? (!(org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator.leq(renderContext.getObjectModel().resolveProperty(renderContext.getObjectModel().resolveProperty(_global_carousel, "items"), "size"), 0))) : renderContext.getObjectModel().resolveProperty(_global_carousel, "items")));
    if (renderContext.getObjectModel().toBoolean(var_testvariable16)) {
        out.write("<div class=\"cmp-carousel__content\">\n        ");
        {
            Object var_collectionvar17 = renderContext.getObjectModel().resolveProperty(_global_carousel, "items");
            {
                long var_size18 = ((var_collectionvar17_list_coerced$ == null ? (var_collectionvar17_list_coerced$ = renderContext.getObjectModel().toCollection(var_collectionvar17)) : var_collectionvar17_list_coerced$).size());
                {
                    boolean var_notempty19 = (var_size18 > 0);
                    if (var_notempty19) {
                        {
                            long var_end22 = var_size18;
                            {
                                boolean var_validstartstepend23 = (((0 < var_size18) && true) && (var_end22 > 0));
                                if (var_validstartstepend23) {
                                    if (var_collectionvar17_list_coerced$ == null) {
                                        var_collectionvar17_list_coerced$ = renderContext.getObjectModel().toCollection(var_collectionvar17);
                                    }
                                    long var_index24 = 0;
                                    for (Object item : var_collectionvar17_list_coerced$) {
                                        {
                                            long itemlist_field$_count = (var_index24 + 1);
                                            {
                                                boolean itemlist_field$_first = (var_index24 == 0);
                                                {
                                                    long var_stepcondition25 = ((var_index24 - 0) % 1);
                                                    {
                                                        boolean var_traversal26 = (((var_index24 >= 0) && (var_index24 <= var_end22)) && (var_stepcondition25 == 0));
                                                        if (var_traversal26) {
                                                            out.write("<div");
                                                            {
                                                                String var_attrcontent27 = ("cmp-carousel__item" + renderContext.getObjectModel().toString(renderContext.call("xss", (itemlist_field$_first ? " cmp-carousel__item--active" : ""), "attribute")));
                                                                {
                                                                    Object var_shoulddisplayattr28 = ((renderContext.getObjectModel().toBoolean(var_attrcontent27) ? var_attrcontent27 : ("false".equals(var_attrcontent27))));
                                                                    if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr28)) {
                                                                        out.write(" class=\"");
                                                                        out.write(renderContext.getObjectModel().toString(var_attrcontent27));
                                                                        out.write("\"");
                                                                    }
                                                                }
                                                            }
                                                            out.write(" role=\"tabpanel\"");
                                                            {
                                                                Object var_attrvalue29 = renderContext.call("format", renderContext.call("i18n", "Slide {0} of {1}", obj()), obj().with("format", (new Object[] {itemlist_field$_count, renderContext.getObjectModel().resolveProperty(renderContext.getObjectModel().resolveProperty(_global_carousel, "items"), "size")})));
                                                                {
                                                                    Object var_attrcontent30 = renderContext.call("xss", var_attrvalue29, "attribute");
                                                                    {
                                                                        Object var_shoulddisplayattr32 = ((renderContext.getObjectModel().toBoolean(var_attrcontent30) ? var_attrcontent30 : ("false".equals(var_attrvalue29))));
                                                                        if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr32)) {
                                                                            out.write(" aria-label");
                                                                            {
                                                                                boolean var_istrueattr31 = (var_attrvalue29.equals(true));
                                                                                if (!var_istrueattr31) {
                                                                                    out.write("=\"");
                                                                                    out.write(renderContext.getObjectModel().toString(var_attrcontent30));
                                                                                    out.write("\"");
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                            out.write(" data-cmp-hook-carousel=\"item\">");
                                                            {
                                                                Object var_resourcecontent33 = renderContext.call("includeResource", renderContext.getObjectModel().resolveProperty(item, "name"), obj().with("decorationTagName", "div"));
                                                                out.write(renderContext.getObjectModel().toString(var_resourcecontent33));
                                                            }
                                                            out.write("</div>\n");
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        var_index24++;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            var_collectionvar17_list_coerced$ = null;
        }
        out.write("\n        <div class=\"cmp-carousel__actions\">\n            <button class=\"cmp-carousel__action cmp-carousel__action--previous\" type=\"button\"");
        {
            Object var_attrvalue34 = renderContext.call("i18n", "Previous", obj());
            {
                Object var_attrcontent35 = renderContext.call("xss", var_attrvalue34, "attribute");
                {
                    Object var_shoulddisplayattr37 = ((renderContext.getObjectModel().toBoolean(var_attrcontent35) ? var_attrcontent35 : ("false".equals(var_attrvalue34))));
                    if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr37)) {
                        out.write(" aria-label");
                        {
                            boolean var_istrueattr36 = (var_attrvalue34.equals(true));
                            if (!var_istrueattr36) {
                                out.write("=\"");
                                out.write(renderContext.getObjectModel().toString(var_attrcontent35));
                                out.write("\"");
                            }
                        }
                    }
                }
            }
        }
        out.write(" data-cmp-hook-carousel=\"previous\">\n                <span class=\"cmp-carousel__action-icon\"></span>\n                <span class=\"cmp-carousel__action-text\">");
        {
            Object var_38 = renderContext.call("xss", renderContext.call("i18n", "Previous", obj()), "text");
            out.write(renderContext.getObjectModel().toString(var_38));
        }
        out.write("</span>\n            </button>\n            <button class=\"cmp-carousel__action cmp-carousel__action--next\" type=\"button\"");
        {
            Object var_attrvalue39 = renderContext.call("i18n", "Next", obj());
            {
                Object var_attrcontent40 = renderContext.call("xss", var_attrvalue39, "attribute");
                {
                    Object var_shoulddisplayattr42 = ((renderContext.getObjectModel().toBoolean(var_attrcontent40) ? var_attrcontent40 : ("false".equals(var_attrvalue39))));
                    if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr42)) {
                        out.write(" aria-label");
                        {
                            boolean var_istrueattr41 = (var_attrvalue39.equals(true));
                            if (!var_istrueattr41) {
                                out.write("=\"");
                                out.write(renderContext.getObjectModel().toString(var_attrcontent40));
                                out.write("\"");
                            }
                        }
                    }
                }
            }
        }
        out.write(" data-cmp-hook-carousel=\"next\">\n                <span class=\"cmp-carousel__action-icon\"></span>\n                <span class=\"cmp-carousel__action-text\">");
        {
            Object var_43 = renderContext.call("xss", renderContext.call("i18n", "Next", obj()), "text");
            out.write(renderContext.getObjectModel().toString(var_43));
        }
        out.write("</span>\n            </button>\n            ");
        {
            Object var_testvariable44 = renderContext.getObjectModel().resolveProperty(_global_carousel, "autoplay");
            if (renderContext.getObjectModel().toBoolean(var_testvariable44)) {
                out.write("<button class=\"cmp-carousel__action cmp-carousel__action--pause\" type=\"button\"");
                {
                    Object var_attrvalue45 = renderContext.call("i18n", "Pause", obj());
                    {
                        Object var_attrcontent46 = renderContext.call("xss", var_attrvalue45, "attribute");
                        {
                            Object var_shoulddisplayattr48 = ((renderContext.getObjectModel().toBoolean(var_attrcontent46) ? var_attrcontent46 : ("false".equals(var_attrvalue45))));
                            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr48)) {
                                out.write(" aria-label");
                                {
                                    boolean var_istrueattr47 = (var_attrvalue45.equals(true));
                                    if (!var_istrueattr47) {
                                        out.write("=\"");
                                        out.write(renderContext.getObjectModel().toString(var_attrcontent46));
                                        out.write("\"");
                                    }
                                }
                            }
                        }
                    }
                }
                out.write(" data-cmp-hook-carousel=\"pause\">\n                <span class=\"cmp-carousel__action-icon\"></span>\n                <span class=\"cmp-carousel__action-text\">");
                {
                    Object var_49 = renderContext.call("xss", renderContext.call("i18n", "Pause", obj()), "text");
                    out.write(renderContext.getObjectModel().toString(var_49));
                }
                out.write("</span>\n            </button>");
            }
        }
        out.write("\n            ");
        {
            Object var_testvariable50 = renderContext.getObjectModel().resolveProperty(_global_carousel, "autoplay");
            if (renderContext.getObjectModel().toBoolean(var_testvariable50)) {
                out.write("<button class=\"cmp-carousel__action cmp-carousel__action--play cmp-carousel__action--disabled\" type=\"button\"");
                {
                    Object var_attrvalue51 = renderContext.call("i18n", "Play", obj());
                    {
                        Object var_attrcontent52 = renderContext.call("xss", var_attrvalue51, "attribute");
                        {
                            Object var_shoulddisplayattr54 = ((renderContext.getObjectModel().toBoolean(var_attrcontent52) ? var_attrcontent52 : ("false".equals(var_attrvalue51))));
                            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr54)) {
                                out.write(" aria-label");
                                {
                                    boolean var_istrueattr53 = (var_attrvalue51.equals(true));
                                    if (!var_istrueattr53) {
                                        out.write("=\"");
                                        out.write(renderContext.getObjectModel().toString(var_attrcontent52));
                                        out.write("\"");
                                    }
                                }
                            }
                        }
                    }
                }
                out.write(" data-cmp-hook-carousel=\"play\">\n                <span class=\"cmp-carousel__action-icon\"></span>\n                <span class=\"cmp-carousel__action-text\">");
                {
                    Object var_55 = renderContext.call("xss", renderContext.call("i18n", "Play", obj()), "text");
                    out.write(renderContext.getObjectModel().toString(var_55));
                }
                out.write("</span>\n            </button>");
            }
        }
        out.write("\n        </div>\n        <ol class=\"cmp-carousel__indicators\" role=\"tablist\"");
        {
            Object var_attrvalue56 = renderContext.call("i18n", "Choose a slide to display", obj());
            {
                Object var_attrcontent57 = renderContext.call("xss", var_attrvalue56, "attribute");
                {
                    Object var_shoulddisplayattr59 = ((renderContext.getObjectModel().toBoolean(var_attrcontent57) ? var_attrcontent57 : ("false".equals(var_attrvalue56))));
                    if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr59)) {
                        out.write(" aria-label");
                        {
                            boolean var_istrueattr58 = (var_attrvalue56.equals(true));
                            if (!var_istrueattr58) {
                                out.write("=\"");
                                out.write(renderContext.getObjectModel().toString(var_attrcontent57));
                                out.write("\"");
                            }
                        }
                    }
                }
            }
        }
        out.write(" data-cmp-hook-carousel=\"indicators\">\n            ");
        {
            Object var_collectionvar60 = renderContext.getObjectModel().resolveProperty(_global_carousel, "items");
            {
                long var_size61 = ((var_collectionvar60_list_coerced$ == null ? (var_collectionvar60_list_coerced$ = renderContext.getObjectModel().toCollection(var_collectionvar60)) : var_collectionvar60_list_coerced$).size());
                {
                    boolean var_notempty62 = (var_size61 > 0);
                    if (var_notempty62) {
                        {
                            long var_end65 = var_size61;
                            {
                                boolean var_validstartstepend66 = (((0 < var_size61) && true) && (var_end65 > 0));
                                if (var_validstartstepend66) {
                                    if (var_collectionvar60_list_coerced$ == null) {
                                        var_collectionvar60_list_coerced$ = renderContext.getObjectModel().toCollection(var_collectionvar60);
                                    }
                                    long var_index67 = 0;
                                    for (Object item : var_collectionvar60_list_coerced$) {
                                        {
                                            long itemlist_field$_count = (var_index67 + 1);
                                            {
                                                boolean itemlist_field$_first = (var_index67 == 0);
                                                {
                                                    long var_stepcondition68 = ((var_index67 - 0) % 1);
                                                    {
                                                        boolean var_traversal69 = (((var_index67 >= 0) && (var_index67 <= var_end65)) && (var_stepcondition68 == 0));
                                                        if (var_traversal69) {
                                                            out.write("<li");
                                                            {
                                                                String var_attrcontent70 = ("cmp-carousel__indicator" + renderContext.getObjectModel().toString(renderContext.call("xss", (itemlist_field$_first ? " cmp-carousel__indicator--active" : ""), "attribute")));
                                                                {
                                                                    Object var_shoulddisplayattr71 = ((renderContext.getObjectModel().toBoolean(var_attrcontent70) ? var_attrcontent70 : ("false".equals(var_attrcontent70))));
                                                                    if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr71)) {
                                                                        out.write(" class=\"");
                                                                        out.write(renderContext.getObjectModel().toString(var_attrcontent70));
                                                                        out.write("\"");
                                                                    }
                                                                }
                                                            }
                                                            out.write(" role=\"tab\"");
                                                            {
                                                                Object var_attrvalue72 = renderContext.call("format", renderContext.call("i18n", "Slide {0}", obj()), obj().with("format", (new Object[] {itemlist_field$_count})));
                                                                {
                                                                    Object var_attrcontent73 = renderContext.call("xss", var_attrvalue72, "attribute");
                                                                    {
                                                                        Object var_shoulddisplayattr75 = ((renderContext.getObjectModel().toBoolean(var_attrcontent73) ? var_attrcontent73 : ("false".equals(var_attrvalue72))));
                                                                        if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr75)) {
                                                                            out.write(" aria-label");
                                                                            {
                                                                                boolean var_istrueattr74 = (var_attrvalue72.equals(true));
                                                                                if (!var_istrueattr74) {
                                                                                    out.write("=\"");
                                                                                    out.write(renderContext.getObjectModel().toString(var_attrcontent73));
                                                                                    out.write("\"");
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                            out.write(" data-cmp-hook-carousel=\"indicator\">");
                                                            {
                                                                Object var_76 = renderContext.call("xss", renderContext.getObjectModel().resolveProperty(item, "title"), "text");
                                                                out.write(renderContext.getObjectModel().toString(var_76));
                                                            }
                                                            out.write("</li>\n");
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        var_index67++;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            var_collectionvar60_list_coerced$ = null;
        }
        out.write("\n        </ol>\n    </div>");
    }
}
out.write("\n    ");
{
    Object var_testvariable77 = ((renderContext.getObjectModel().toBoolean(((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "edit")) ? renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "edit") : renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "preview")))) ? (org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator.lt(renderContext.getObjectModel().resolveProperty(renderContext.getObjectModel().resolveProperty(_global_carousel, "items"), "size"), 1)) : ((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "edit")) ? renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "edit") : renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "preview")))));
    if (renderContext.getObjectModel().toBoolean(var_testvariable77)) {
        {
            Object var_resourcecontent78 = renderContext.call("includeResource", renderContext.getObjectModel().resolveProperty(_dynamic_resource, "path"), obj().with("cssClassName", "new section aem-Grid-newComponent").with("decorationTagName", "div").with("appendPath", "/*").with("resourceType", "wcm/foundation/components/parsys/newpar"));
            out.write(renderContext.getObjectModel().toString(var_resourcecontent78));
        }
    }
}
out.write("\n</div>\n");


// End Of Main Template Body ----------------------------------------------------------------------
    }



    {
//Sub-Templates Initialization --------------------------------------------------------------------



//End of Sub-Templates Initialization -------------------------------------------------------------
    }

}

