/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
package org.apache.sling.scripting.sightly.apps.core.wcm.components.button.v1.button;

import java.io.PrintWriter;
import java.util.Collection;
import javax.script.Bindings;

import org.apache.sling.scripting.sightly.java.compiler.RenderUnit;
import org.apache.sling.scripting.sightly.render.RenderContext;

public final class button_html extends RenderUnit {

    @Override
    protected final void render(PrintWriter out,
                                Bindings bindings,
                                Bindings arguments,
                                RenderContext renderContext) {
// Main Template Body -----------------------------------------------------------------------------

Object _global_button = null;
Object _global_icontemplate = null;
out.write("\n");
_global_button = renderContext.call("use", com.adobe.cq.wcm.core.components.models.Button.class.getName(), obj());
_global_icontemplate = renderContext.call("use", "icon.html", obj());
{
    Object var_tagvar0 = renderContext.call("xss", (renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_global_button, "link")) ? "a" : "button"), "elementName");
    if (renderContext.getObjectModel().toBoolean(var_tagvar0)) {
        out.write("<");
        out.write(renderContext.getObjectModel().toString(var_tagvar0));
    }
    if (!renderContext.getObjectModel().toBoolean(var_tagvar0)) {
        out.write("<button");
    }
    out.write(" class=\"cmp-button\"");
    {
        Object var_attrvalue1 = renderContext.getObjectModel().resolveProperty(_global_button, "link");
        {
            Object var_attrcontent2 = renderContext.call("xss", var_attrvalue1, "uri");
            {
                Object var_shoulddisplayattr4 = ((renderContext.getObjectModel().toBoolean(var_attrcontent2) ? var_attrcontent2 : ("false".equals(var_attrvalue1))));
                if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr4)) {
                    out.write(" href");
                    {
                        boolean var_istrueattr3 = (var_attrvalue1.equals(true));
                        if (!var_istrueattr3) {
                            out.write("=\"");
                            out.write(renderContext.getObjectModel().toString(var_attrcontent2));
                            out.write("\"");
                        }
                    }
                }
            }
        }
    }
    {
        Object var_attrvalue5 = renderContext.getObjectModel().resolveProperty(_global_button, "accessibilityLabel");
        {
            Object var_attrcontent6 = renderContext.call("xss", var_attrvalue5, "attribute");
            {
                Object var_shoulddisplayattr8 = ((renderContext.getObjectModel().toBoolean(var_attrcontent6) ? var_attrcontent6 : ("false".equals(var_attrvalue5))));
                if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr8)) {
                    out.write(" aria-label");
                    {
                        boolean var_istrueattr7 = (var_attrvalue5.equals(true));
                        if (!var_istrueattr7) {
                            out.write("=\"");
                            out.write(renderContext.getObjectModel().toString(var_attrcontent6));
                            out.write("\"");
                        }
                    }
                }
            }
        }
    }
    out.write(">\n    ");
    {
        Object var_templatevar9 = renderContext.getObjectModel().resolveProperty(_global_icontemplate, "icon");
        {
            Object var_templateoptions10_field$_icon = renderContext.getObjectModel().resolveProperty(_global_button, "icon");
            {
                java.util.Map var_templateoptions10 = obj().with("icon", var_templateoptions10_field$_icon);
                callUnit(out, renderContext, var_templatevar9, var_templateoptions10);
            }
        }
    }
    out.write("\n    ");
    {
        Object var_testvariable11 = renderContext.getObjectModel().resolveProperty(_global_button, "text");
        if (renderContext.getObjectModel().toBoolean(var_testvariable11)) {
            out.write("<span class=\"cmp-button__text\">");
            {
                Object var_12 = renderContext.call("xss", renderContext.getObjectModel().resolveProperty(_global_button, "text"), "text");
                out.write(renderContext.getObjectModel().toString(var_12));
            }
            out.write("</span>");
        }
    }
    out.write("\n");
    if (renderContext.getObjectModel().toBoolean(var_tagvar0)) {
        out.write("</");
        out.write(renderContext.getObjectModel().toString(var_tagvar0));
        out.write(">");
    }
    if (!renderContext.getObjectModel().toBoolean(var_tagvar0)) {
        out.write("</button>");
    }
}
out.write("\n");


// End Of Main Template Body ----------------------------------------------------------------------
    }



    {
//Sub-Templates Initialization --------------------------------------------------------------------



//End of Sub-Templates Initialization -------------------------------------------------------------
    }

}

