/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
package org.apache.sling.scripting.sightly.apps.core.wcm.components.breadcrumb.v2.breadcrumb;

import java.io.PrintWriter;
import java.util.Collection;
import javax.script.Bindings;

import org.apache.sling.scripting.sightly.java.compiler.RenderUnit;
import org.apache.sling.scripting.sightly.render.RenderContext;

public final class breadcrumb_html extends RenderUnit {

    @Override
    protected final void render(PrintWriter out,
                                Bindings bindings,
                                Bindings arguments,
                                RenderContext renderContext) {
// Main Template Body -----------------------------------------------------------------------------

Object _global_breadcrumb = null;
Object _global_template = null;
Collection var_collectionvar5_list_coerced$ = null;
out.write("\n");
_global_breadcrumb = renderContext.call("use", com.adobe.cq.wcm.core.components.models.Breadcrumb.class.getName(), obj());
_global_template = renderContext.call("use", "core/wcm/components/commons/v1/templates.html", obj());
{
    boolean var_testvariable0 = (!(org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator.leq(renderContext.getObjectModel().resolveProperty(renderContext.getObjectModel().resolveProperty(_global_breadcrumb, "items"), "size"), 0)));
    if (var_testvariable0) {
        out.write("<nav class=\"cmp-breadcrumb\"");
        {
            Object var_attrvalue1 = renderContext.call("i18n", "Breadcrumb", obj());
            {
                Object var_attrcontent2 = renderContext.call("xss", var_attrvalue1, "attribute");
                {
                    Object var_shoulddisplayattr4 = ((renderContext.getObjectModel().toBoolean(var_attrcontent2) ? var_attrcontent2 : ("false".equals(var_attrvalue1))));
                    if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr4)) {
                        out.write(" aria-label");
                        {
                            boolean var_istrueattr3 = (var_attrvalue1.equals(true));
                            if (!var_istrueattr3) {
                                out.write("=\"");
                                out.write(renderContext.getObjectModel().toString(var_attrcontent2));
                                out.write("\"");
                            }
                        }
                    }
                }
            }
        }
        out.write(">\n    ");
        {
            Object var_collectionvar5 = renderContext.getObjectModel().resolveProperty(_global_breadcrumb, "items");
            {
                long var_size6 = ((var_collectionvar5_list_coerced$ == null ? (var_collectionvar5_list_coerced$ = renderContext.getObjectModel().toCollection(var_collectionvar5)) : var_collectionvar5_list_coerced$).size());
                {
                    boolean var_notempty7 = (var_size6 > 0);
                    if (var_notempty7) {
                        {
                            long var_end10 = var_size6;
                            {
                                boolean var_validstartstepend11 = (((0 < var_size6) && true) && (var_end10 > 0));
                                if (var_validstartstepend11) {
                                    out.write("<ol class=\"cmp-breadcrumb__list\" itemscope itemtype=\"http://schema.org/BreadcrumbList\">");
                                    if (var_collectionvar5_list_coerced$ == null) {
                                        var_collectionvar5_list_coerced$ = renderContext.getObjectModel().toCollection(var_collectionvar5);
                                    }
                                    long var_index12 = 0;
                                    for (Object navitem : var_collectionvar5_list_coerced$) {
                                        {
                                            long navitemlist_field$_count = (var_index12 + 1);
                                            {
                                                long var_stepcondition13 = ((var_index12 - 0) % 1);
                                                {
                                                    boolean var_traversal14 = (((var_index12 >= 0) && (var_index12 <= var_end10)) && (var_stepcondition13 == 0));
                                                    if (var_traversal14) {
                                                        out.write("\n        <li");
                                                        {
                                                            String var_attrcontent15 = ("cmp-breadcrumb__item" + renderContext.getObjectModel().toString(renderContext.call("xss", (renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(navitem, "active")) ? " cmp-breadcrumb__item--active" : ""), "attribute")));
                                                            {
                                                                Object var_shoulddisplayattr16 = ((renderContext.getObjectModel().toBoolean(var_attrcontent15) ? var_attrcontent15 : ("false".equals(var_attrcontent15))));
                                                                if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr16)) {
                                                                    out.write(" class=\"");
                                                                    out.write(renderContext.getObjectModel().toString(var_attrcontent15));
                                                                    out.write("\"");
                                                                }
                                                            }
                                                        }
                                                        out.write(" itemprop=\"itemListElement\" itemscope itemtype=\"http://schema.org/ListItem\">\n            ");
                                                        {
                                                            Object var_unwrapcondition17 = renderContext.getObjectModel().resolveProperty(navitem, "active");
                                                            if (!renderContext.getObjectModel().toBoolean(var_unwrapcondition17)) {
                                                                out.write("<a");
                                                                {
                                                                    Object var_attrvalue18 = renderContext.getObjectModel().resolveProperty(navitem, "URL");
                                                                    {
                                                                        Object var_attrcontent19 = renderContext.call("xss", var_attrvalue18, "uri");
                                                                        {
                                                                            Object var_shoulddisplayattr21 = ((renderContext.getObjectModel().toBoolean(var_attrcontent19) ? var_attrcontent19 : ("false".equals(var_attrvalue18))));
                                                                            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr21)) {
                                                                                out.write(" href");
                                                                                {
                                                                                    boolean var_istrueattr20 = (var_attrvalue18.equals(true));
                                                                                    if (!var_istrueattr20) {
                                                                                        out.write("=\"");
                                                                                        out.write(renderContext.getObjectModel().toString(var_attrcontent19));
                                                                                        out.write("\"");
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                                out.write(" class=\"cmp-breadcrumb__item-link\" itemprop=\"item\">");
                                                            }
                                                            out.write("\n                <span itemprop=\"name\">");
                                                            {
                                                                Object var_22 = renderContext.call("xss", renderContext.getObjectModel().resolveProperty(navitem, "title"), "text");
                                                                out.write(renderContext.getObjectModel().toString(var_22));
                                                            }
                                                            out.write("</span>\n            ");
                                                            if (!renderContext.getObjectModel().toBoolean(var_unwrapcondition17)) {
                                                                out.write("</a>");
                                                            }
                                                        }
                                                        out.write("\n            <meta itemprop=\"position\"");
                                                        {
                                                            long var_attrvalue23 = navitemlist_field$_count;
                                                            {
                                                                Object var_attrcontent24 = renderContext.call("xss", var_attrvalue23, "attribute");
                                                                {
                                                                    Object var_shoulddisplayattr26 = ((renderContext.getObjectModel().toBoolean(var_attrcontent24) ? var_attrcontent24 : ("false".equals(var_attrvalue23))));
                                                                    if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr26)) {
                                                                        out.write(" content");
                                                                        {
                                                                            boolean var_istrueattr25 = (((Object)var_attrvalue23).equals(true));
                                                                            if (!var_istrueattr25) {
                                                                                out.write("=\"");
                                                                                out.write(renderContext.getObjectModel().toString(var_attrcontent24));
                                                                                out.write("\"");
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        out.write("/>\n        </li>\n    ");
                                                    }
                                                }
                                            }
                                        }
                                        var_index12++;
                                    }
                                    out.write("</ol>");
                                }
                            }
                        }
                    }
                }
            }
            var_collectionvar5_list_coerced$ = null;
        }
        out.write("\n</nav>");
    }
}
out.write("\n");
{
    Object var_templatevar27 = renderContext.getObjectModel().resolveProperty(_global_template, "placeholder");
    {
        boolean var_templateoptions28_field$_isempty = (org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator.strictEq(renderContext.getObjectModel().resolveProperty(renderContext.getObjectModel().resolveProperty(_global_breadcrumb, "items"), "size"), 0));
        {
            String var_templateoptions28_field$_classappend = "cmp-breadcrumb";
            {
                java.util.Map var_templateoptions28 = obj().with("isEmpty", var_templateoptions28_field$_isempty).with("classAppend", var_templateoptions28_field$_classappend);
                callUnit(out, renderContext, var_templatevar27, var_templateoptions28);
            }
        }
    }
}


// End Of Main Template Body ----------------------------------------------------------------------
    }



    {
//Sub-Templates Initialization --------------------------------------------------------------------



//End of Sub-Templates Initialization -------------------------------------------------------------
    }

}

