/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
package org.apache.sling.scripting.sightly.apps.core.wcm.components.breadcrumb.v1.breadcrumb;

import java.io.PrintWriter;
import java.util.Collection;
import javax.script.Bindings;

import org.apache.sling.scripting.sightly.java.compiler.RenderUnit;
import org.apache.sling.scripting.sightly.render.RenderContext;

public final class breadcrumb_html extends RenderUnit {

    @Override
    protected final void render(PrintWriter out,
                                Bindings bindings,
                                Bindings arguments,
                                RenderContext renderContext) {
// Main Template Body -----------------------------------------------------------------------------

Object _global_breadcrumb = null;
Object _global_template = null;
Collection var_collectionvar0_list_coerced$ = null;
out.write("\n");
_global_breadcrumb = renderContext.call("use", com.adobe.cq.wcm.core.components.models.Breadcrumb.class.getName(), obj());
_global_template = renderContext.call("use", "core/wcm/components/commons/v1/templates.html", obj());
{
    Object var_collectionvar0 = renderContext.getObjectModel().resolveProperty(_global_breadcrumb, "items");
    {
        long var_size1 = ((var_collectionvar0_list_coerced$ == null ? (var_collectionvar0_list_coerced$ = renderContext.getObjectModel().toCollection(var_collectionvar0)) : var_collectionvar0_list_coerced$).size());
        {
            boolean var_notempty2 = (var_size1 > 0);
            if (var_notempty2) {
                {
                    long var_end5 = var_size1;
                    {
                        boolean var_validstartstepend6 = (((0 < var_size1) && true) && (var_end5 > 0));
                        if (var_validstartstepend6) {
                            out.write("<ol class=\"breadcrumb\">");
                            if (var_collectionvar0_list_coerced$ == null) {
                                var_collectionvar0_list_coerced$ = renderContext.getObjectModel().toCollection(var_collectionvar0);
                            }
                            long var_index7 = 0;
                            for (Object navitem : var_collectionvar0_list_coerced$) {
                                {
                                    long var_stepcondition8 = ((var_index7 - 0) % 1);
                                    {
                                        boolean var_traversal9 = (((var_index7 >= 0) && (var_index7 <= var_end5)) && (var_stepcondition8 == 0));
                                        if (var_traversal9) {
                                            out.write("\n    <li");
                                            {
                                                String var_attrcontent10 = ("breadcrumb-item " + renderContext.getObjectModel().toString(renderContext.call("xss", (renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(navitem, "active")) ? "active" : ""), "attribute")));
                                                {
                                                    Object var_shoulddisplayattr11 = ((renderContext.getObjectModel().toBoolean(var_attrcontent10) ? var_attrcontent10 : ("false".equals(var_attrcontent10))));
                                                    if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr11)) {
                                                        out.write(" class=\"");
                                                        out.write(renderContext.getObjectModel().toString(var_attrcontent10));
                                                        out.write("\"");
                                                    }
                                                }
                                            }
                                            out.write(">\n        ");
                                            {
                                                Object var_unwrapcondition12 = renderContext.getObjectModel().resolveProperty(navitem, "active");
                                                if (!renderContext.getObjectModel().toBoolean(var_unwrapcondition12)) {
                                                    out.write("<a");
                                                    {
                                                        Object var_attrvalue13 = renderContext.getObjectModel().resolveProperty(navitem, "URL");
                                                        {
                                                            Object var_attrcontent14 = renderContext.call("xss", var_attrvalue13, "uri");
                                                            {
                                                                Object var_shoulddisplayattr16 = ((renderContext.getObjectModel().toBoolean(var_attrcontent14) ? var_attrcontent14 : ("false".equals(var_attrvalue13))));
                                                                if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr16)) {
                                                                    out.write(" href");
                                                                    {
                                                                        boolean var_istrueattr15 = (var_attrvalue13.equals(true));
                                                                        if (!var_istrueattr15) {
                                                                            out.write("=\"");
                                                                            out.write(renderContext.getObjectModel().toString(var_attrcontent14));
                                                                            out.write("\"");
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    out.write(">");
                                                }
                                                {
                                                    Object var_17 = renderContext.call("xss", renderContext.getObjectModel().resolveProperty(navitem, "title"), "text");
                                                    out.write(renderContext.getObjectModel().toString(var_17));
                                                }
                                                if (!renderContext.getObjectModel().toBoolean(var_unwrapcondition12)) {
                                                    out.write("</a>");
                                                }
                                            }
                                            out.write("\n    </li>\n");
                                        }
                                    }
                                }
                                var_index7++;
                            }
                            out.write("</ol>");
                        }
                    }
                }
            }
        }
    }
    var_collectionvar0_list_coerced$ = null;
}
out.write("\n");
{
    Object var_templatevar18 = renderContext.getObjectModel().resolveProperty(_global_template, "placeholder");
    {
        boolean var_templateoptions19_field$_isempty = (org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator.strictEq(renderContext.getObjectModel().resolveProperty(renderContext.getObjectModel().resolveProperty(_global_breadcrumb, "items"), "size"), 0));
        {
            java.util.Map var_templateoptions19 = obj().with("isEmpty", var_templateoptions19_field$_isempty);
            callUnit(out, renderContext, var_templatevar18, var_templateoptions19);
        }
    }
}


// End Of Main Template Body ----------------------------------------------------------------------
    }



    {
//Sub-Templates Initialization --------------------------------------------------------------------



//End of Sub-Templates Initialization -------------------------------------------------------------
    }

}

