/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
package org.apache.sling.scripting.sightly.apps.core.wcm.components.accordion.v1.accordion;

import java.io.PrintWriter;
import java.util.Collection;
import javax.script.Bindings;

import org.apache.sling.scripting.sightly.java.compiler.RenderUnit;
import org.apache.sling.scripting.sightly.render.RenderContext;

public final class accordion_html extends RenderUnit {

    @Override
    protected final void render(PrintWriter out,
                                Bindings bindings,
                                Bindings arguments,
                                RenderContext renderContext) {
// Main Template Body -----------------------------------------------------------------------------

Object _global_accordion = null;
Collection var_collectionvar4_list_coerced$ = null;
Object _dynamic_wcmmode = bindings.get("wcmmode");
Object _dynamic_resource = bindings.get("resource");
out.write("\n");
_global_accordion = renderContext.call("use", com.adobe.cq.wcm.core.components.models.Accordion.class.getName(), obj());
out.write("<div class=\"cmp-accordion\" data-cmp-is=\"accordion\"");
{
    Object var_attrvalue0 = renderContext.getObjectModel().resolveProperty(_global_accordion, "singleExpansion");
    {
        Object var_attrcontent1 = renderContext.call("xss", var_attrvalue0, "attribute");
        {
            Object var_shoulddisplayattr3 = ((renderContext.getObjectModel().toBoolean(var_attrcontent1) ? var_attrcontent1 : ("false".equals(var_attrvalue0))));
            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr3)) {
                out.write(" data-cmp-single-expansion");
                {
                    boolean var_istrueattr2 = (var_attrvalue0.equals(true));
                    if (!var_istrueattr2) {
                        out.write("=\"");
                        out.write(renderContext.getObjectModel().toString(var_attrcontent1));
                        out.write("\"");
                    }
                }
            }
        }
    }
}
out.write(">\n    ");
{
    boolean var_testvariable11 = (!(org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator.leq(renderContext.getObjectModel().resolveProperty(renderContext.getObjectModel().resolveProperty(_global_accordion, "items"), "size"), 0)));
    if (var_testvariable11) {
        {
            Object var_collectionvar4 = renderContext.getObjectModel().resolveProperty(_global_accordion, "items");
            {
                long var_size5 = ((var_collectionvar4_list_coerced$ == null ? (var_collectionvar4_list_coerced$ = renderContext.getObjectModel().toCollection(var_collectionvar4)) : var_collectionvar4_list_coerced$).size());
                {
                    boolean var_notempty6 = (var_size5 > 0);
                    if (var_notempty6) {
                        {
                            long var_end9 = var_size5;
                            {
                                boolean var_validstartstepend10 = (((0 < var_size5) && true) && (var_end9 > 0));
                                if (var_validstartstepend10) {
                                    if (var_collectionvar4_list_coerced$ == null) {
                                        var_collectionvar4_list_coerced$ = renderContext.getObjectModel().toCollection(var_collectionvar4);
                                    }
                                    long var_index12 = 0;
                                    for (Object item : var_collectionvar4_list_coerced$) {
                                        {
                                            long var_stepcondition13 = ((var_index12 - 0) % 1);
                                            {
                                                boolean var_traversal14 = (((var_index12 >= 0) && (var_index12 <= var_end9)) && (var_stepcondition13 == 0));
                                                if (var_traversal14) {
                                                    out.write("<div class=\"cmp-accordion__item\" data-cmp-hook-accordion=\"item\"");
                                                    {
                                                        boolean var_attrvalue15 = (org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator.inOp(renderContext.getObjectModel().resolveProperty(item, "name"), renderContext.getObjectModel().resolveProperty(_global_accordion, "expandedItems") instanceof String ? renderContext.getObjectModel().resolveProperty(_global_accordion, "expandedItems") : renderContext.getObjectModel().toCollection(renderContext.getObjectModel().resolveProperty(_global_accordion, "expandedItems"))));
                                                        {
                                                            Object var_attrcontent16 = renderContext.call("xss", var_attrvalue15, "attribute");
                                                            {
                                                                Object var_shoulddisplayattr18 = ((renderContext.getObjectModel().toBoolean(var_attrcontent16) ? var_attrcontent16 : ("false".equals(var_attrvalue15))));
                                                                if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr18)) {
                                                                    out.write(" data-cmp-expanded");
                                                                    {
                                                                        boolean var_istrueattr17 = (var_attrvalue15 == true);
                                                                        if (!var_istrueattr17) {
                                                                            out.write("=\"");
                                                                            out.write(renderContext.getObjectModel().toString(var_attrcontent16));
                                                                            out.write("\"");
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    out.write(">\n        ");
                                                    {
                                                        Object var_tagvar19 = renderContext.call("xss", renderContext.getObjectModel().resolveProperty(_global_accordion, "headingElement"), "elementName");
                                                        if (renderContext.getObjectModel().toBoolean(var_tagvar19)) {
                                                            out.write("<");
                                                            out.write(renderContext.getObjectModel().toString(var_tagvar19));
                                                        }
                                                        if (!renderContext.getObjectModel().toBoolean(var_tagvar19)) {
                                                            out.write("<h3");
                                                        }
                                                        out.write(" class=\"cmp-accordion__header\">\n            <button");
                                                        {
                                                            String var_attrcontent20 = ("cmp-accordion__button" + renderContext.getObjectModel().toString(renderContext.call("xss", ((org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator.inOp(renderContext.getObjectModel().resolveProperty(item, "name"), renderContext.getObjectModel().resolveProperty(_global_accordion, "expandedItems") instanceof String ? renderContext.getObjectModel().resolveProperty(_global_accordion, "expandedItems") : renderContext.getObjectModel().toCollection(renderContext.getObjectModel().resolveProperty(_global_accordion, "expandedItems")))) ? " cmp-accordion__button--expanded" : ""), "attribute")));
                                                            {
                                                                Object var_shoulddisplayattr21 = ((renderContext.getObjectModel().toBoolean(var_attrcontent20) ? var_attrcontent20 : ("false".equals(var_attrcontent20))));
                                                                if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr21)) {
                                                                    out.write(" class=\"");
                                                                    out.write(renderContext.getObjectModel().toString(var_attrcontent20));
                                                                    out.write("\"");
                                                                }
                                                            }
                                                        }
                                                        out.write(" data-cmp-hook-accordion=\"button\">\n                <span class=\"cmp-accordion__title\">");
                                                        {
                                                            Object var_22 = renderContext.call("xss", renderContext.getObjectModel().resolveProperty(item, "title"), "text");
                                                            out.write(renderContext.getObjectModel().toString(var_22));
                                                        }
                                                        out.write("</span>\n                <span class=\"cmp-accordion__icon\"></span>\n            </button>\n        ");
                                                        if (renderContext.getObjectModel().toBoolean(var_tagvar19)) {
                                                            out.write("</");
                                                            out.write(renderContext.getObjectModel().toString(var_tagvar19));
                                                            out.write(">");
                                                        }
                                                        if (!renderContext.getObjectModel().toBoolean(var_tagvar19)) {
                                                            out.write("</h3>");
                                                        }
                                                    }
                                                    out.write("\n        <div data-cmp-hook-accordion=\"panel\"");
                                                    {
                                                        String var_attrcontent23 = ("cmp-accordion__panel" + renderContext.getObjectModel().toString(renderContext.call("xss", ((org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator.inOp(renderContext.getObjectModel().resolveProperty(item, "name"), renderContext.getObjectModel().resolveProperty(_global_accordion, "expandedItems") instanceof String ? renderContext.getObjectModel().resolveProperty(_global_accordion, "expandedItems") : renderContext.getObjectModel().toCollection(renderContext.getObjectModel().resolveProperty(_global_accordion, "expandedItems")))) ? " cmp-accordion__panel--expanded" : " cmp-accordion__panel--hidden"), "attribute")));
                                                        {
                                                            Object var_shoulddisplayattr24 = ((renderContext.getObjectModel().toBoolean(var_attrcontent23) ? var_attrcontent23 : ("false".equals(var_attrcontent23))));
                                                            if (renderContext.getObjectModel().toBoolean(var_shoulddisplayattr24)) {
                                                                out.write(" class=\"");
                                                                out.write(renderContext.getObjectModel().toString(var_attrcontent23));
                                                                out.write("\"");
                                                            }
                                                        }
                                                    }
                                                    out.write(" role=\"region\">");
                                                    {
                                                        Object var_resourcecontent25 = renderContext.call("includeResource", renderContext.getObjectModel().resolveProperty(item, "name"), obj().with("decorationTagName", "div"));
                                                        out.write(renderContext.getObjectModel().toString(var_resourcecontent25));
                                                    }
                                                    out.write("</div>\n    </div>\n");
                                                }
                                            }
                                        }
                                        var_index12++;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            var_collectionvar4_list_coerced$ = null;
        }
    }
}
out.write("\n    ");
{
    Object var_testvariable26 = ((renderContext.getObjectModel().toBoolean(((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "edit")) ? renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "edit") : renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "preview")))) ? (org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator.lt(renderContext.getObjectModel().resolveProperty(renderContext.getObjectModel().resolveProperty(_global_accordion, "items"), "size"), 1)) : ((renderContext.getObjectModel().toBoolean(renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "edit")) ? renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "edit") : renderContext.getObjectModel().resolveProperty(_dynamic_wcmmode, "preview")))));
    if (renderContext.getObjectModel().toBoolean(var_testvariable26)) {
        {
            Object var_resourcecontent27 = renderContext.call("includeResource", renderContext.getObjectModel().resolveProperty(_dynamic_resource, "path"), obj().with("cssClassName", "new section aem-Grid-newComponent").with("decorationTagName", "div").with("appendPath", "/*").with("resourceType", "wcm/foundation/components/parsys/newpar"));
            out.write(renderContext.getObjectModel().toString(var_resourcecontent27));
        }
    }
}
out.write("\n</div>\n");


// End Of Main Template Body ----------------------------------------------------------------------
    }



    {
//Sub-Templates Initialization --------------------------------------------------------------------



//End of Sub-Templates Initialization -------------------------------------------------------------
    }

}

