<!--
Copyright 2017 Adobe

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->
Page (v2)
====
Extensible page component written in HTL.

## Features
* Editable templates
* Page title, subtitle, description and thumbnail
* Navigation title, or hide from navigation
* Vanity URL, page alias and redirection
* Page tagging and define content language
* On/Off time and launches
* Blueprints and live copy
* Closed user groups and permissions
* Cloud services

## Loading of CSS/JS
The page component automatically loads certain client libraries in the head section and at the end of the body section

Client Library Category or Path | Condition | Type | Head or Body
--- | --- | --- | ---
`cq.pagetypes.html5page`,`cq.authoring.page`,`cq.wcm.foundation-main`,`cq.shared` | only for `WCMMode`!=`Disabled` | JS and CSS | Head
libsScript from all referenced [cloud service configurations](https://docs.adobe.com/docs/en/aem/6-3/develop/extending/cloud-service-configurations.html), by default `headlibs.jsp` | only in case there is a lib script found for the referenced cloud service config | anything | Head
`<clientlibsJsHead>` being set in component policy | only if `<clientlibsJsHead>` is set | JS | Head
`<clientlibs>` being set in component policy | only if `<clientlibs>` is set | CSS | Head
`<designpath>.css` | only if design is set for current page | CSS | Head
`<clientlibs>` being set in component policy | only if `<clientlibs>` is set. Categories duplicated in `<clientlibsJsHead>` are only loaded in the page head. | JS | Body

## Use Object
The Page component uses the following use objects:
* `com.adobe.cq.wcm.core.components.models.Page`
* `com.adobe.cq.wcm.core.components.models.SocialMediaHelper`
* `com.day.cq.wcm.foundation.TemplatedContainer`

## Component Policy Configuration Properties
The following configuration properties are used:

1. `./clientlibs` - allows definition of a list of client libraries to be loaded by the pages associated with this policy configuration
2. `./clientlibsJsHead` - allows definition of client libraries for which JavaScript is specifically intended to be loaded
in the document head (JavaScript only) of pages associated with this policy configuration
3. `./appResourcesClientlib` - allows definition of the client library that is used to serve web resources such as favicons

## Edit Dialog Properties
The following properties are written to JCR for this Page component and are expected to be available as `Resource` properties:

1. `./jcr:title` - defines the title for this page
2. `pageName` - defines the page name for this page
3. `./cq:tags` - defines the tags for this page
4. `./hideInNav` - if set to `true` then this page will be hidden from navigation
5. `./pageTitle` - defines an alternate title for this page
6. `./navTitle` - defines the navigation title for this page
7. `./subtitle` - defines a subtitle for this page
8. `./jcr:description` - defines a description for this page
9.  `./onTime` - defines when the page should become available
10. `./offTime` - defines when the page should not be available any more
11. `./sling:vanityPath` - defines a vanity URL at which this page could be accessed
12. `./sling:redirect` - if set to `true`, then this page will redirect to its defined vanity URL
13. `./jcr:language` - defines the language set for this page, to help with `i18n`
14. `./cq:designPath` - defines where the design for this page is stored
15. `./sling:alias` - defines a Sling alias for this page, so that the page can be accessed at a different resource path
16. `./cq:allowedTemplates` - defines a template or a list of templates that the page should use
17. `./cq:exportTemplate` - defines the template used for exporting this page for content synchronisation
18. `./socialMedia` - defines the enabled social media configurations
19. `./variantPath` - allows defining the social media variation experience fragment to be used for generating page meta data for social
media
20. `./cq:contextHubPath` - defines the Context Path configuration used by this page
21. `./cq:contextHubSegmentsPath` - defines the Context Path Segments Path

## Web Resources Client Library
A web resources client library can be defined at the template level (see `./appResourcesClientlib` component policy configuration).
This client library has to provide the following structure:

```json
{
  "<client library folder>": {
    "jcr:primaryType": "cq:ClientLibraryFolder",
    "allowProxy": true,
    "categories": [
      "<category name>"
    ],
    "css.txt": {"jcr:primaryType": "nt:file"},
    "resources": {
      "jcr:primaryType": "nt:folder"
      }
  }
}
```

The following files are expected in the `resources` folder, for maximum compatibility:

Filename|Browser|Size
--------|-------|----
apple-touch-icon-180x180.png|Safari on iPhone| 180px x 180px
apple-touch-icon-167x167.png|Safari on iPad Pro| 167px x 167px
apple-touch-icon-152x152.png|Safari on iPad, iPad Mini| 152px x 152px
apple-touch-icon-120x120.png|Safari on iPhone| 120px x 120px
icon-192x192.png|Chrome, Opera|192px x 192px
icon-310x310.png|Internet Explorer, Edge and Windows Phone|310px x 310px
icon-310x150.png|Internet Explorer, Edge and Windows Phone|310px x 150px
icon-150x150.png|Internet Explorer, Edge and Windows Phone|150px x 150px
icon-70x70.png|Internet Explorer, Edge and Windows Phone|70px x 70px

## Client Libraries
The component provides a `core.wcm.components.page.v2.sharing` client library category that contains the JavaScript
required to enable social sharing. It should be added to a relevant site client library using the `embed` property.

It also provides a `core.wcm.components.page.v2.editor` editor client library category that includes JavaScript
handling for dialog interaction. It is already included by its edit dialog.

## Information
* **Vendor**: Adobe
* **Version**: v2
* **Compatibility**: AEM 6.3
* **Status**: production-ready
* **Documentation**: [https://www.adobe.com/go/aem\_cmp\_page\_v2](https://www.adobe.com/go/aem_cmp_page_v2)
