/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.utils;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.client.CQConfigManagerClient;
import com.adobe.cq.testing.client.CQSecurityClient;
import com.adobe.cq.testing.client.SecurityClient;
import com.adobe.cq.testing.client.TagClient;
import com.adobe.cq.testing.client.TemplateEditorManagerClient;
import com.adobe.cq.testing.client.security.Authorizable;
import com.adobe.cq.testing.client.security.CQAuthorizableManager;
import com.adobe.cq.testing.client.security.Group;
import com.adobe.cq.testing.client.security.User;
import com.adobe.cq.testing.selenium.Constants;
import com.adobe.cq.testing.selenium.utils.ResourceHelper;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.http.cookie.Cookie;
import org.apache.sling.testing.clients.ClientException;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestContentBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestContentBuilder.class);
    private static final String VAR_AUDIT_BASEPATH = "/var/audit/";
    private static final String VAR_AUDIT_WCM = "/var/audit/com.day.cq.wcm.core.page";
    private static final String VAR_AUDIT_DAM = "/var/audit/com.day.cq.dam";
    private static final String VAR_AUDIT_REPLICATION = "/var/audit/com.day.cq.replication";
    private static final String CLEANING_MSG = "Cleaning {}";
    private static final String CLEANING_TAG_MSG = "Cleaning Tag {}";
    private static final String DEFAULT_PAGE_TEMPLATE_TITLE = "Simple-Template";
    private static final String DEFAULT_PAGE_TEMPLATE_DESCRIPTION = "A Simple Template for IT tests";
    private final CQClient client;
    private final String label;
    private String parentTag;
    private String damRootPath;
    private String pageTemplatePath;
    private String topLevelResponsiveGridPath;
    private String contentRootPath;
    private String pageTemplateTitle = "Simple-Template";
    private String pageTemplateDescription = "A Simple Template for IT tests";
    private CQConfigManagerClient.CQConfig cqConfig;
    private String cqConfigPath;
    private String defaultUserName;
    private List<String> defaultGroups;
    private List<Group> groupsInternal;
    private String defaultPassword;
    private User defaultUser;
    private CQClient userClient;
    private String impersonator;
    private boolean withEmptyTemplateEnabled;
    private boolean withDefaultPoliciesEnabled;
    private CQConfigManagerClient.CQConfigCapability[] cqConfigCapabilities = new CQConfigManagerClient.CQConfigCapability[]{CQConfigManagerClient.CQConfigCapability.CONTENT_FRAGMENT_MODEL, CQConfigManagerClient.CQConfigCapability.EDITABLE_TEMPLATES};

    public TestContentBuilder(CQClient cqClient, String prefix) {
        this.client = cqClient;
        this.label = prefix + "_" + TestContentBuilder.randomSmallText();
    }

    public String getLabel() {
        return this.label;
    }

    public String getParentTag() {
        return this.parentTag;
    }

    public String getConfigPath() {
        return this.cqConfigPath;
    }

    public String getDefaultPageTemplatePath() {
        return this.pageTemplatePath;
    }

    public String getTopLevelComponentPath() {
        return this.topLevelResponsiveGridPath;
    }

    public String getDamRootPath() {
        return this.damRootPath;
    }

    public String getContentRootPath() {
        return this.contentRootPath;
    }

    public TestContentBuilder withEmptyTemplate() {
        this.withEmptyTemplateEnabled = true;
        return this;
    }

    public TestContentBuilder withDefaultPolicies() {
        this.withDefaultPoliciesEnabled = true;
        return this;
    }

    public TestContentBuilder withConfigCapabilities(CQConfigManagerClient.CQConfigCapability ... capabilities) {
        this.cqConfigCapabilities = capabilities;
        return this;
    }

    public TestContentBuilder withPageTemplateTitle(String title) {
        this.pageTemplateTitle = title;
        return this;
    }

    public TestContentBuilder withPageTemplateDescription(String description) {
        this.pageTemplateTitle = description;
        return this;
    }

    public TestContentBuilder withUser(String password, List<String> groups) {
        this.defaultGroups = groups != null ? groups : Collections.emptyList();
        this.defaultUserName = this.label;
        this.defaultPassword = password;
        this.groupsInternal = new ArrayList<Group>();
        return this;
    }

    public TestContentBuilder withImpersonator(String impersonator) {
        this.impersonator = impersonator;
        return this;
    }

    public void dispose() throws TestContentBuilderException {
        try {
            if (this.cqConfigPath != null) {
                LOGGER.info(CLEANING_MSG, (Object)this.cqConfigPath);
                this.client.deletePageWithRetry(this.cqConfigPath, true, false, Constants.DEFAULT_TIMEOUT, Constants.DEFAULT_RETRY_DELAY, new int[]{200});
                this.cleanupAudit(this.cqConfigPath);
            }
            if (this.damRootPath != null) {
                LOGGER.info(CLEANING_MSG, (Object)this.damRootPath);
                this.client.deletePageWithRetry(this.damRootPath, true, false, Constants.DEFAULT_TIMEOUT, Constants.DEFAULT_RETRY_DELAY, new int[]{200});
                this.cleanupAudit(this.damRootPath);
            }
            if (this.contentRootPath != null) {
                LOGGER.info(CLEANING_MSG, (Object)this.contentRootPath);
                this.client.deletePageWithRetry(this.contentRootPath, true, false, Constants.DEFAULT_TIMEOUT, Constants.DEFAULT_RETRY_DELAY, new int[]{200});
                this.cleanupAudit(this.contentRootPath);
            }
            if (this.parentTag != null) {
                LOGGER.info(CLEANING_TAG_MSG, (Object)this.parentTag);
                TagClient tagClient = (TagClient)this.client.adaptTo(TagClient.class);
                tagClient.deleteTag(this.parentTag, new int[0]);
            }
            if (this.defaultUser != null) {
                this.deleteGroups();
                this.deleteUser(this.defaultUser, this.defaultGroups.toArray(new String[0]));
                this.deletePathRetries("/home/users/" + this.getLabel());
                this.deletePathRetries("/home/groups/" + this.getLabel());
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Interrupted while building test content", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (ClientException e) {
            LOGGER.error("Error while building test content", (Throwable)e);
            throw new TestContentBuilderException("An error occured while disposing test content", e);
        }
    }

    private void deletePathRetries(String path) {
        LOGGER.info("Delete {} with retries", (Object)path);
        Awaitility.await().ignoreExceptions().until(() -> {
            this.client.deletePath(path, new int[0]);
            return true;
        });
    }

    public void cleanupAudit(String path) {
        String[] audits = new String[]{VAR_AUDIT_DAM, VAR_AUDIT_WCM, VAR_AUDIT_REPLICATION};
        Arrays.stream(audits).forEach(s -> {
            String auditPath = s + path;
            try {
                if (this.client.exists(auditPath)) {
                    Awaitility.await().untilAsserted(() -> this.client.deletePath(auditPath, new int[]{200}));
                }
            }
            catch (ClientException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        });
    }

    public void build() throws ClientException, InterruptedException, IOException, TimeoutException {
        this.createConfig();
        this.createDefaultPageTemplate();
        this.createDamRoot();
        this.createContentRoot();
        this.allowImsUserImpersonator();
        this.createDefaultTags();
        this.createDefaultUser();
    }

    private void allowImsUserImpersonator() {
        String imsUser = System.getenv("IMS_USER");
        if (imsUser != null) {
            this.impersonator = imsUser;
        }
    }

    private void createDamRoot() throws ClientException {
        this.damRootPath = this.client.createFolder(this.label.toLowerCase(), this.label, "/content/dam", new int[]{201}).getSlingPath();
        this.client.setPageProperty(this.damRootPath, "cq:conf", this.getConfigPath(), new int[0]);
    }

    private void createContentRoot() throws ClientException {
        this.contentRootPath = this.client.createFolder(this.label.toLowerCase(), this.label, "/content", new int[]{201}).getSlingPath();
        this.client.setPageProperty(this.contentRootPath, "cq:conf", this.getConfigPath(), new int[0]);
        this.client.setPageProperty(this.contentRootPath, "cq:allowedTemplates", this.pageTemplatePath, new int[0]);
    }

    private void createDefaultUser() throws ClientException, InterruptedException {
        if (this.defaultUserName != null) {
            this.defaultUser = this.createUniqueUser(this.defaultUserName, this.defaultPassword, this.defaultGroups.toArray(new String[0]));
        }
    }

    public User createUniqueUser(String username, String password, String ... groups) throws ClientException, InterruptedException {
        CQSecurityClient sClient = this.getCqSecurityClient();
        User newUser = sClient.createUser(username + "_" + TestContentBuilder.randomSmallText(), password, this.getLabel(), null, null, new int[]{201});
        LOGGER.info("Created user {} at path {}", (Object)newUser.getId(), (Object)newUser.getHomePath());
        CQAuthorizableManager manager = sClient.getManager();
        for (String groupName : groups) {
            Group group = manager.getGroup(groupName);
            Awaitility.await().ignoreExceptions().untilAsserted(() -> group.addMember((Authorizable)newUser, new int[0]));
            LOGGER.info("added {} to group {}", (Object)newUser.getId(), (Object)group.getId());
        }
        if (this.impersonator != null) {
            User[] impersonators = new User[]{new User((SecurityClient)sClient, this.impersonator)};
            newUser.addImpersonators(impersonators, new int[0]);
        }
        return newUser;
    }

    private void createDefaultPageTemplate() throws ClientException, IOException {
        TemplateEditorManagerClient tmplClient = (TemplateEditorManagerClient)this.client.adaptTo(TemplateEditorManagerClient.class);
        this.pageTemplatePath = tmplClient.createDefaultTemplate(this.getConfigPath(), this.pageTemplateTitle, this.pageTemplateDescription);
        tmplClient.enable(this.pageTemplatePath);
        if (!this.withEmptyTemplateEnabled) {
            this.topLevelResponsiveGridPath = tmplClient.createTopLevelDefaultContainer(this.pageTemplatePath, null);
            tmplClient.unlockStructureComponent(this.topLevelResponsiveGridPath);
            if (this.withDefaultPoliciesEnabled) {
                tmplClient.setComponentPolicy(this.topLevelResponsiveGridPath, "wcm/foundation/components/responsivegrid/default");
            } else {
                String policiesData = ResourceHelper.readResourceAsString("default-it-policies.json");
                tmplClient.importPolicy(this.cqConfigPath, policiesData);
                tmplClient.setComponentPolicy(this.topLevelResponsiveGridPath, "wcm/foundation/components/responsivegrid/it-default");
            }
        }
        LOGGER.info("Created Default Page Template {}", (Object)this.pageTemplatePath);
    }

    private void createConfig() throws ClientException, TimeoutException, InterruptedException {
        CQConfigManagerClient configManagerClient = (CQConfigManagerClient)this.client.adaptTo(CQConfigManagerClient.class);
        this.cqConfig = configManagerClient.create(this.label, this.cqConfigCapabilities);
        this.cqConfigPath = this.cqConfig.getPath();
        this.cqConfig.setWcmTemplatesPermissions();
        LOGGER.info("Created Config {}", (Object)this.cqConfigPath);
    }

    private void createDefaultTags() throws ClientException {
        TagClient tagClient = (TagClient)this.client.adaptTo(TagClient.class);
        this.parentTag = tagClient.createTag(this.label, this.label.toLowerCase(), null, null, new int[0]).getSlingPath();
        LOGGER.info("Created Tag root namespace under {}", (Object)this.parentTag);
    }

    public static String randomSmallText() {
        return RandomStringUtils.randomAlphabetic((int)8);
    }

    public static String randomSmallTextSearch() {
        return "__" + TestContentBuilder.randomSmallText() + "__";
    }

    public static String randomSmallTestLabel() {
        return "test" + TestContentBuilder.randomSmallText();
    }

    public static String randomSmallTestTitle() {
        return "Test" + TestContentBuilder.randomSmallText();
    }

    public User getUser() {
        assert (this.defaultUser != null);
        return this.defaultUser;
    }

    public String getUserName() {
        assert (this.defaultUser != null);
        return this.defaultUser.getId();
    }

    public String getUserHomePath() {
        assert (this.defaultUser != null);
        return this.defaultUser.getHomePath();
    }

    public Group createGroup(String groupPrefix) throws ClientException, InterruptedException {
        Group group = this.getCqSecurityClient().createGroup(groupPrefix + "_" + TestContentBuilder.randomSmallText(), this.getLabel(), null, null, null, new int[0]);
        LOGGER.info("Created group {} at path {}", (Object)group.getId(), (Object)group.getHomePath());
        this.groupsInternal.add(group);
        return group;
    }

    public void deleteUser(User user, String ... groups) throws ClientException {
        if (user != null) {
            LOGGER.info("Removing user: {} from groups:  {}", (Object)user.getHomePath(), (Object)groups);
            CQAuthorizableManager manager = this.getCqSecurityClient().getManager();
            for (String groupName : groups) {
                Group group = manager.getGroup(groupName);
                Awaitility.await().ignoreExceptions().untilAsserted(() -> group.removeMembers(new Authorizable[]{user}, new int[]{200}));
            }
            LOGGER.info("Deleting user:  {}", (Object)user.getHomePath());
            Awaitility.await().ignoreExceptions().untilAsserted(() -> user.delete(new int[0]));
        }
    }

    private void deleteGroups() {
        this.groupsInternal.forEach(internalGroup -> Awaitility.await().ignoreExceptions().untilAsserted(() -> internalGroup.delete(new int[]{200})));
        this.groupsInternal.clear();
    }

    public CQClient getClient() {
        return this.client;
    }

    public CQClient getDefaultUserClient() throws ClientException {
        if (this.userClient == null) {
            this.userClient = this.getUserClient(this.defaultUser, this.defaultPassword);
        }
        return this.userClient;
    }

    public CQClient getUserClient(User user, String password) throws ClientException {
        return CQClient.Builder.create((URI)this.client.getUrl(), (String)user.getId(), (String)password).build();
    }

    public Cookie getAffinityCookie() {
        return this.client.getCookieStore().getCookies().stream().filter(c -> c.getName().equals("affinity")).findFirst().orElse(null);
    }

    public String getAffinity() {
        Cookie affinityCookie = this.getAffinityCookie();
        return affinityCookie != null ? affinityCookie.getValue() : null;
    }

    public CQSecurityClient getCqSecurityClient() throws ClientException {
        return (CQSecurityClient)this.client.adaptTo(CQSecurityClient.class);
    }

    public static class TestContentBuilderException
    extends Exception {
        public TestContentBuilderException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

