/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.utils;

import com.codeborne.selenide.Selenide;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExpectNav {
    private static final Logger LOG = LoggerFactory.getLogger(ExpectNav.class);
    private static final String JS_NAV_START = "return performance.timing.navigationStart";

    private ExpectNav() {
    }

    public static void on(Runnable runnable) {
        long beforeTimeOrigin = ExpectNav.getNavigationStart();
        runnable.run();
        Selenide.Wait().until(webDriver -> {
            long actualTimeOrigin = ExpectNav.getNavigationStart();
            return actualTimeOrigin > beforeTimeOrigin;
        });
    }

    private static long getNavigationStart() {
        long timeOrigin = 0L;
        try {
            timeOrigin = (Long)Selenide.executeJavaScript((String)JS_NAV_START, (Object[])new Object[0]);
        }
        catch (ClassCastException e) {
            LOG.debug("Cast exception while reading navigationStart on browser", (Throwable)e);
        }
        return timeOrigin;
    }
}

