/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.utils;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ElementUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ElementUtils.class);
    public static final long DEFAULT_DELAY_BEFORE = 250L;
    private static final String MSG_ERR_CLICK_UNTIL = "Clicking on %s didn\u2019t fullfill the expected condition %s for %s";
    private static final long SHORT_TIMEOUT = 2000L;
    private static long delayBefore = 250L;
    private static int DEFAULT_TIMEOUT = 4000;

    private ElementUtils() {
    }

    public static void setDelayBefore(long newDelay) {
        delayBefore = newDelay;
    }

    public static void clickableClick(SelenideElement element) {
        ElementUtils.clickableClick(element, delayBefore);
    }

    public static void clickableClick(SelenideElement element, long delay) {
        Condition clickable = Condition.and((String)"can be clicked", (Condition)Condition.visible, (Condition)Condition.enabled, (Condition[])new Condition[0]);
        element.shouldBe(new Condition[]{clickable});
        ElementUtils.delayBefore(delay);
        Selenide.actions().moveToElement((WebElement)element).click().perform();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clickUntil(SelenideElement element, SelenideElement conditionalElement, Condition expectedCondition, long maxRetries, long pacing) throws TimeoutException {
        int retries = 0;
        boolean passed = false;
        while (!passed && (long)retries < maxRetries) {
            try {
                if (!passed) {
                    Selenide.sleep((long)pacing);
                    element.should(new Condition[]{Condition.exist});
                    try {
                        Selenide.actions().moveToElement((WebElement)element).click().perform();
                    }
                    catch (StaleElementReferenceException ex) {
                        LOG.warn("Error on click action: " + ex.getMessage());
                    }
                }
                if (conditionalElement.has(expectedCondition)) {
                    passed = true;
                }
                try {
                    Awaitility.await().pollInSameThread().timeout(Duration.ofMillis(2000L)).until(() -> conditionalElement.has(expectedCondition));
                    passed = true;
                }
                catch (ConditionTimeoutException ex) {
                    LOG.info("ConditionTimeout " + expectedCondition);
                }
            }
            catch (JavascriptException e) {
                LOG.error("Error due to {}", (Object)e.getMessage());
            }
            finally {
                ++retries;
            }
        }
        if (!passed) {
            String screenshotFileName = "clickUntilTimeout-" + System.currentTimeMillis();
            Selenide.screenshot((String)screenshotFileName);
            LOG.error("Timeout reached, created screenshot {}", (Object)screenshotFileName);
            throw new TimeoutException(String.format(MSG_ERR_CLICK_UNTIL, element.toString(), expectedCondition.toString(), conditionalElement.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasWithPolling(SelenideElement element, Condition condition, int timeout) {
        boolean result = false;
        try {
            Awaitility.await().pollInSameThread().timeout(Duration.ofMillis(timeout)).until(() -> element.has(condition));
            result = true;
            return result;
        }
        catch (ConditionTimeoutException ex) {
            LOG.info("ConditionTimeout " + condition);
        }
        finally {
            return result;
        }
    }

    public static boolean hasWithPolling(SelenideElement element, Condition condition) {
        return ElementUtils.hasWithPolling(element, condition, DEFAULT_TIMEOUT);
    }

    public static void delayBefore() {
        ElementUtils.delayBefore(delayBefore);
    }

    public static void delayBefore(long delay) {
        Selenide.sleep((long)delay);
    }
}

