/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.granite;

import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralCheckbox;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralQuickActions;
import com.adobe.cq.testing.selenium.pagewidgets.granite.Collection;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;

public final class Masonry
extends Collection {
    public Masonry(String selector) {
        super(selector);
        this.setAllItemsSelector(selector + " coral-masonry-item");
        this.setLazyLoadingSupported(true);
        this.setHasMoreElementsSelector(selector + " + .granite-collection-loading-title-wrapper .granite-collection-loading-title");
    }

    public Collection scrollToEnd() {
        ElementsCollection elements = this.getItems();
        int size = elements.size();
        if (size > 0) {
            elements.get(size - 1).scrollIntoView("");
        }
        return this;
    }

    @Override
    protected Collection toggleItem(SelenideElement item) {
        CoralCheckbox coralCheckbox = new CoralCheckbox(item);
        if (coralCheckbox.isVisible()) {
            coralCheckbox.click();
        } else {
            item.hover();
            if (coralCheckbox.isVisible()) {
                coralCheckbox.click();
            } else {
                ElementUtils.clickableClick(new CoralQuickActions().getQuickAction("check"));
            }
        }
        return this;
    }

    public Collection scrollToTop() {
        ElementsCollection elements = this.getItems();
        int size = elements.size();
        if (size > 0) {
            elements.get(0).scrollIntoView("");
        }
        return this;
    }
}

