/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.granite;

import com.adobe.cq.testing.selenium.Constants;
import com.adobe.cq.testing.selenium.pagewidgets.common.AEMBaseComponent;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralCheckbox;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralColumnPreview;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralColumnviewItemThumbnail;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;

public class Collection
extends AEMBaseComponent {
    public static final String COLLECTION_ITEM_ID_ATTRIBUTE = "data-foundation-collection-item-id";
    public static final String DEFAULT_ITEM_SELECTOR_PATTERN = "%s .foundation-collection-item[data-foundation-collection-item-id='%s']";
    public static final String DEFAULT_ALLITEMS_SELECTOR = ".foundation-collection-item";
    private static final UnsupportedOperationException UNSUPPORTED_OPERATION = new UnsupportedOperationException("Unsupported operation");
    private boolean isLazyLoadingSupported = false;
    private String hasMoreElementsSelector = "fake";
    private String lazyItemClass = "is-lazyLoaded";
    private String pendingItemClass = "is-pending";
    private String itemSelectorPattern = "%s .foundation-collection-item[data-foundation-collection-item-id='%s']";
    private String allItemsSelector = ".foundation-collection-item";

    public Collection(String selector) {
        super(selector);
    }

    public String getId() {
        return this.element().getAttribute("data-foundation-collection-id");
    }

    public ElementsCollection getItems() {
        ElementsCollection list = this.element().$$(this.allItemsSelector);
        list.forEach(item -> item.shouldBe(Constants.EXISTS_ENABLED_VISIBLE));
        return list;
    }

    public ElementsCollection getSelectedItems() {
        return this.element().$$(".foundation-selections-item");
    }

    public Collection toggleSelectionItem(String ... collectionItemID) {
        for (String id : collectionItemID) {
            SelenideElement item = this.getCollectionItem(id);
            this.toggleItem(item);
        }
        return this;
    }

    public boolean isSelectable(String collectionItemID) {
        SelenideElement item = this.getCollectionItem(collectionItemID);
        CoralCheckbox coralCheckbox = new CoralCheckbox(item);
        return coralCheckbox.isVisible();
    }

    protected Collection toggleItem(SelenideElement item) {
        new CoralCheckbox(item).click();
        return this;
    }

    public Collection selectItem(String ... collectionItemID) {
        for (String id : collectionItemID) {
            SelenideElement item = this.getCollectionItem(id);
            CoralCheckbox coralCheckbox = new CoralCheckbox(item);
            if (coralCheckbox.isChecked()) continue;
            this.toggleItem(item);
        }
        return this;
    }

    public Collection deselectItem(String ... collectionItemID) {
        for (String id : collectionItemID) {
            SelenideElement item = this.getCollectionItem(id);
            CoralCheckbox coralCheckbox = new CoralCheckbox(item);
            if (!coralCheckbox.isChecked()) continue;
            this.toggleItem(item);
        }
        return this;
    }

    public Collection selectThumbnailItem(String ... collectionItemID) {
        for (String id : collectionItemID) {
            SelenideElement item = this.getCollectionItem(id);
            CoralColumnviewItemThumbnail coralColumnviewItemThumbnail = new CoralColumnviewItemThumbnail(item);
            if (coralColumnviewItemThumbnail.isSelected()) continue;
            coralColumnviewItemThumbnail.click();
        }
        return this;
    }

    public Collection deselectThumbnailItem(String ... collectionItemID) {
        for (String id : collectionItemID) {
            SelenideElement item = this.getCollectionItem(id);
            CoralColumnviewItemThumbnail coralColumnviewItemThumbnail = new CoralColumnviewItemThumbnail(item);
            if (!coralColumnviewItemThumbnail.isSelected()) continue;
            coralColumnviewItemThumbnail.click();
        }
        return this;
    }

    public SelenideElement getCollectionItem(String collectionItemID) {
        String collectionItemSelector = this.getItemSelector(collectionItemID);
        SelenideElement collectionItemElement = Selenide.$((String)collectionItemSelector).shouldBe(Constants.EXISTS_ENABLED_VISIBLE);
        collectionItemElement.scrollTo();
        return collectionItemElement;
    }

    public boolean hasCollectionItem(String collectionItemID) {
        String collectionItemSelector = this.getItemSelector(collectionItemID);
        return Selenide.$((String)collectionItemSelector).exists();
    }

    public Collection selectActionOnCollectionItem(String collectionItemID, String actionTitle) {
        String collectionItemSelector = this.getItemSelector(collectionItemID);
        Selenide.$((String)collectionItemSelector).shouldBe(Constants.EXISTS_ENABLED_VISIBLE).scrollTo();
        String jsScript = "document.querySelector(arguments[0] + \" > coral-card\").trigger(\"mouseenter\")";
        Selenide.executeJavaScript((String)"document.querySelector(arguments[0] + \" > coral-card\").trigger(\"mouseenter\")", (Object[])new Object[]{collectionItemSelector});
        ElementUtils.clickableClick(Selenide.$((String)(collectionItemSelector + " coral-quickactions button[aria-label='" + actionTitle + "']")));
        return this;
    }

    private String getSelectorForItemAtIndexHavingClass(int index, String cssClass) {
        if (!this.isLazyLoadingSupported) {
            throw UNSUPPORTED_OPERATION;
        }
        return this.getCssSelector() + " .foundation-collection-item." + cssClass + "[data-datasource-index='" + index + "']";
    }

    private String getSelectorForItemAtIndex(int index) {
        if (!this.isLazyLoadingSupported) {
            throw UNSUPPORTED_OPERATION;
        }
        return this.getCssSelector() + " .foundation-collection-item[data-datasource-index='" + index + "']";
    }

    public boolean hasItemAtIndex(int index) {
        if (!this.isLazyLoadingSupported) {
            throw UNSUPPORTED_OPERATION;
        }
        return Selenide.$((String)this.getSelectorForItemAtIndex(index)).isDisplayed();
    }

    public boolean hasLazyItemAtIndex(int index) {
        if (!this.isLazyLoadingSupported) {
            throw UNSUPPORTED_OPERATION;
        }
        return Selenide.$((String)this.getSelectorForItemAtIndexHavingClass(index, this.lazyItemClass)).isDisplayed();
    }

    public boolean hasPendingItemAtIndex(int index) {
        if (!this.isLazyLoadingSupported) {
            throw UNSUPPORTED_OPERATION;
        }
        return Selenide.$((String)this.getSelectorForItemAtIndexHavingClass(index, this.pendingItemClass)).isDisplayed();
    }

    public boolean hasMoreElements() {
        if (!this.isLazyLoadingSupported) {
            throw UNSUPPORTED_OPERATION;
        }
        return Selenide.$((String)this.hasMoreElementsSelector).should(new Condition[0]).isDisplayed();
    }

    public Collection waitForLoadingItemAtIndex(int index) {
        if (!this.isLazyLoadingSupported) {
            throw UNSUPPORTED_OPERATION;
        }
        Selenide.Wait().until(webdriver -> this.hasItemAtIndex(index) && !this.hasLazyItemAtIndex(index) && !this.hasPendingItemAtIndex(index));
        return this;
    }

    public Collection activate(String itemId) {
        this.waitForItem(itemId, false);
        ElementUtils.clickableClick(this.getCollectionItem(itemId));
        return this;
    }

    public Collection waitForItem(String itemId, boolean reverse) {
        String selector = this.getItemSelector(itemId);
        if (reverse) {
            Selenide.$((String)selector).shouldNot(new Condition[]{Condition.exist});
        } else {
            Selenide.$((String)selector).should(new Condition[]{Condition.exist});
        }
        return this;
    }

    public Collection waitForItemPreview(String itemId) {
        Selenide.$((String)("coral-columnview-preview[data-foundation-layout-columnview-columnid='" + itemId + "']")).should(new Condition[]{Condition.exist});
        return this;
    }

    public CoralColumnPreview columnPreview() {
        return new CoralColumnPreview();
    }

    public boolean isLazyLoadingSupported() {
        return this.isLazyLoadingSupported;
    }

    public Collection setLazyLoadingSupported(boolean lazyLoadingSupported) {
        this.isLazyLoadingSupported = lazyLoadingSupported;
        return this;
    }

    public String getHasMoreElementsSelector() {
        return this.hasMoreElementsSelector;
    }

    public Collection setHasMoreElementsSelector(String selector) {
        this.hasMoreElementsSelector = selector;
        return this;
    }

    public String getLazyItemClass() {
        return this.lazyItemClass;
    }

    public Collection setLazyItemClass(String selector) {
        this.lazyItemClass = selector;
        return this;
    }

    public String getPendingItemClass() {
        return this.pendingItemClass;
    }

    public Collection setPendingItemClass(String cssClass) {
        this.pendingItemClass = cssClass;
        return this;
    }

    private String getItemSelector(String collectionItemID) {
        return String.format(this.itemSelectorPattern, this.getCssSelector(), collectionItemID);
    }

    public Collection setItemSelectorPattern(String itemSelectorPattern) {
        this.itemSelectorPattern = itemSelectorPattern;
        return this;
    }

    public Collection setAllItemsSelector(String allItemsSelector) {
        this.allItemsSelector = String.format(allItemsSelector, this.getCssSelector());
        return this;
    }
}

