/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.cq.actions;

import com.adobe.cq.testing.selenium.pagewidgets.common.AEMBaseComponent;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralPopOver;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;

public class CreateActions
extends AEMBaseComponent {
    public CreateActions() {
        super("button.granite-collection-create.foundation-toggleable-control");
    }

    public ElementsCollection getActions() {
        CoralPopOver popOver = CoralPopOver.firstOpened();
        return popOver.element().$$("[is=\"coral-anchorlist-item\"]");
    }

    public SelenideElement getAction(CreateActionType createActionType) {
        CoralPopOver popOver = CoralPopOver.firstOpened();
        String cssClass = createActionType.getCssClass();
        String selector = cssClass != null ? "." + cssClass : String.format("[rel=\"%s\"]", createActionType.getRel());
        return popOver.element().$(selector);
    }

    public static enum DAMCreateActionType implements CreateActionType
    {
        FOLDER("dam-create-folder"),
        UPLOAD_FILES("cq-damadmin-admin-assets-upload"),
        CONTENT_FRAGMENT("dam-create-fragment"),
        LIVE_COPY("cq-damadmin-admin-actions-createlivecopy"),
        METADATA("dam-import-metadata");

        private String cssClass;

        private DAMCreateActionType(String cssClass) {
            this.cssClass = cssClass;
        }

        @Override
        public String getRel() {
            return null;
        }

        @Override
        public String getCssClass() {
            return this.cssClass;
        }
    }

    public static enum SitesCreateActionType implements CreateActionType
    {
        PAGE("cq-siteadmin-admin-createpage"),
        SITE("cq-siteadmin-admin-createsite"),
        LIVE_COPY("cq-siteadmin-admin-createlivecopy"),
        LAUNCH("cq-siteadmin-admin-createlaunch"),
        LANGUAGE_COPY("cq-siteadmin-admin-createlanguagecopy"),
        FOLDER("cq-siteadmin-admin-createfolder"),
        CSV_REPORT("cq-siteadmin-admin-createcsvreport");

        private final String rel;

        private SitesCreateActionType(String relname) {
            this.rel = relname;
        }

        @Override
        public String getRel() {
            return this.rel;
        }

        @Override
        public String getCssClass() {
            return null;
        }
    }

    public static interface CreateActionType {
        public String getRel();

        public String getCssClass();
    }
}

