/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.coral;

import com.adobe.cq.testing.selenium.pagewidgets.Helpers;
import com.codeborne.selenide.Selenide;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CoralReady {
    private static final Logger LOG = LoggerFactory.getLogger(CoralReady.class);
    private static final int DOM_POLLING_INTERVAL = 250;
    private static final String JS_CORAL_READY_CONDITION = "window && window.Coral && window.Coral.commons && window.Coral.commons.ready && true";
    private static final String JS_CORAL_READY_SCRIPT = "if (%s) {%nwindow.Coral.commons.ready('%s', arguments[0])}%n";

    private CoralReady() {
    }

    public static boolean assertCoralReadyCondition() {
        return Boolean.TRUE.equals(Selenide.executeJavaScript((String)"return window && window.Coral && window.Coral.commons && window.Coral.commons.ready && true", (Object[])new Object[0]));
    }

    public static <T> T openReady(String absoluteOrRelavive, Class<T> pageObject) {
        LOG.info("openReady({})", (Object)absoluteOrRelavive);
        Object open = Selenide.open((String)absoluteOrRelavive, pageObject);
        CoralReady.waitCoralReady();
        return (T)open;
    }

    public static void waitCoralReady() {
        CoralReady.waitCoralReady("body");
    }

    public static void waitCoralReady(String selector) {
        LOG.info("waitCoralReady({})", (Object)selector);
        Selenide.Wait().until(webdriver -> CoralReady.assertCoralReadyCondition());
        LOG.debug("CoralReady Precondition checked");
        Selenide.executeAsyncJavaScript((String)String.format(JS_CORAL_READY_SCRIPT, JS_CORAL_READY_CONDITION, selector), (Object[])new Object[0]);
        LOG.debug("CoralReady checked");
        Helpers.waitDOMIdled(250L);
    }
}

