/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.common;

import com.adobe.cq.testing.selenium.pagewidgets.common.BaseComponent;
import com.adobe.cq.testing.selenium.utils.ExpectNav;
import com.codeborne.selenide.SelenideElement;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionComponent<V>
extends BaseComponent {
    private final Logger LOG = LoggerFactory.getLogger(ActionComponent.class);
    private Callable<V> callable;
    private boolean expectNavOnPerform;

    public ActionComponent(SelenideElement element) {
        super(element);
    }

    public ActionComponent(String selector) {
        super(selector);
    }

    public ActionComponent(SelenideElement element, Callable<V> callableCode, boolean expectNav) {
        super(element);
        this.callable = callableCode;
        this.expectNavOnPerform = expectNav;
    }

    public ActionComponent(String selector, Callable<V> callableCode, boolean expectNav) {
        super(selector);
        this.callable = callableCode;
        this.expectNavOnPerform = expectNav;
    }

    public V perform() {
        if (this.expectNavOnPerform) {
            ExpectNav.on(() -> this.click());
        } else {
            this.click();
        }
        return this.afterClick();
    }

    protected V afterClick() {
        V o = null;
        try {
            if (this.callable != null) {
                o = this.callable.call();
            }
        }
        catch (Exception e) {
            this.LOG.error("Could not instantiate due to exception", (Throwable)e);
        }
        return o;
    }
}

