/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pageobject.granite;

import com.adobe.cq.testing.selenium.pageobject.granite.ShellPage;
import com.adobe.cq.testing.selenium.pagewidgets.Helpers;
import com.adobe.cq.testing.selenium.pagewidgets.common.AEMBaseComponent;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;

public class StartPage
extends ShellPage {
    private static final String START_PAGE_PATH = "/aem/start.html";
    private static final SelenideElement NAVIGATION_BUTTON = Selenide.$((String)"coral-tab[icon='compass']");
    private static final SelenideElement TOOLS_BUTTON = Selenide.$((String)"coral-tab[icon='hammer']");

    public StartPage() {
        super(null, START_PAGE_PATH);
    }

    public StartPage clickNavigationButton() {
        return this.clickButton(NAVIGATION_BUTTON);
    }

    public StartPage clickToolsButton() {
        return this.clickButton(TOOLS_BUTTON);
    }

    private StartPage clickButton(SelenideElement button) {
        ElementUtils.clickableClick(button);
        return this;
    }

    public void clickToolItemCard(ToolItemCard toolItemCard) {
        ElementUtils.clickableClick(Selenide.$((String)toolItemCard.getSelector()));
    }

    public void closeNewsletter() {
        AEMBaseComponent newsletter = new AEMBaseComponent(".vex-close");
        Helpers.executeIfPresent(newsletter.element(), 1000L, 5L, () -> newsletter.click());
    }

    public void clickNavigationGroup(ToolsGroup toolsGroup) {
        ElementUtils.clickableClick(Selenide.$((String)toolsGroup.getSelector()));
    }

    public static enum ToolsGroup {
        GENERAL("/mnt/overlay/cq/core/content/nav/tools/general"),
        WORKFLOW("/mnt/overlay/cq/core/content/nav/tools/workflow"),
        SITES("/mnt/overlay/cq/core/content/nav/tools/sites"),
        ASSETS("/mnt/overlay/cq/core/content/nav/tools/assets"),
        RESOURCES("/mnt/overlay/cq/core/content/nav/tools/resources"),
        DEPLOYMENT("/mnt/overlay/cq/core/content/nav/tools/deployment"),
        SECURITY("/mnt/overlay/cq/core/content/nav/tools/security"),
        CLOUD_SERVICES("/mnt/overlay/cq/core/content/nav/tools/cloudservices"),
        OPERATIONS("/mnt/overlay/cq/core/content/nav/tools/operations");

        private final String id;

        private ToolsGroup(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String getSelector() {
            return "coral-card[data-foundation-collection-item-id='" + this.getId() + "']";
        }
    }

    public static enum ToolItemCard {
        CRXDE_LITE("/mnt/overlay/cq/core/content/nav/tools/general/crxdelite", ToolsGroup.GENERAL),
        SEARCH_FORMS("/mnt/overlay/cq/core/content/nav/tools/general/customsearchfacets", ToolsGroup.GENERAL),
        TAGGING("/mnt/overlay/cq/core/content/nav/tools/general/tagging", ToolsGroup.GENERAL),
        TEMPLATES("/mnt/overlay/cq/core/content/nav/tools/general/templates", ToolsGroup.GENERAL),
        COMPONENTS("/mnt/overlay/cq/core/content/nav/tools/general/components", ToolsGroup.GENERAL),
        CONFIGURATION_BROWSER("/mnt/overlay/cq/core/content/nav/tools/general/configuration-browser", ToolsGroup.GENERAL),
        TRANSLATION_CONFIGURATION("/mnt/overlay/cq/core/content/nav/tools/general/translationRules", ToolsGroup.GENERAL),
        JOBS("/mnt/overlay/cq/core/content/nav/tools/general/asyncjobs", ToolsGroup.GENERAL),
        BLUEPRINTS("/mnt/overlay/cq/core/content/nav/tools/sites/blueprints", ToolsGroup.SITES),
        LAUNCHES("/mnt/overlay/cq/core/content/nav/tools/sites/launches", ToolsGroup.SITES),
        CONTEXTHUB("/mnt/overlay/cq/core/content/nav/tools/sites/contexthub", ToolsGroup.SITES),
        EXTERNAL_LINK_CHECKER("/mnt/overlay/cq/core/content/nav/tools/sites/linkchecker", ToolsGroup.SITES);

        private final String collectionItemId;
        private final ToolsGroup group;

        private ToolItemCard(String collectionItemId, ToolsGroup group) {
            this.collectionItemId = collectionItemId;
            this.group = group;
        }

        public String getCollectionItemId() {
            return this.collectionItemId;
        }

        public ToolsGroup getGroup() {
            return this.group;
        }

        public String getSelector() {
            return "coral-masonry-item[data-foundation-collection-item-id='" + this.getCollectionItemId() + "']";
        }
    }
}

